/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import qupath.lib.gui.scripting.richtextfx.stylers.GroovyStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ImageJMacroStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.JavaStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.JsonStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.MarkdownStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.PlainStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.PropertiesStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.PythonStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.XmlStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.YamlStyler;
import qupath.lib.scripting.languages.ScriptLanguage;

public class ScriptStylerProvider {
    private static ServiceLoader<ScriptStyler> serviceLoader = ServiceLoader.load(ScriptStyler.class);
    public static final ScriptStyler PLAIN = new PlainStyler();
    public static final ScriptStyler MARKDOWN = new MarkdownStyler();
    public static final ScriptStyler GROOVY = new GroovyStyler();
    public static final ScriptStyler JAVA = new JavaStyler();
    public static final ScriptStyler JSON = new JsonStyler();
    public static final ScriptStyler IMAGEJ_MACRO = new ImageJMacroStyler();
    public static final ScriptStyler PROPERTIES = new PropertiesStyler();
    public static final ScriptStyler PYTHON = new PythonStyler();
    public static final ScriptStyler XML = new XmlStyler();
    public static final ScriptStyler YAML = new YamlStyler();
    private static Set<ScriptStyler> availableStylers = ScriptStylerProvider.loadAvailableStylers();
    private static final Pattern PATTERN_NEWLINES = Pattern.compile("^|\\n");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<ScriptStyler> loadAvailableStylers() {
        LinkedHashSet<ScriptStyler> stylers = new LinkedHashSet<ScriptStyler>();
        ServiceLoader<ScriptStyler> serviceLoader = ScriptStylerProvider.serviceLoader;
        synchronized (serviceLoader) {
            for (ScriptStyler s : ScriptStylerProvider.serviceLoader) {
                stylers.add(s);
            }
        }
        stylers.add(PLAIN);
        stylers.add(GROOVY);
        stylers.add(JAVA);
        stylers.add(MARKDOWN);
        stylers.add(JSON);
        stylers.add(IMAGEJ_MACRO);
        stylers.add(PYTHON);
        stylers.add(PROPERTIES);
        stylers.add(XML);
        stylers.add(YAML);
        return stylers;
    }

    public static ScriptStyler getStylerFromLanguage(ScriptLanguage language) {
        String name = language.getName().toLowerCase();
        for (ScriptStyler s : availableStylers) {
            for (String supported : s.getLanguageNames()) {
                if (!name.equalsIgnoreCase(supported)) continue;
                return s;
            }
        }
        return PLAIN;
    }

    public static StyleSpans<Collection<String>> getPlainStyling(String text) {
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        spansBuilder.add(Collections.emptyList(), text.length());
        return spansBuilder.create();
    }

    public static StyleSpans<Collection<String>> getLogStyling(String text) {
        StyleSpansCollectionBuilder builder = new StyleSpansCollectionBuilder(text);
        Map<String, String> logClassMap = Map.of("INFO:", "info", "WARN:", "warn", "ERROR:", "error", "DEBUG:", "debug", "TRACE:", "trace");
        Set<String> logKeys = logClassMap.keySet();
        Matcher matcher = PATTERN_NEWLINES.matcher(text);
        int start = 0;
        int len = text.length();
        String nextStyle = null;
        String lastStyle = null;
        while (start < len) {
            for (String key : logKeys) {
                int keyLength = key.length();
                if (start + keyLength >= len || !text.regionMatches(start, key, 0, keyLength)) continue;
                nextStyle = logClassMap.get(key);
                break;
            }
            if (nextStyle != null || !Objects.equals(nextStyle, lastStyle)) {
                builder.appendStyle(start);
                if (lastStyle != null) {
                    builder.popStyle();
                }
                builder.pushStyle(nextStyle);
                lastStyle = nextStyle;
            }
            if (!matcher.find()) break;
            start = matcher.start() + 1;
        }
        builder.appendStyle(len, true);
        StyleSpans styles = builder.spansBuilder.create();
        return styles;
    }

    static class StyleSpansCollectionBuilder {
        private String text;
        private StyleSpansBuilder<Collection<String>> spansBuilder = new StyleSpansBuilder();
        private int[] lineSums;
        private int lastInd;
        private Deque<String> currentStyle = new ArrayDeque<String>();

        StyleSpansCollectionBuilder(String text) {
            this.text = text;
            int[] lengths = text.lines().mapToInt(l -> l.length() + 1).toArray();
            this.lineSums = new int[lengths.length + 1];
            for (int i = 0; i < lengths.length; ++i) {
                this.lineSums[i + 1] = this.lineSums[i] + lengths[i];
            }
        }

        public StyleSpans<Collection<String>> buildStyles() {
            this.appendStyle(this.text.length(), true);
            return this.spansBuilder.create();
        }

        public void appendStyle(int untilInd) {
            this.appendStyle(untilInd, false);
        }

        public void pushStyle(String style) {
            this.currentStyle.push(style);
        }

        public String popStyle() {
            return this.currentStyle.pop();
        }

        public void appendStyle(int untilInd, boolean lastStyle) {
            if (untilInd > this.lastInd || lastStyle) {
                if (this.currentStyle.isEmpty()) {
                    this.spansBuilder.add(Collections.emptyList(), untilInd - this.lastInd);
                } else if (this.currentStyle.size() == 1) {
                    this.spansBuilder.add(Collections.singletonList(this.currentStyle.peek()), untilInd - this.lastInd);
                } else {
                    this.spansBuilder.add(new ArrayList<String>(this.currentStyle), untilInd - this.lastInd);
                }
            } else {
                if (untilInd == this.lastInd) {
                    return;
                }
                throw new IllegalArgumentException("Cannot append empty style from " + this.lastInd + "-" + untilInd + " (must be ascending)");
            }
            this.lastInd = untilInd;
        }
    }
}

