/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerTools;

public class PythonStyler
implements ScriptStyler {
    private static final Logger logger = LoggerFactory.getLogger(PythonStyler.class);
    private static final String[] KEYWORDS = new String[]{"False", "None", "True", "and", "as", "assert", "async", "await", "break", "class", "continue", "def", "del", "elif", "else", "except", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "nonlocal", "not", "or", "pass", "raise", "return", "try", "while", "with", "yield"};
    private static Pattern PATTERN;

    PythonStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("python", "jython", "cpython", "python py4j", "graalpy");
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        int longLine = ScriptStylerTools.DEFAULT_LONG_LINE_LENGTH;
        if (ScriptStylerTools.containsLongLines(text, longLine)) {
            LogTools.logOnce((Logger)logger, (String)("Text contains lines longer than " + longLine + " - no styling will be applied"));
            return ScriptStylerProvider.getPlainStyling(text);
        }
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD") != null ? "keyword" : (matcher.group("PAREN") != null ? "paren" : (matcher.group("BRACE") != null ? "brace" : (matcher.group("BRACKET") != null ? "bracket" : (matcher.group("SEMICOLON") != null ? "semicolon" : (matcher.group("TRIPLEQUOTES") != null ? "string" : (matcher.group("DOUBLEQUOTES") != null ? "string" : (matcher.group("SINGLEQUOTES") != null ? "string" : (styleClass = matcher.group("COMMENT") != null ? "comment" : null))))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    @Override
    public StyleSpans<Collection<String>> computeConsoleStyles(String text, boolean logConsole) {
        return ScriptStylerProvider.getLogStyling(text);
    }

    static {
        String KEYWORD_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS) + ")\\b";
        String PAREN_PATTERN = "\\(|\\)";
        String BRACE_PATTERN = "\\{|\\}";
        String BRACKET_PATTERN = "\\[|\\]";
        String SEMICOLON_PATTERN = "\\;";
        String TRIPLE_QUOTE_PATTERN = "\"\"\"([^\"\"\"\\\\]|\\\\.)*\"\"\"";
        String DOUBLE_QUOTE_PATTERN = "\"([^\"\\\\]|\\\\.)*\"";
        String SINGLE_QUOTE_PATTERN = "'([^'\\\\]|\\\\.)*'";
        String COMMENT_PATTERN = "#[^\n]*";
        PATTERN = Pattern.compile("(?<KEYWORD>" + KEYWORD_PATTERN + ")|(?<PAREN>\\(|\\))|(?<BRACE>\\{|\\})|(?<BRACKET>\\[|\\])|(?<SEMICOLON>\\;)|(?<TRIPLEQUOTES>\"\"\"([^\"\"\"\\\\]|\\\\.)*\"\"\")|(?<DOUBLEQUOTES>\"([^\"\\\\]|\\\\.)*\")|(?<SINGLEQUOTES>'([^'\\\\]|\\\\.)*')|(?<COMMENT>#[^\n]*)");
    }
}

