/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.Collection;
import java.util.Set;
import org.fxmisc.richtext.model.StyleSpans;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.richtextfx.stylers.StyleSpanVisitor;

public class PropertiesStyler
implements ScriptStyler {
    PropertiesStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("properties", "config", "cfg");
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        StyleSpanVisitor visitor = new StyleSpanVisitor(text);
        String[] lines = text.split("\n");
        int ind = 0;
        boolean isContinuation = false;
        for (String line : lines) {
            String stripped = line.strip();
            if (isContinuation) {
                if (PropertiesStyler.lineContinues(stripped)) continue;
                isContinuation = false;
            } else if (PropertiesStyler.isComment(stripped)) {
                visitor.push("comment");
            } else if (PropertiesStyler.isConfigHeader(line)) {
                visitor.push("keyword");
            } else {
                int indSplit = PropertiesStyler.findSplitIndex(line);
                if (indSplit < 0) {
                    visitor.push("error");
                } else {
                    visitor.push("text");
                    visitor.appendStyle(ind + indSplit);
                    visitor.pop();
                    visitor.push("semicolon");
                    visitor.appendStyle(ind + indSplit + 1);
                    visitor.pop();
                    visitor.push("string");
                    isContinuation = PropertiesStyler.lineContinues(stripped);
                }
            }
            if (!isContinuation) {
                visitor.appendStyle(ind + line.length());
                visitor.pop();
            }
            ind += line.length() + 1;
        }
        return visitor.buildStyles();
    }

    private static int findSplitIndex(String line) {
        int indEquals = line.indexOf("=");
        int indColon = line.indexOf(":");
        if (indEquals >= 0) {
            if (indColon < 0 || indColon > indEquals) {
                return indEquals;
            }
            return indColon;
        }
        return indColon;
    }

    private static boolean lineContinues(String line) {
        return line.endsWith("\\");
    }

    private static boolean isConfigHeader(String line) {
        return line.startsWith("[") && line.endsWith("]");
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("!");
    }

    @Override
    public StyleSpans<Collection<String>> computeConsoleStyles(String text, boolean logConsole) {
        return ScriptStylerProvider.getLogStyling(text);
    }
}

