/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.SourceSpan;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Visitor;
import org.commonmark.parser.IncludeSourceSpans;
import org.commonmark.parser.Parser;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerTools;

public class MarkdownStyler
implements ScriptStyler {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownStyler.class);
    private static Parser parser = Parser.builder().includeSourceSpans(IncludeSourceSpans.BLOCKS_AND_INLINES).build();

    MarkdownStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("markdown");
    }

    @Override
    public String getBaseStyle() {
        return "-fx-font-family: sans-serif;";
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        int longLine = ScriptStylerTools.DEFAULT_LONG_LINE_LENGTH;
        if (ScriptStylerTools.containsLongLines(text, longLine)) {
            LogTools.logOnce((Logger)logger, (String)("Text contains lines longer than " + longLine + " - no styling will be applied"));
            return ScriptStylerProvider.getPlainStyling(text);
        }
        long startTime = System.currentTimeMillis();
        Node doc = parser.parse(text);
        StyleSpanVisitor visitor = new StyleSpanVisitor(text);
        doc.accept((Visitor)visitor);
        StyleSpans<Collection<String>> styles = visitor.buildStyles();
        long endTime = System.currentTimeMillis();
        logger.trace("Markdown styling time: {}", (Object)(endTime - startTime));
        return styles;
    }

    static class StyleSpanVisitor
    extends AbstractVisitor {
        private String text;
        private StyleSpansBuilder<Collection<String>> spansBuilder = new StyleSpansBuilder();
        private int[] lineSums;
        private int lastInd;
        private Deque<String> currentStyle = new ArrayDeque<String>();

        StyleSpanVisitor(String text) {
            this.text = text;
            int[] lengths = text.lines().mapToInt(l -> l.length() + 1).toArray();
            this.lineSums = new int[lengths.length + 1];
            for (int i = 0; i < lengths.length; ++i) {
                this.lineSums[i + 1] = this.lineSums[i] + lengths[i];
            }
            this.currentStyle.add("md");
        }

        public StyleSpans<Collection<String>> buildStyles() {
            this.appendStyle(this.text.length(), true);
            return this.spansBuilder.create();
        }

        private void appendStyle(int untilInd) {
            this.appendStyle(untilInd, false);
        }

        private void appendStyle(int untilInd, boolean lastStyle) {
            if (untilInd > this.lastInd || lastStyle) {
                if (this.currentStyle.isEmpty()) {
                    this.spansBuilder.add(Collections.emptyList(), untilInd - this.lastInd);
                } else if (this.currentStyle.size() == 1) {
                    this.spansBuilder.add(Collections.singletonList(this.currentStyle.peek()), untilInd - this.lastInd);
                } else {
                    this.spansBuilder.add(new ArrayList<String>(this.currentStyle), untilInd - this.lastInd);
                }
            } else {
                if (untilInd == this.lastInd) {
                    return;
                }
                throw new IllegalArgumentException("Cannot append empty style from " + this.lastInd + "-" + untilInd + " (must be ascending)");
            }
            this.lastInd = untilInd;
        }

        private void visitAny(Node node, String style) {
            List spans = node.getSourceSpans();
            SourceSpan sourceFirst = (SourceSpan)spans.get(0);
            SourceSpan sourceLast = (SourceSpan)spans.get(spans.size() - 1);
            int indStart = this.lineSums[sourceFirst.getLineIndex()] + sourceFirst.getColumnIndex();
            int indEnd = this.lineSums[sourceLast.getLineIndex()] + sourceLast.getColumnIndex() + sourceLast.getLength();
            this.appendStyle(indStart);
            this.currentStyle.push(style);
            this.visitChildren(node);
            this.appendStyle(indEnd);
            this.currentStyle.pop();
        }

        public void visit(BlockQuote blockQuote) {
            this.visitAny((Node)blockQuote, "quote");
        }

        public void visit(BulletList bulletList) {
            this.visitAny((Node)bulletList, "list");
        }

        public void visit(Code code) {
            this.visitAny((Node)code, "code");
        }

        public void visit(Emphasis emphasis) {
            this.visitAny((Node)emphasis, "emph");
        }

        public void visit(FencedCodeBlock fencedCodeBlock) {
            this.visitAny((Node)fencedCodeBlock, "code");
        }

        public void visit(Heading heading) {
            this.visitAny((Node)heading, "h" + Math.min(6, heading.getLevel()));
        }

        public void visit(HtmlInline htmlInline) {
            this.visitAny((Node)htmlInline, "raw");
        }

        public void visit(HtmlBlock htmlBlock) {
            this.visitAny((Node)htmlBlock, "raw");
        }

        public void visit(Image image) {
            this.visitAny((Node)image, "image");
        }

        public void visit(IndentedCodeBlock indentedCodeBlock) {
            this.visitAny((Node)indentedCodeBlock, "code");
        }

        public void visit(Link link) {
            this.visitAny((Node)link, "link");
        }

        public void visit(OrderedList orderedList) {
            this.visitAny((Node)orderedList, "list");
        }

        public void visit(StrongEmphasis strongEmphasis) {
            this.visitAny((Node)strongEmphasis, "strong");
        }

        public void visit(LinkReferenceDefinition linkReferenceDefinition) {
            this.visitChildren((Node)linkReferenceDefinition);
        }

        public void visit(CustomBlock customBlock) {
            this.visitChildren((Node)customBlock);
        }

        public void visit(CustomNode customNode) {
            this.visitChildren((Node)customNode);
        }
    }
}

