/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerTools;

public class JsonStyler
implements ScriptStyler {
    private static final Logger logger = LoggerFactory.getLogger(JsonStyler.class);
    static final String PAREN_PATTERN = "\\(|\\)";
    static final String BRACE_PATTERN = "\\{|\\}";
    static final String BRACKET_PATTERN = "\\[|\\]";
    static final String DOUBLE_QUOTE_PATTERN = "\"([^\"\\\\]|\\\\.)*\"";
    static final String SINGLE_QUOTE_PATTERN = "'([^'\\\\]|\\\\.)*'";
    static final String REMAINING_PATTERN = "[^,.:]";
    private static Pattern PATTERN = Pattern.compile("(?<PAREN>\\(|\\))|(?<BRACE>\\{|\\})|(?<BRACKET>\\[|\\])|(?<DOUBLEQUOTES>\"([^\"\\\\]|\\\\.)*\")|(?<SINGLEQUOTES>'([^'\\\\]|\\\\.)*')|(?<REMAINING>[^,.:])");

    JsonStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("json");
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        int longLine = ScriptStylerTools.DEFAULT_LONG_LINE_LENGTH;
        if (ScriptStylerTools.containsLongLines(text, longLine)) {
            LogTools.logOnce((Logger)logger, (String)("Text contains lines longer than " + longLine + " - no styling will be applied"));
            return ScriptStylerProvider.getPlainStyling(text);
        }
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("PAREN") != null ? "paren" : (matcher.group("BRACE") != null ? "brace" : (matcher.group("BRACKET") != null ? "bracket" : (matcher.group("DOUBLEQUOTES") != null ? "string" : (matcher.group("SINGLEQUOTES") != null ? "string" : (styleClass = matcher.group("REMAINING") != null ? "remaining" : null)))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

