/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import com.google.common.primitives.Doubles;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.richtextfx.stylers.StyleSpanVisitor;

public class JavaStyler
implements ScriptStyler {
    private static final Logger logger = LoggerFactory.getLogger(JavaStyler.class);
    public static final Set<String> JAVA_KEYWORDS = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "var");
    private Set<String> keywords;
    private String languageName;
    private boolean isGroovy;
    private static Pattern patternStringInterpolation = Pattern.compile("((?<!\\\\)\\$\\{[^}]*\\})|((?<!\\\\)\\$[\\w\\.]+)");
    private static Pattern patternUnderscore = Pattern.compile("_");
    private static Map<String, Boolean> numberTokenCache = new ConcurrentHashMap<String, Boolean>();

    public JavaStyler() {
        this("java", true, null, false);
    }

    protected JavaStyler(String languageName, boolean includeJavaKeywords, Collection<String> additionalKeywords, boolean includeGroovySyntax) {
        this.languageName = languageName;
        LinkedHashSet<String> keywords = new LinkedHashSet<String>();
        if (includeJavaKeywords) {
            keywords.addAll(JAVA_KEYWORDS);
        }
        if (additionalKeywords != null) {
            keywords.addAll(additionalKeywords);
        }
        this.keywords = Set.copyOf(keywords);
        this.isGroovy = includeGroovySyntax;
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of(this.languageName);
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        long startTime = System.currentTimeMillis();
        StyleSpanVisitor visitor = new StyleSpanVisitor(text);
        char[] chars = text.toCharArray();
        int n = chars.length;
        StringBuffer buffer = new StringBuffer();
        block12: for (int ind = 0; ind < n; ++ind) {
            char c = chars[ind];
            int lastChar = ind > 0 ? chars[ind - 1] : 10;
            switch (c) {
                case '(': 
                case ')': {
                    this.handleToken(visitor, ind, buffer);
                    JavaStyler.handleSingleCharacterStyle(visitor, ind, "paren");
                    continue block12;
                }
                case '[': 
                case ']': {
                    this.handleToken(visitor, ind, buffer);
                    JavaStyler.handleSingleCharacterStyle(visitor, ind, "bracket");
                    continue block12;
                }
                case '{': 
                case '}': {
                    this.handleToken(visitor, ind, buffer);
                    JavaStyler.handleSingleCharacterStyle(visitor, ind, "brace");
                    continue block12;
                }
                case ';': {
                    this.handleToken(visitor, ind, buffer);
                    JavaStyler.handleSingleCharacterStyle(visitor, ind, "semicolon");
                    continue block12;
                }
                case ',': {
                    this.handleToken(visitor, ind, buffer);
                    continue block12;
                }
                case '=': {
                    this.handleToken(visitor, ind, buffer);
                    continue block12;
                }
                case '*': {
                    if (lastChar == 47) {
                        this.handleToken(visitor, ind - 1, buffer);
                        visitor.appendStyle(ind - 1);
                        visitor.push("comment");
                        ++ind;
                        while (ind < n && (chars[ind] != '/' || chars[ind - 1] != '*')) {
                            ++ind;
                        }
                        visitor.appendStyle(ind);
                        visitor.pop();
                        continue block12;
                    }
                    this.handleToken(visitor, ind, buffer);
                    continue block12;
                }
                case '\'': {
                    if (this.isGroovy && ind < n - 2 && chars[ind + 1] == '\'' && chars[ind + 2] == '\'') {
                        ind = this.handleString(visitor, text, ind, "'''", "'''", buffer);
                        continue block12;
                    }
                    ind = this.handleString(visitor, text, ind, "'", "'", buffer);
                    continue block12;
                }
                case '\"': {
                    if (this.isGroovy && ind < n - 2 && chars[ind + 1] == '\"' && chars[ind + 2] == '\"') {
                        ind = this.handleString(visitor, text, ind, "\"\"\"", "\"\"\"", buffer);
                        continue block12;
                    }
                    ind = this.handleString(visitor, text, ind, "\"", "\"", buffer);
                    continue block12;
                }
                case '/': {
                    if (lastChar == 47) {
                        this.handleToken(visitor, ind - 1, buffer);
                        visitor.appendStyle(ind - 1);
                        visitor.push("comment");
                        while (ind < n && chars[ind] != '\n') {
                            ++ind;
                        }
                        visitor.appendStyle(ind);
                        visitor.pop();
                        continue block12;
                    }
                    if (this.isGroovy) {
                        if (ind > 0 && chars[ind - 1] == '$') {
                            ind = this.handleString(visitor, text, ind - 1, "/$", "/$", buffer);
                            continue block12;
                        }
                        if (ind >= n - 1 || chars[ind + 1] == '*') continue block12;
                        this.handleToken(visitor, ind, buffer);
                        continue block12;
                    }
                    this.handleToken(visitor, ind, buffer);
                    continue block12;
                }
                default: {
                    boolean isBreakingCharacter;
                    boolean isLastCharacter = ind == n - 1;
                    boolean bl = isBreakingCharacter = !Character.isLetterOrDigit(c) && c != '.' && c != '_' && c != '-';
                    if (!isBreakingCharacter) {
                        buffer.append(c);
                    }
                    if (isBreakingCharacter) {
                        this.handleToken(visitor, ind, buffer);
                        continue block12;
                    }
                    if (!isLastCharacter) continue block12;
                    this.handleToken(visitor, n, buffer);
                }
            }
        }
        StyleSpans<Collection<String>> styles = visitor.buildStyles();
        long endTime = System.currentTimeMillis();
        logger.trace("Style time: {} (length={})", (Object)(endTime - startTime), (Object)n);
        return styles;
    }

    private int handleString(StyleSpanVisitor visitor, String text, int startInd, String startSequence, String endSequence, StringBuffer buffer) {
        String substring;
        boolean canInterpolate;
        JavaStyler.resetToken(buffer);
        boolean isMultiline = startSequence.length() > 1 || startSequence.equals("'") || startSequence.equals("\"");
        char escapeChar = startSequence.equals("$/") ? (char)'$' : '\\';
        int endInd = JavaStyler.findNextEnd(text, startInd + startSequence.length(), endSequence, escapeChar);
        if (!isMultiline) {
            int newlineInd = JavaStyler.findNextEnd(text, startInd + startSequence.length(), "\n", escapeChar);
            if (endInd < 0 || newlineInd < endInd) {
                endInd = newlineInd;
            }
        }
        if (endInd < 0) {
            endInd = text.length();
        }
        visitor.appendStyle(startInd);
        visitor.push("string");
        boolean bl = canInterpolate = this.isGroovy && !startSequence.equals("'") && !startSequence.equals("'''") && !startSequence.equals("/$");
        if (canInterpolate && (substring = text.substring(startInd, endInd)).indexOf("$") >= 0) {
            Matcher matcher = patternStringInterpolation.matcher(substring);
            while (matcher.find()) {
                visitor.appendStyle(startInd + matcher.start());
                visitor.pop();
                visitor.appendStyle(startInd + matcher.end());
                visitor.push("string");
            }
        }
        visitor.appendStyle(endInd);
        visitor.pop();
        return endInd - 1;
    }

    private static int findNextEnd(String text, int startInd, String endSequence, char escapeChar) {
        int ind = text.indexOf(endSequence, startInd);
        if (ind < 0) {
            return ind;
        }
        int nEscapes = 0;
        for (int indEscape = ind - 1; indEscape >= startInd && text.charAt(indEscape) == escapeChar; --indEscape) {
            ++nEscapes;
        }
        if (nEscapes % 2 != 0) {
            return JavaStyler.findNextEnd(text, ind + 1, endSequence, escapeChar);
        }
        return ind + endSequence.length();
    }

    private static void resetToken(StringBuffer buffer) {
        buffer.setLength(0);
    }

    private void handleToken(StyleSpanVisitor visitor, int ind, StringBuffer buffer) {
        if (!buffer.isEmpty()) {
            String s = buffer.toString();
            int startInd = ind - s.length();
            if (this.keywords.contains(s)) {
                if (startInd > 0) {
                    visitor.appendStyle(startInd);
                }
                visitor.push("keyword");
                visitor.appendStyle(ind);
                visitor.pop();
            }
            if (JavaStyler.isNumeric(s)) {
                if (startInd > 0) {
                    visitor.appendStyle(startInd);
                }
                visitor.push("number");
                visitor.appendStyle(ind);
                visitor.pop();
            }
        }
        buffer.setLength(0);
    }

    private static boolean isNumeric(String s) {
        if (s.length() == 1) {
            return Character.isDigit(s.charAt(0));
        }
        Boolean isNumeric = numberTokenCache.getOrDefault(s, null);
        if (isNumeric == null) {
            if (s.indexOf(95) > 0) {
                String s2 = patternUnderscore.matcher(s).replaceAll("");
                isNumeric = s2.length() > 0 && Doubles.tryParse((String)s2) != null;
                numberTokenCache.put(s, isNumeric);
                return isNumeric;
            }
            return Doubles.tryParse((String)s) != null;
        }
        return isNumeric;
    }

    private static void handleSingleCharacterStyle(StyleSpanVisitor visitor, int ind, String style) {
        if (ind > 0) {
            visitor.appendStyle(ind);
        }
        visitor.push(style);
        visitor.appendStyle(ind + 1);
        visitor.pop();
    }

    @Override
    public StyleSpans<Collection<String>> computeConsoleStyles(String text, boolean logConsole) {
        return ScriptStylerProvider.getLogStyling(text);
    }
}

