/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx;

import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.scripting.richtextfx.CodeAreaControl;
import qupath.lib.gui.scripting.richtextfx.RichScriptEditor;

public class RichScriptEditorExtension
implements QuPathExtension {
    private static final Logger logger = LoggerFactory.getLogger(RichScriptEditorExtension.class);

    public void installExtension(QuPathGUI qupath) {
        qupath.setScriptEditor((ScriptEditor)new RichScriptEditor(qupath));
        try {
            CodeAreaControl console = RichScriptEditor.createLogConsole();
            CodeArea codeArea = (CodeArea)console.getRegion().getContent();
            codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)codeArea, digits -> "%1$" + digits + "s", null, null));
            codeArea.getStyleClass().add((Object)"qupath-log");
            codeArea.setStyle("-fx-font-family: sans-serif; " + codeArea.getStyle());
        }
        catch (Exception e) {
            logger.warn("Unable to set rich text log viewer: " + e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getName() {
        return "Rich script editor extension";
    }

    public String getDescription() {
        return "Adds a more attractive script editor with syntax highlighting, making use of RichTextFX - https://github.com/TomasMikula/RichTextFX";
    }

    public Version getQuPathVersion() {
        return this.getVersion();
    }
}

