/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx;

import java.util.List;
import javafx.scene.control.ContextMenu;
import javafx.scene.layout.Region;
import org.fxmisc.richtext.CodeArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.scripting.DefaultScriptEditor;
import qupath.lib.gui.scripting.ScriptEditorControl;
import qupath.lib.gui.scripting.richtextfx.CodeAreaControl;
import qupath.lib.gui.tools.MenuTools;

public class RichScriptEditor
extends DefaultScriptEditor {
    private static final Logger logger = LoggerFactory.getLogger(RichScriptEditor.class);
    private ContextMenu menu = new ContextMenu();

    public RichScriptEditor(QuPathGUI qupath) {
        super(qupath);
        this.smartEditing.addListener((v, o, n) -> this.updateSmartEditing());
        this.selectedScriptProperty().addListener((v, o, n) -> this.updateSmartEditing());
        MenuTools.addMenuItems((List)this.menu.getItems(), (Object[])new Object[]{MenuTools.createMenu((String)"Run...", (Object[])new Object[]{this.runScriptAction, this.runSelectedAction, this.runProjectScriptAction, this.runProjectScriptNoSaveAction}), MenuTools.createMenu((String)"Undo/Redo...", (Object[])new Object[]{this.undoAction, this.redoAction}), null, this.copyAction, this.pasteAction, this.pasteAndEscapeAction});
    }

    protected ScriptEditorControl<? extends Region> getNewEditor() {
        try {
            CodeAreaControl editor = CodeAreaControl.createCodeEditor();
            editor.setSmartEditing(this.smartEditing.get());
            editor.setLanguage(this.getCurrentLanguage());
            CodeArea codeArea = (CodeArea)editor.getRegion().getContent();
            codeArea.setOnContextMenuRequested(e -> this.menu.show(codeArea.getScene().getWindow(), e.getScreenX(), e.getScreenY()));
            return editor;
        }
        catch (Exception e2) {
            logger.error("Unable to create code area", (Throwable)e2);
            return super.getNewEditor();
        }
    }

    private void updateSmartEditing() {
        ScriptEditorControl scriptEditorControl = this.getCurrentEditorControl();
        if (scriptEditorControl instanceof CodeAreaControl) {
            CodeAreaControl control = (CodeAreaControl)scriptEditorControl;
            control.setSmartEditing(this.smartEditing.get());
        }
    }

    static CodeAreaControl createLogConsole() {
        return CodeAreaControl.createLog();
    }

    protected ScriptEditorControl<? extends Region> getNewConsole() {
        try {
            return RichScriptEditor.createLogConsole();
        }
        catch (Exception e) {
            logger.error("Unable to create console area", (Throwable)e);
            return super.getNewEditor();
        }
    }
}

