/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx;

import java.net.URL;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.stage.Popup;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.scripting.EditableText;
import qupath.lib.gui.scripting.ScriptEditorControl;
import qupath.lib.gui.scripting.richtextfx.CustomCodeArea;
import qupath.lib.gui.scripting.richtextfx.RichScriptEditor;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStylerProvider;
import qupath.lib.gui.scripting.syntax.ScriptSyntax;
import qupath.lib.gui.scripting.syntax.ScriptSyntaxProvider;
import qupath.lib.scripting.languages.AutoCompletions;
import qupath.lib.scripting.languages.ScriptAutoCompletor;
import qupath.lib.scripting.languages.ScriptLanguage;

public class CodeAreaControl
implements ScriptEditorControl<VirtualizedScrollPane<CodeArea>> {
    private static final Logger logger = LoggerFactory.getLogger(CodeAreaControl.class);
    private static final KeyCodeCombination completionCodeCombination = new KeyCodeCombination(KeyCode.SPACE, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
    private static ExecutorService executor = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"rich-text-styling", (boolean)true));
    private static int delayMillis = 20;
    private VirtualizedScrollPane<CodeArea> scrollpane;
    private CodeArea codeArea;
    private StringProperty textProperty = new SimpleStringProperty();
    private ContextMenu contextMenu;
    private boolean smartEditing = true;
    private ScriptSyntax syntax;
    private ScriptLanguage language;
    private ScriptStyler styler = ScriptStylerProvider.PLAIN;
    private Popup popup;
    private ListView<AutoCompletions.Completion> listCompletions;
    private ReadOnlyIntegerProperty caretReadOnly;

    private CodeAreaControl(boolean isEditable) {
        this.codeArea = CodeAreaControl.createCodeArea();
        this.codeArea.setEditable(isEditable);
        this.codeArea.textProperty().addListener((o, v, n) -> this.textProperty.set(n));
        this.textProperty.addListener((o, v, n) -> {
            if (n.equals(this.codeArea.getText())) {
                return;
            }
            this.codeArea.clear();
            this.codeArea.insertText(0, n);
        });
        this.scrollpane = new VirtualizedScrollPane((Region)this.codeArea);
        if (isEditable) {
            this.initializeEditable();
        } else {
            this.initializeLog();
        }
    }

    private static CodeArea createCodeArea() {
        CustomCodeArea codeArea = new CustomCodeArea();
        codeArea.setUseInitialStyleForInsertion(false);
        URL url = RichScriptEditor.class.getClassLoader().getResource("scripting_styles.css");
        if (url != null) {
            codeArea.getStylesheets().add((Object)url.toExternalForm());
        }
        return codeArea;
    }

    public static CodeAreaControl createCodeEditor() {
        return new CodeAreaControl(true);
    }

    public static CodeAreaControl createLog() {
        return new CodeAreaControl(false);
    }

    private void initializeEditable() {
        this.initializeCompletions();
        this.initEditableStyle();
        this.initEditableCleanup();
        this.codeArea.addEventFilter(KeyEvent.KEY_TYPED, this::handleKeyTyped);
        this.codeArea.addEventFilter(KeyEvent.KEY_PRESSED, this::handleKeyPressed);
    }

    private void initializeLog() {
        this.codeArea.plainTextChanges().subscribe(c -> {
            int start = Integer.MAX_VALUE;
            start = !((String)c.getRemoved()).isEmpty() ? 0 : Math.min(start, c.getPosition());
            if (start < Integer.MAX_VALUE) {
                ScriptStyler styler;
                String text = this.codeArea.getText();
                while (start > 0 && text.charAt(start) != '\n') {
                    --start;
                }
                if (start > 0) {
                    text = text.substring(start);
                }
                if ((styler = this.styler) == null) {
                    styler = ScriptStylerProvider.PLAIN;
                }
                this.codeArea.setStyleSpans(start, styler.computeConsoleStyles(text, true));
            }
        });
        this.codeArea.setEditable(false);
    }

    public StringProperty textProperty() {
        return this.textProperty;
    }

    public void setText(String text) {
        this.codeArea.replaceText(text);
        this.requestFollowCaret();
    }

    public String getText() {
        return this.codeArea.getText();
    }

    public ObservableValue<String> selectedTextProperty() {
        return this.codeArea.selectedTextProperty();
    }

    public String getSelectedText() {
        return this.codeArea.getSelectedText();
    }

    public VirtualizedScrollPane<CodeArea> getRegion() {
        return this.scrollpane;
    }

    public boolean isUndoable() {
        return this.codeArea.isUndoAvailable();
    }

    public boolean isRedoable() {
        return this.codeArea.isRedoAvailable();
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }

    public void copy() {
        this.codeArea.copy();
    }

    public void cut() {
        this.codeArea.cut();
    }

    public void paste() {
        this.codeArea.paste();
    }

    public void appendText(String text) {
        this.codeArea.appendText(text);
        this.requestFollowCaret();
    }

    public void clear() {
        this.codeArea.clear();
    }

    public int getCaretPosition() {
        return this.codeArea.getCaretPosition();
    }

    public void insertText(int pos, String text) {
        this.codeArea.insertText(pos, text);
        this.requestFollowCaret();
    }

    public void deleteText(int startIdx, int endIdx) {
        this.codeArea.deleteText(startIdx, endIdx);
        this.requestFollowCaret();
    }

    public void deselect() {
        this.codeArea.deselect();
    }

    public IndexRange getSelection() {
        return this.codeArea.getSelection();
    }

    public void selectRange(int startIdx, int endIdx) {
        this.codeArea.selectRange(startIdx, endIdx);
    }

    public BooleanProperty wrapTextProperty() {
        return this.codeArea.wrapTextProperty();
    }

    public void positionCaret(int index) {
        this.codeArea.moveTo(index);
    }

    public void requestFollowCaret() {
        this.codeArea.requestFollowCaret();
    }

    public void replaceSelection(String text) {
        this.codeArea.replaceSelection(text);
        this.requestFollowCaret();
    }

    public void setContextMenu(ContextMenu menu) {
        this.contextMenu = menu;
        this.codeArea.setContextMenu(null);
        this.codeArea.setOnContextMenuRequested(e -> {
            ContextMenu popup;
            ContextMenu contextMenu = popup = this.codeArea.getContextMenu() == null ? this.contextMenu : this.codeArea.getContextMenu();
            if (popup != null) {
                popup.show(this.codeArea.getScene().getWindow(), e.getScreenX(), e.getScreenY());
            }
        });
    }

    public ContextMenu getContextMenu() {
        ContextMenu popup = this.codeArea.getContextMenu();
        if (popup != null) {
            return popup;
        }
        return this.contextMenu;
    }

    public void requestFocus() {
        this.codeArea.requestFocus();
    }

    public ReadOnlyIntegerProperty caretPositionProperty() {
        if (this.caretReadOnly == null) {
            SimpleIntegerProperty caret = new SimpleIntegerProperty();
            caret.bind(this.codeArea.caretPositionProperty());
            this.caretReadOnly = IntegerProperty.readOnlyIntegerProperty((ReadOnlyProperty)caret);
        }
        return this.caretReadOnly;
    }

    public void setLanguage(ScriptLanguage language) {
        if (Objects.equals(this.language, language)) {
            return;
        }
        this.language = language;
        this.updateSyntax();
        this.updateStyler();
    }

    public ScriptLanguage getLanguage() {
        return this.language;
    }

    public void setSmartEditing(boolean smartEditing) {
        this.smartEditing = smartEditing;
    }

    public boolean getSmartEditing() {
        return this.smartEditing;
    }

    private void updateSyntax() {
        String name = this.language == null ? null : this.language.getName();
        this.syntax = name == null ? ScriptSyntaxProvider.PLAIN : ScriptSyntaxProvider.getSyntaxFromName((String)name);
    }

    private void updateStyler() {
        this.styler = this.language == null ? ScriptStylerProvider.PLAIN : ScriptStylerProvider.getStylerFromLanguage(this.language);
        String baseStyle = this.styler.getBaseStyle();
        if (baseStyle != null && !baseStyle.isBlank()) {
            this.codeArea.setStyle(baseStyle);
        } else {
            this.codeArea.setStyle(null);
        }
        StyleSpans<Collection<String>> changes = this.styler.computeEditorStyles(this.codeArea.getText());
        this.codeArea.setStyleSpans(0, changes);
        this.codeArea.requestFocus();
    }

    private void initEditableStyle() {
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get((GenericStyledArea)this.codeArea, digits -> "%1$" + digits + "s", null, null));
        this.codeArea.setStyle("-fx-background-color: -fx-control-inner-background;");
        this.codeArea.getStylesheets().add((Object)RichScriptEditor.class.getClassLoader().getResource("scripting_styles.css").toExternalForm());
    }

    private void initializeCompletions() {
        this.popup = new Popup();
        this.listCompletions = new ListView();
        this.listCompletions.setCellFactory(c -> FXUtils.createCustomListCell(AutoCompletions.Completion::getDisplayText));
        this.listCompletions.setPrefSize(350.0, 400.0);
        this.popup.getContent().add(this.listCompletions);
        this.listCompletions.setStyle("-fx-font-size: smaller; -fx-font-family: Courier;");
        Runnable completionFun = () -> {
            AutoCompletions.Completion selected = (AutoCompletions.Completion)this.listCompletions.getSelectionModel().getSelectedItem();
            if (selected == null) {
                selected = (AutoCompletions.Completion)this.listCompletions.getFocusModel().getFocusedItem();
            }
            if (selected != null) {
                CodeAreaControl.applyCompletion((EditableText)this, selected);
            }
            this.popup.hide();
        };
        this.listCompletions.setOnKeyReleased(e -> {
            if (e.getCode() == KeyCode.TAB) {
                completionFun.run();
            }
            if (e.getCode() == KeyCode.ENTER || e.getCode() == KeyCode.TAB) {
                completionFun.run();
                e.consume();
            } else if (e.getCode() == KeyCode.ESCAPE) {
                this.popup.hide();
                this.listCompletions.getItems().clear();
            }
        });
        this.listCompletions.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                completionFun.run();
                e.consume();
            }
        });
        this.listCompletions.setMaxHeight(200.0);
        this.popup.focusedProperty().addListener((v, o, n) -> {
            if (!n.booleanValue()) {
                this.popup.hide();
            }
        });
    }

    private void initEditableCleanup() {
        this.codeArea.multiPlainChanges().successionEnds(Duration.ofMillis(delayMillis)).retainLatestUntilLater((Executor)executor).supplyTask(() -> {
            Task<StyleSpans<Collection<String>>> task = new Task<StyleSpans<Collection<String>>>(){

                protected StyleSpans<Collection<String>> call() {
                    return CodeAreaControl.this.styler.computeEditorStyles(CodeAreaControl.this.codeArea.getText());
                }
            };
            executor.execute((Runnable)task);
            return task;
        }).awaitLatest(this.codeArea.multiPlainChanges()).filterMap(t -> {
            if (t.isSuccess()) {
                return Optional.of((StyleSpans)t.get());
            }
            Throwable exception = t.getFailure();
            String message = exception.getLocalizedMessage() == null ? exception.getClass().getSimpleName() : exception.getLocalizedMessage();
            logger.error("Error applying syntax highlighting: {}", (Object)message);
            logger.debug("", exception);
            return Optional.empty();
        }).subscribe(styles -> this.codeArea.setStyleSpans(0, styles));
    }

    private void handleKeyTyped(KeyEvent e) {
        if (e.isConsumed() || this.syntax == null) {
            return;
        }
        if ("(".equals(e.getCharacter())) {
            this.syntax.handleLeftParenthesis((EditableText)this, this.smartEditing);
            e.consume();
        } else if (")".equals(e.getCharacter())) {
            this.syntax.handleRightParenthesis((EditableText)this, this.smartEditing);
            e.consume();
        } else if ("\"".equals(e.getCharacter())) {
            this.syntax.handleQuotes((EditableText)this, true, this.smartEditing);
            e.consume();
        } else if ("'".equals(e.getCharacter())) {
            this.syntax.handleQuotes((EditableText)this, false, this.smartEditing);
            e.consume();
        }
    }

    private void handleKeyPressed(KeyEvent e) {
        ScriptAutoCompletor scriptAutoCompletor;
        if (e.isConsumed()) {
            return;
        }
        ScriptSyntax scriptSyntax = this.syntax;
        if (scriptSyntax != null) {
            if (e.getCode() == KeyCode.TAB) {
                scriptSyntax.handleTabPress((EditableText)this, e.isShiftDown());
                e.consume();
            } else if (e.isShortcutDown() && e.getCode() == KeyCode.SLASH) {
                scriptSyntax.handleLineComment((EditableText)this);
                e.consume();
            } else if (e.getCode() == KeyCode.ENTER && this.codeArea.getSelectedText().isEmpty()) {
                scriptSyntax.handleNewLine((EditableText)this, this.smartEditing);
                e.consume();
            } else if (e.getCode() == KeyCode.BACK_SPACE && scriptSyntax.handleBackspace((EditableText)this, this.smartEditing) && !e.isShortcutDown() && !e.isShiftDown()) {
                e.consume();
            }
        }
        ScriptAutoCompletor scriptAutoCompletor2 = scriptAutoCompletor = this.language == null ? null : this.language.getAutoCompletor();
        if (scriptAutoCompletor != null) {
            if (completionCodeCombination.match(e)) {
                Bounds bounds;
                List<AutoCompletions.Completion> completions = this.getCurrentAutoCompletions(this);
                if (!completions.isEmpty() && (bounds = (Bounds)this.codeArea.getCaretBounds().orElse(null)) != null) {
                    this.listCompletions.getItems().setAll(completions);
                    this.popup.show((Node)this.codeArea, bounds.getMaxX(), bounds.getMaxY());
                    e.consume();
                }
                if (!e.isConsumed() && this.popup.isShowing()) {
                    this.popup.hide();
                    e.consume();
                }
            } else if (this.popup.isShowing()) {
                Platform.runLater(() -> {
                    if (!this.popup.isShowing()) {
                        return;
                    }
                    List<AutoCompletions.Completion> completions = this.getCurrentAutoCompletions(this);
                    this.listCompletions.getItems().setAll(completions);
                    if (completions.isEmpty()) {
                        this.popup.hide();
                    }
                });
            }
        }
    }

    private List<AutoCompletions.Completion> getCurrentAutoCompletions(ScriptEditorControl<?> control) {
        ScriptAutoCompletor completor;
        ScriptAutoCompletor scriptAutoCompletor = completor = this.language == null ? null : this.language.getAutoCompletor();
        if (completor == null) {
            return Collections.emptyList();
        }
        List completions = completor.getCompletions(control.getText(), control.getCaretPosition());
        if (completions.isEmpty() || completions.size() == 1) {
            return completions;
        }
        return completions.stream().sorted(AutoCompletions.getComparator()).distinct().toList();
    }

    private static void applyCompletion(EditableText control, AutoCompletions.Completion completion) {
        int pos;
        String text = control.getText();
        String insertion = completion.getInsertion(text, pos = control.getCaretPosition(), null);
        if (insertion == null || insertion.isEmpty() || insertion.startsWith("(")) {
            return;
        }
        control.insertText(pos, insertion);
        if (insertion.endsWith("()") && control.getCaretPosition() > 0 && !completion.getDisplayText().endsWith("()")) {
            control.positionCaret(control.getCaretPosition() - 1);
        }
    }
}

