/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main.cellfactories;

import java.util.function.Function;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.shape.Circle;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.ui.main.cellfactories.GenericTableCell;

public class LogLevelTableCell
extends GenericTableCell {
    private final Circle icon = new Circle(5.0);

    public LogLevelTableCell(Function<LogMessage, String> logMessageToString) {
        super(logMessageToString);
        this.contentDisplayProperty().bind((ObservableValue)new SimpleObjectProperty((Object)ContentDisplay.GRAPHIC_ONLY));
        this.setAlignment(Pos.CENTER);
    }

    @Override
    protected void updateItem(LogMessage item, boolean empty) {
        super.updateItem(item, empty);
        if (empty || item == null) {
            this.setGraphic(null);
        } else {
            this.tooltip.setText(item.level().toString());
            this.setTooltip(this.tooltip);
            this.setGraphic((Node)this.icon);
            this.icon.getStyleClass().setAll((Object[])new String[]{"log-level", item.level().toString().toLowerCase()});
        }
    }
}

