/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main.cellfactories;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.scene.control.TableCell;
import javafx.scene.control.Tooltip;
import org.slf4j.event.Level;
import qupath.ui.logviewer.api.LogMessage;

public class GenericTableCell
extends TableCell<LogMessage, LogMessage> {
    protected final Function<LogMessage, String> logMessageToString;
    protected final Tooltip tooltip = new Tooltip();
    private static final Map<Level, String> LEVEL_TO_NAME = Arrays.stream(Level.values()).collect(Collectors.toMap(l -> l, l -> l.name().toLowerCase()));
    private static final Set<String> LEVEL_NAMES = new HashSet<String>(LEVEL_TO_NAME.values());

    public GenericTableCell(Function<LogMessage, String> logMessageToString) {
        this.logMessageToString = logMessageToString;
    }

    protected void updateItem(LogMessage item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText("");
            this.setTooltip(null);
        } else {
            this.setText(this.logMessageToString.apply(item));
            this.tooltip.setText(this.logMessageToString.apply(item));
            this.setTooltip(this.tooltip);
            this.getStyleClass().removeAll(LEVEL_NAMES);
            String name = LEVEL_TO_NAME.getOrDefault(item.level(), null);
            if (name != null) {
                this.getStyleClass().add((Object)name);
            }
        }
    }
}

