/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main.cellfactories;

import java.util.function.Function;
import java.util.regex.Pattern;
import javafx.scene.control.OverrunStyle;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.ui.main.cellfactories.GenericTableCell;

public class CompactTableCell
extends GenericTableCell {
    private final String delimiter;

    public CompactTableCell(Function<LogMessage, String> logMessageToString, String delimiter) {
        super(logMessageToString);
        this.delimiter = delimiter;
        this.setTextOverrun(OverrunStyle.LEADING_WORD_ELLIPSIS);
    }

    @Override
    protected void updateItem(LogMessage item, boolean empty) {
        super.updateItem(item, empty);
        if (!empty && item != null) {
            String[] messageSplit = ((String)this.logMessageToString.apply(item)).split(Pattern.quote(this.delimiter));
            this.setText(messageSplit[messageSplit.length - 1]);
        }
    }
}

