/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.collections.transformation.FilteredList;
import org.slf4j.event.Level;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.api.listener.LoggerListener;
import qupath.ui.logviewer.api.manager.LoggerManager;
import qupath.ui.logviewer.ui.main.LogMessageCounts;
import qupath.ui.logviewer.ui.main.LogMessagePredicates;

class LogViewerModel
implements LoggerListener {
    private final BooleanProperty loggingFrameworkFoundProperty = new SimpleBooleanProperty(false);
    private final ObservableList<LogMessage> allLogs = FXCollections.observableArrayList();
    private final FilteredList<LogMessage> filteredLogs = new FilteredList(this.allLogs);
    private final LogMessageCounts allLogsMessageCounts = new LogMessageCounts(this.allLogs);
    private final LogMessageCounts filteredLogsMessageCounts = new LogMessageCounts((ObservableList<LogMessage>)this.filteredLogs);
    private final BooleanProperty filterByRegexProperty = new SimpleBooleanProperty(false);
    private final StringProperty filterProperty = new SimpleStringProperty("");
    private final ObservableSet<String> allThreads = FXCollections.observableSet((Object[])new String[0]);
    private final ObservableSet<String> displayedThreads = FXCollections.observableSet((Object[])new String[0]);
    private final BooleanProperty displayAllThreadsProperty = new SimpleBooleanProperty(true);
    private final ObservableSet<Level> displayedLogLevels = FXCollections.observableSet((Object[])Level.values());
    private final LoggerManager loggerManager;

    public LogViewerModel() {
        this(null);
    }

    public LogViewerModel(LoggerManager loggerManager) {
        this.loggerManager = loggerManager == null ? (LoggerManager)LoggerManager.getCurrentLoggerManager().orElse(null) : loggerManager;
        this.loggingFrameworkFoundProperty.set(this.loggerManager != null);
        this.setUpListeners();
        this.updateLogMessageFilter();
    }

    public void addLogMessage(LogMessage logMessage) {
        if (Platform.isFxApplicationThread()) {
            this.allLogs.add((Object)logMessage);
        } else {
            Platform.runLater(() -> this.addLogMessage(logMessage));
        }
    }

    public void startLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.addListener((LoggerListener)this);
    }

    public void stopLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.removeListener((LoggerListener)this);
    }

    public Optional<LoggerManager> getLoggerManager() {
        return Optional.ofNullable(this.loggerManager);
    }

    public Level getRootLevel() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        return this.loggerManager.getRootLogLevel();
    }

    public void setRootLevel(Level level) {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.setRootLogLevel(level);
    }

    public ReadOnlyBooleanProperty getLoggingFrameworkFoundProperty() {
        return this.loggingFrameworkFoundProperty;
    }

    public FilteredList<LogMessage> getFilteredLogs() {
        return this.filteredLogs;
    }

    public void displayOneThread(String threadName) {
        if (!this.displayAllThreadsProperty.get()) {
            this.displayedThreads.clear();
            this.displayedThreads.add((Object)threadName);
            this.allThreads.add((Object)threadName);
        }
    }

    public BooleanProperty getDisplayAllThreadsProperty() {
        return this.displayAllThreadsProperty;
    }

    public void displayLogLevel(String level) {
        this.displayedLogLevels.add((Object)Level.valueOf((String)level));
    }

    public void hideLogLevel(String level) {
        this.displayedLogLevels.remove((Object)Level.valueOf((String)level));
    }

    public BooleanProperty getFilterByRegexProperty() {
        return this.filterByRegexProperty;
    }

    public StringProperty getFilterProperty() {
        return this.filterProperty;
    }

    public LogMessageCounts getAllLogsMessageCounts() {
        return this.allLogsMessageCounts;
    }

    public LogMessageCounts getFilteredLogsMessageCounts() {
        return this.filteredLogsMessageCounts;
    }

    public ObservableSet<String> getAllThreads() {
        return this.allThreads;
    }

    public void clearAllLogs() {
        this.allLogs.clear();
    }

    public void saveDisplayedLogsToFile(File file) throws FileNotFoundException {
        try (PrintWriter writer = new PrintWriter(file);){
            for (LogMessage logMessage : this.filteredLogs) {
                writer.println(logMessage.toReadableString());
            }
        }
    }

    private void setUpListeners() {
        this.filterByRegexProperty.addListener((l, o, n) -> this.updateLogMessageFilter());
        this.filterProperty.addListener((l, o, n) -> this.updateLogMessageFilter());
        this.displayedLogLevels.addListener(change -> this.updateLogMessageFilter());
        this.displayedThreads.addListener(change -> this.updateLogMessageFilter());
        this.allLogs.addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                for (LogMessage item : change.getAddedSubList()) {
                    this.allThreads.add((Object)item.threadName());
                }
            }
        });
        this.allThreads.addListener(change -> {
            if (change.wasAdded() && this.displayAllThreadsProperty.get()) {
                this.displayedThreads.add((Object)((String)change.getElementAdded()));
            }
            this.updateLogMessageFilter();
        });
        this.displayAllThreadsProperty.addListener(change -> {
            if (this.displayAllThreadsProperty.get()) {
                this.displayedThreads.addAll(this.allThreads);
            }
        });
    }

    private void updateLogMessageFilter() {
        Predicate<LogMessage> filterPredicate = this.filterByRegexProperty.get() ? LogMessagePredicates.createPredicateFromRegex((String)this.filterProperty.get()) : LogMessagePredicates.createPredicateContainsIgnoreCase((String)this.filterProperty.get());
        this.filteredLogs.setPredicate(filterPredicate.and(logMessage -> this.displayedLogLevels.contains((Object)logMessage.level()) && this.displayedThreads.contains((Object)logMessage.threadName())));
    }
}

