/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javafx.animation.FadeTransition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Skin;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.control.skin.TableViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.BorderPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javafx.util.Duration;
import org.slf4j.event.Level;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.api.manager.LoggerManager;
import qupath.ui.logviewer.ui.main.LogMessageCounts;
import qupath.ui.logviewer.ui.main.LogViewerModel;
import qupath.ui.logviewer.ui.main.cellfactories.CompactTableCell;
import qupath.ui.logviewer.ui.main.cellfactories.GenericTableCell;
import qupath.ui.logviewer.ui.main.cellfactories.LogLevelTableCell;
import qupath.ui.logviewer.ui.main.cellfactories.TableRowTableCell;

public class LogViewer
extends BorderPane {
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat(System.getProperty("timestamp.format", "HH:mm:ss"));
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ui.logviewer.ui.main.strings");
    @FXML
    private MenuBar menubar;
    @FXML
    private Menu threadFilterMenu;
    @FXML
    private ToggleGroup threadFilterGroup;
    @FXML
    private RadioMenuItem allThreadsItem;
    @FXML
    private ToggleButton regexButton;
    @FXML
    private Tooltip regexTooltip;
    @FXML
    private TextField messageFilter;
    @FXML
    private ToggleButton displayErrorButton;
    @FXML
    private Tooltip displayErrorTooltip;
    @FXML
    private ToggleButton displayWarnButton;
    @FXML
    private Tooltip displayWarnTooltip;
    @FXML
    private ToggleButton displayInfoButton;
    @FXML
    private Tooltip displayInfoTooltip;
    @FXML
    private ToggleButton displayDebugButton;
    @FXML
    private Tooltip displayDebugTooltip;
    @FXML
    private ToggleButton displayTraceButton;
    @FXML
    private Tooltip displayTraceTooltip;
    @FXML
    private ComboBox<Level> minimumLevel;
    @FXML
    private TableView<LogMessage> tableViewLog;
    @FXML
    private TableColumn<LogMessage, LogMessage> colRow;
    @FXML
    private TableColumn<LogMessage, LogMessage> colLogger;
    @FXML
    private TableColumn<LogMessage, LogMessage> colTimestamp;
    @FXML
    private TableColumn<LogMessage, LogMessage> colThread;
    @FXML
    private TableColumn<LogMessage, LogMessage> colLevel;
    @FXML
    private TableColumn<LogMessage, LogMessage> colMessage;
    @FXML
    private TextArea textAreaLog;
    @FXML
    private Label warningsCount;
    @FXML
    private Label errorsCount;
    @FXML
    private Label shownCount;
    @FXML
    private Label status;
    @FXML
    private Button clearLogsButton;
    @FXML
    private Button copyButton;
    private final Collection<String> allLogLevelNamesToLowerCase = Arrays.stream(Level.values()).map(LogViewer::toStyleClass).toList();
    private final LogViewerModel logViewerModel;
    private final Map<Skin<?>, VirtualFlow<?>> virtualFlows = new WeakHashMap();
    private int previousLastVisibleIndex = -1;
    private boolean scrollToBottom = true;

    public LogViewer() throws IOException {
        this(null);
    }

    public LogViewer(LoggerManager loggerManager) throws IOException {
        this.logViewerModel = new LogViewerModel(loggerManager);
        URL url = LogViewer.class.getResource("log-viewer.fxml");
        FXMLLoader loader = new FXMLLoader(url, resources);
        loader.setRoot((Object)this);
        loader.setController((Object)this);
        loader.load();
        this.startLogging();
    }

    public void startLogging() {
        if (this.logViewerModel.getLoggingFrameworkFoundProperty().get()) {
            this.logViewerModel.startLogging();
        }
    }

    public void stopLogging() {
        if (this.logViewerModel.getLoggingFrameworkFoundProperty().get()) {
            this.logViewerModel.stopLogging();
        }
    }

    public Optional<LoggerManager> getLoggerManager() {
        return this.logViewerModel.getLoggerManager();
    }

    public MenuBar getMenubar() {
        return this.menubar;
    }

    public TableView<LogMessage> getTable() {
        return this.tableViewLog;
    }

    public LogMessageCounts getAllLogsMessageCounts() {
        return this.logViewerModel.getAllLogsMessageCounts();
    }

    public LogMessageCounts getFilteredLogsMessageCounts() {
        return this.logViewerModel.getFilteredLogsMessageCounts();
    }

    @FXML
    private void initialize() {
        this.setUpDisplayedLogLevels();
        this.setUpMessageFilter();
        this.setUpTable();
        this.setUpFooter();
        this.setUpThreadFilter();
    }

    @FXML
    public void onMouseEnteredOnWindow() {
        if (this.logViewerModel.getLoggingFrameworkFoundProperty().get()) {
            this.minimumLevel.getSelectionModel().select((Object)this.logViewerModel.getRootLevel());
        }
    }

    @FXML
    private void save() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("Log files (*.log)", new String[]{"*.log", "*.LOG"});
        fileChooser.getExtensionFilters().add((Object)extFilter);
        File file = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (file != null) {
            if (!file.getName().endsWith(".log") && !file.getName().endsWith(".LOG")) {
                file = new File(file.getAbsolutePath() + ".log");
            }
            try {
                this.logViewerModel.saveDisplayedLogsToFile(file);
                this.setStatus(MessageFormat.format(resources.getString("LogCount.fileSaved"), file.getAbsolutePath()));
            }
            catch (FileNotFoundException e) {
                new Alert(Alert.AlertType.ERROR, e.getLocalizedMessage(), new ButtonType[0]).show();
            }
        }
    }

    @FXML
    private void close() {
        this.getScene().getWindow().hide();
    }

    @FXML
    private void copySelectedLines() {
        if (!this.tableViewLog.getSelectionModel().getSelectedItems().isEmpty()) {
            LogViewer.copyTextToClipboard(this.selectedLogMessagesToString());
            int numberOfMessagesCopied = this.tableViewLog.getSelectionModel().getSelectedItems().size();
            if (numberOfMessagesCopied == 1) {
                this.setStatus(resources.getString("LogCount.1MessageCopied"));
            } else {
                this.setStatus(MessageFormat.format(resources.getString("LogCount.XMessagesCopied"), numberOfMessagesCopied));
            }
        }
    }

    @FXML
    private void selectAllMessages() {
        this.tableViewLog.getSelectionModel().selectAll();
    }

    @FXML
    private void clearLogs() {
        this.logViewerModel.clearAllLogs();
    }

    @FXML
    private void onThreadItemSelected(ActionEvent e) {
        RadioMenuItem item = (RadioMenuItem)e.getSource();
        if (item != this.allThreadsItem) {
            this.logViewerModel.displayOneThread(item.getText());
        }
    }

    @FXML
    private void onDisplayedLogLevelsItemClicked(ActionEvent actionEvent) {
        ToggleButton item = (ToggleButton)actionEvent.getSource();
        if (item.isSelected()) {
            this.logViewerModel.displayLogLevel(item.getText());
        } else {
            this.logViewerModel.hideLogLevel(item.getText());
        }
    }

    @FXML
    private void onWarnCountClicked() {
        int indexOfLastUnselectedMessage = this.getIndexOfLastUnselectedMessage(Level.WARN);
        if (indexOfLastUnselectedMessage >= 0 && indexOfLastUnselectedMessage < this.tableViewLog.getItems().size()) {
            this.tableViewLog.getSelectionModel().clearAndSelect(indexOfLastUnselectedMessage);
            this.tableViewLog.scrollTo(indexOfLastUnselectedMessage);
        }
    }

    @FXML
    private void onErrorCountClicked() {
        int indexOfLastUnselectedMessage = this.getIndexOfLastUnselectedMessage(Level.ERROR);
        if (indexOfLastUnselectedMessage >= 0 && indexOfLastUnselectedMessage < this.tableViewLog.getItems().size()) {
            this.tableViewLog.getSelectionModel().clearAndSelect(indexOfLastUnselectedMessage);
            this.tableViewLog.scrollTo(indexOfLastUnselectedMessage);
        }
    }

    private static String toStyleClass(Level level) {
        return level.name().toLowerCase();
    }

    private void setUpDisplayedLogLevels() {
        this.displayErrorButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.minimumLevel.getValue() != null) {
                return this.logViewerModel.getAllLogsMessageCounts().errorLevelCountsProperty().get() == 0 && ((Level)this.minimumLevel.getValue()).toInt() > Level.ERROR.toInt();
            }
            return false;
        }, (Observable[])new Observable[]{this.logViewerModel.getAllLogsMessageCounts().errorLevelCountsProperty(), this.minimumLevel.valueProperty()}));
        this.displayWarnButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.minimumLevel.getValue() != null) {
                return this.logViewerModel.getAllLogsMessageCounts().warnLevelCountsProperty().get() == 0 && ((Level)this.minimumLevel.getValue()).toInt() > Level.WARN.toInt();
            }
            return false;
        }, (Observable[])new Observable[]{this.logViewerModel.getAllLogsMessageCounts().warnLevelCountsProperty(), this.minimumLevel.valueProperty()}));
        this.displayDebugButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.minimumLevel.getValue() != null) {
                return this.logViewerModel.getAllLogsMessageCounts().debugLevelCountsProperty().get() == 0 && ((Level)this.minimumLevel.getValue()).toInt() > Level.DEBUG.toInt();
            }
            return false;
        }, (Observable[])new Observable[]{this.logViewerModel.getAllLogsMessageCounts().debugLevelCountsProperty(), this.minimumLevel.valueProperty()}));
        this.displayInfoButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.minimumLevel.getValue() != null) {
                return this.logViewerModel.getAllLogsMessageCounts().infoLevelCountsProperty().get() == 0 && ((Level)this.minimumLevel.getValue()).toInt() > Level.INFO.toInt();
            }
            return false;
        }, (Observable[])new Observable[]{this.logViewerModel.getAllLogsMessageCounts().infoLevelCountsProperty(), this.minimumLevel.valueProperty()}));
        this.displayTraceButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (this.minimumLevel.getValue() != null) {
                return this.logViewerModel.getAllLogsMessageCounts().traceLevelCountsProperty().get() == 0 && ((Level)this.minimumLevel.getValue()).toInt() > Level.TRACE.toInt();
            }
            return false;
        }, (Observable[])new Observable[]{this.logViewerModel.getAllLogsMessageCounts().traceLevelCountsProperty(), this.minimumLevel.valueProperty()}));
        this.displayErrorTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.displayErrorButton.selectedProperty()).then(MessageFormat.format(resources.getString("Toolbar.Level.hide"), "ERROR")).otherwise(MessageFormat.format(resources.getString("Toolbar.Level.show"), "ERROR")));
        this.displayWarnTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.displayWarnButton.selectedProperty()).then(MessageFormat.format(resources.getString("Toolbar.Level.hide"), "WARN")).otherwise(MessageFormat.format(resources.getString("Toolbar.Level.show"), "WARN")));
        this.displayInfoTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.displayInfoButton.selectedProperty()).then(MessageFormat.format(resources.getString("Toolbar.Level.hide"), "INFO")).otherwise(MessageFormat.format(resources.getString("Toolbar.Level.show"), "INFO")));
        this.displayDebugTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.displayDebugButton.selectedProperty()).then(MessageFormat.format(resources.getString("Toolbar.Level.hide"), "DEBUG")).otherwise(MessageFormat.format(resources.getString("Toolbar.Level.show"), "DEBUG")));
        this.displayTraceTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.displayTraceButton.selectedProperty()).then(MessageFormat.format(resources.getString("Toolbar.Level.hide"), "TRACE")).otherwise(MessageFormat.format(resources.getString("Toolbar.Level.show"), "TRACE")));
        this.minimumLevel.getItems().addAll((Object[])Level.values());
        if (this.logViewerModel.getLoggingFrameworkFoundProperty().get()) {
            this.minimumLevel.getSelectionModel().select((Object)this.logViewerModel.getRootLevel());
            this.minimumLevel.valueProperty().addListener(change -> this.logViewerModel.setRootLevel((Level)this.minimumLevel.getValue()));
        }
    }

    private void setUpMessageFilter() {
        this.logViewerModel.getFilterByRegexProperty().bind((ObservableValue)this.regexButton.selectedProperty());
        this.logViewerModel.getFilterProperty().bind((ObservableValue)this.messageFilter.textProperty());
        this.messageFilter.promptTextProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getFilterByRegexProperty()).then(resources.getString("Toolbar.Filter.filterByRegex")).otherwise(resources.getString("Toolbar.Filter.filterByText")));
        this.regexTooltip.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getFilterByRegexProperty()).then(resources.getString("Toolbar.Filter.filterByText")).otherwise(resources.getString("Toolbar.Filter.filterByRegex")));
    }

    private void setUpTable() {
        this.tableViewLog.placeholderProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getLoggingFrameworkFoundProperty()).then((Object)new Label(resources.getString("Table.noLogs"))).otherwise((Object)new Label(resources.getString("Table.noLoggingManagerFound"))));
        this.tableViewLog.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.tableViewLog.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY_FLEX_LAST_COLUMN);
        this.tableViewLog.getSelectionModel().selectedItemProperty().addListener((l, o, n) -> this.handleLogMessageSelectionChange((LogMessage)n));
        this.tableViewLog.setItems(this.logViewerModel.getFilteredLogs());
        this.tableViewLog.getItems().addListener(change -> {
            if (!this.isLogShowing()) {
                return;
            }
            int numAdditionalRows = 0;
            while (change.next()) {
                numAdditionalRows += change.getAddedSize() - change.getRemovedSize();
            }
            if (numAdditionalRows == 0) {
                return;
            }
            int numCurrentRows = change.getList().size();
            int numPreviousRows = numCurrentRows - numAdditionalRows;
            VirtualFlow virtualFlow = this.virtualFlows.computeIfAbsent(this.tableViewLog.getSkin(), LogViewer::findVirtualFlow);
            if (virtualFlow != null && numCurrentRows > 0) {
                int currentLastVisibleIndex;
                IndexedCell lastVisible = virtualFlow.getLastVisibleCell();
                int n = currentLastVisibleIndex = lastVisible == null ? -1 : lastVisible.getIndex();
                if (currentLastVisibleIndex < this.previousLastVisibleIndex) {
                    this.scrollToBottom = false;
                } else if (currentLastVisibleIndex >= numPreviousRows - 1) {
                    this.scrollToBottom = true;
                }
                if (this.scrollToBottom) {
                    this.tableViewLog.scrollTo(numCurrentRows - 1);
                }
                this.previousLastVisibleIndex = currentLastVisibleIndex;
            }
        });
        this.colRow.setCellValueFactory(LogViewer::cellValueFactory);
        this.colLevel.setCellValueFactory(LogViewer::cellValueFactory);
        this.colThread.setCellValueFactory(LogViewer::cellValueFactory);
        this.colLogger.setCellValueFactory(LogViewer::cellValueFactory);
        this.colTimestamp.setCellValueFactory(LogViewer::cellValueFactory);
        this.colMessage.setCellValueFactory(LogViewer::cellValueFactory);
        this.colRow.setCellFactory(column -> new TableRowTableCell(logMessage -> ""));
        this.colLevel.setCellFactory(column -> new LogLevelTableCell(logMessage -> String.valueOf(logMessage.level())));
        this.colLogger.setCellFactory(column -> new CompactTableCell(LogMessage::loggerName, "."));
        this.colThread.setCellFactory(column -> new GenericTableCell(LogMessage::threadName));
        this.colTimestamp.setCellFactory(column -> new GenericTableCell(logMessage -> TIMESTAMP_FORMAT.format(new Date(logMessage.timestamp()))));
        this.colMessage.setCellFactory(column -> new GenericTableCell(LogMessage::message));
    }

    private void setUpFooter() {
        this.warningsCount.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            int numberOfWarnMessages = this.logViewerModel.getAllLogsMessageCounts().warnLevelCountsProperty().get();
            if (numberOfWarnMessages == 0) {
                return "";
            }
            if (this.displayWarnButton.isSelected()) {
                if (numberOfWarnMessages == 1) {
                    return resources.getString("LogCount.1Warning");
                }
                return MessageFormat.format(resources.getString("LogCount.XWarnings"), numberOfWarnMessages);
            }
            return resources.getString("LogCount.warningsHidden");
        }, (Observable[])new Observable[]{this.displayWarnButton.selectedProperty(), this.logViewerModel.getAllLogsMessageCounts().warnLevelCountsProperty()}));
        this.warningsCount.managedProperty().bind((ObservableValue)Bindings.notEqual((ObservableNumberValue)this.logViewerModel.getAllLogsMessageCounts().warnLevelCountsProperty(), (int)0));
        this.warningsCount.cursorProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getFilteredLogsMessageCounts().warnLevelCountsProperty().isEqualTo(0)).then((Object)Cursor.DEFAULT).otherwise((Object)Cursor.HAND));
        this.errorsCount.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            int numberOfErrorMessages = this.logViewerModel.getAllLogsMessageCounts().errorLevelCountsProperty().get();
            if (numberOfErrorMessages == 0) {
                return "";
            }
            if (this.displayErrorButton.isSelected()) {
                if (numberOfErrorMessages == 1) {
                    return resources.getString("LogCount.1Error");
                }
                return MessageFormat.format(resources.getString("LogCount.XErrors"), numberOfErrorMessages);
            }
            return resources.getString("LogCount.errorsHidden");
        }, (Observable[])new Observable[]{this.displayErrorButton.selectedProperty(), this.logViewerModel.getAllLogsMessageCounts().errorLevelCountsProperty()}));
        this.errorsCount.managedProperty().bind((ObservableValue)Bindings.notEqual((ObservableNumberValue)this.logViewerModel.getAllLogsMessageCounts().errorLevelCountsProperty(), (int)0));
        this.errorsCount.cursorProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getFilteredLogsMessageCounts().errorLevelCountsProperty().isEqualTo(0)).then((Object)Cursor.DEFAULT).otherwise((Object)Cursor.HAND));
        this.shownCount.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.logViewerModel.getFilteredLogsMessageCounts().allLevelCountsProperty().isEqualTo((ObservableNumberValue)this.logViewerModel.getAllLogsMessageCounts().allLevelCountsProperty())).then((ObservableStringValue)Bindings.concat((Object[])new Object[]{this.logViewerModel.getFilteredLogsMessageCounts().allLevelCountsProperty(), " ", resources.getString("LogCount.total")})).otherwise((ObservableStringValue)Bindings.concat((Object[])new Object[]{this.logViewerModel.getFilteredLogsMessageCounts().allLevelCountsProperty(), "/", this.logViewerModel.getAllLogsMessageCounts().allLevelCountsProperty(), " ", resources.getString("LogCount.shown")})));
        this.clearLogsButton.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)Bindings.size((ObservableList)this.tableViewLog.getItems()), (int)0));
        this.copyButton.disableProperty().bind((ObservableValue)Bindings.equal((ObservableNumberValue)Bindings.size((ObservableList)this.tableViewLog.getSelectionModel().getSelectedItems()), (int)0));
    }

    private void setUpThreadFilter() {
        this.logViewerModel.getDisplayAllThreadsProperty().bind((ObservableValue)this.allThreadsItem.selectedProperty());
        this.logViewerModel.getAllThreads().addListener(change -> {
            String threadName = (String)change.getElementAdded();
            RadioMenuItem item = new RadioMenuItem(threadName);
            item.setOnAction(this::onThreadItemSelected);
            item.setToggleGroup(this.threadFilterGroup);
            ArrayList<RadioMenuItem> newItems = new ArrayList<RadioMenuItem>((Collection<RadioMenuItem>)this.threadFilterMenu.getItems());
            newItems.add(item);
            this.threadFilterMenu.getItems().setAll(newItems);
        });
    }

    private void setStatus(String message) {
        this.status.setText(message);
        FadeTransition fade = new FadeTransition();
        fade.setDuration(Duration.millis((double)5000.0));
        fade.setFromValue(1.0);
        fade.setToValue(0.0);
        fade.setNode((Node)this.status);
        fade.play();
    }

    private boolean isLogShowing() {
        Scene scene = this.getScene();
        if (scene != null) {
            Window window = scene.getWindow();
            return window != null && window.isShowing();
        }
        return false;
    }

    private static VirtualFlow<?> findVirtualFlow(Skin<?> tableSkin) {
        if (tableSkin instanceof TableViewSkin) {
            TableViewSkin skin = (TableViewSkin)tableSkin;
            return skin.getChildren().stream().filter(VirtualFlow.class::isInstance).map(VirtualFlow.class::cast).findFirst().orElse(null);
        }
        return null;
    }

    private String selectedLogMessagesToString() {
        StringBuilder sb = new StringBuilder();
        for (LogMessage logMessage : this.tableViewLog.getSelectionModel().getSelectedItems()) {
            sb.append(logMessage.toReadableString());
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static void copyTextToClipboard(String text) {
        ClipboardContent content = new ClipboardContent();
        content.putString(text);
        Clipboard.getSystemClipboard().setContent((Map)content);
    }

    private void handleLogMessageSelectionChange(LogMessage logMessage) {
        Object message = "";
        if (logMessage != null) {
            message = logMessage.message();
            if (logMessage.throwable() != null) {
                StringWriter sw = new StringWriter();
                logMessage.throwable().printStackTrace(new PrintWriter(sw));
                message = (String)message + "\n" + sw;
            }
            this.textAreaLog.getStyleClass().removeAll(this.allLogLevelNamesToLowerCase);
            this.textAreaLog.getStyleClass().add((Object)LogViewer.toStyleClass(logMessage.level()));
        }
        this.textAreaLog.setText((String)message);
    }

    private static ObjectProperty<LogMessage> cellValueFactory(TableColumn.CellDataFeatures<LogMessage, LogMessage> cellData) {
        return new SimpleObjectProperty((Object)((LogMessage)cellData.getValue()));
    }

    private int getIndexOfLastUnselectedMessage(Level level) {
        int i;
        int startingIndex;
        ObservableList selectedMessages = this.tableViewLog.getSelectionModel().getSelectedItems();
        ObservableList displayedMessages = this.tableViewLog.getItems();
        LogMessage lastSelectedMessageWithGivenLevel = null;
        for (int i2 = selectedMessages.size() - 1; i2 >= 0; --i2) {
            if (!((LogMessage)selectedMessages.get(i2)).level().equals((Object)level)) continue;
            lastSelectedMessageWithGivenLevel = (LogMessage)selectedMessages.get(i2);
            break;
        }
        if ((startingIndex = displayedMessages.indexOf(lastSelectedMessageWithGivenLevel)) == -1) {
            startingIndex = displayedMessages.size();
        }
        for (i = startingIndex - 1; i >= 0; --i) {
            if (!((LogMessage)displayedMessages.get(i)).level().equals((Object)level)) continue;
            return i;
        }
        for (i = displayedMessages.size() - 1; i >= 0; --i) {
            if (!((LogMessage)displayedMessages.get(i)).level().equals((Object)level)) continue;
            return i;
        }
        return -1;
    }
}

