/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.main;

import javafx.application.Platform;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.collections.ObservableList;
import org.slf4j.event.Level;
import qupath.ui.logviewer.api.LogMessage;

public class LogMessageCounts {
    private final ReadOnlyIntegerWrapper allMessagesCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper errorLevelCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper warnLevelCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper infoLevelCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper debugLevelCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper traceLevelCount = new ReadOnlyIntegerWrapper(0);

    public LogMessageCounts(ObservableList<LogMessage> messages) {
        for (LogMessage logMessage : messages) {
            this.countMessage(logMessage, Operation.INCREASE);
        }
        messages.addListener(change -> {
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(logMessage -> this.countMessage((LogMessage)logMessage, Operation.INCREASE));
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(logMessage -> this.countMessage((LogMessage)logMessage, Operation.DECREASE));
            }
        });
    }

    public ReadOnlyIntegerProperty allLevelCountsProperty() {
        return this.allMessagesCount.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty errorLevelCountsProperty() {
        return this.errorLevelCount.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty warnLevelCountsProperty() {
        return this.warnLevelCount.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty infoLevelCountsProperty() {
        return this.infoLevelCount.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty debugLevelCountsProperty() {
        return this.debugLevelCount.getReadOnlyProperty();
    }

    public ReadOnlyIntegerProperty traceLevelCountsProperty() {
        return this.traceLevelCount.getReadOnlyProperty();
    }

    private void countMessage(LogMessage logMessage, Operation operation) {
        if (Platform.isFxApplicationThread()) {
            this.modifyCounter(this.allMessagesCount, operation);
            this.modifyCounter(switch (logMessage.level()) {
                default -> throw new IncompatibleClassChangeError();
                case Level.ERROR -> this.errorLevelCount;
                case Level.WARN -> this.warnLevelCount;
                case Level.INFO -> this.infoLevelCount;
                case Level.DEBUG -> this.debugLevelCount;
                case Level.TRACE -> this.traceLevelCount;
            }, operation);
        } else {
            Platform.runLater(() -> this.countMessage(logMessage, operation));
        }
    }

    private void modifyCounter(ReadOnlyIntegerWrapper counter, Operation operation) {
        int delta = switch (operation) {
            default -> throw new IncompatibleClassChangeError();
            case Operation.INCREASE -> 1;
            case Operation.DECREASE -> -1;
        };
        counter.set(counter.get() + delta);
    }

    private static enum Operation {
        INCREASE,
        DECREASE;

    }
}

