/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.opencv.opencv_core;

import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.Loader;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Scalar;

@Properties(inherit={org.bytedeco.opencv.presets.opencv_core.class})
public abstract class AbstractScalar
extends DoublePointer {
    public static final Scalar ZERO;
    public static final Scalar ONE;
    public static final Scalar ONEHALF;
    public static final Scalar ALPHA1;
    public static final Scalar ALPHA255;
    public static final Scalar WHITE;
    public static final Scalar GRAY;
    public static final Scalar BLACK;
    public static final Scalar RED;
    public static final Scalar GREEN;
    public static final Scalar BLUE;
    public static final Scalar CYAN;
    public static final Scalar MAGENTA;
    public static final Scalar YELLOW;

    public AbstractScalar(Pointer p) {
        super(p);
    }

    public void scale(double s) {
        for (int i = 0; i < 4; ++i) {
            this.put(i, this.get(i) * s);
        }
    }

    public double red() {
        return this.get(2L);
    }

    public double green() {
        return this.get(1L);
    }

    public double blue() {
        return this.get(0L);
    }

    public Scalar red(double r) {
        this.put(2L, r);
        return (Scalar)this;
    }

    public Scalar green(double g) {
        this.put(1L, g);
        return (Scalar)this;
    }

    public Scalar blue(double b) {
        this.put(0L, b);
        return (Scalar)this;
    }

    public double magnitude() {
        return Math.sqrt(this.get(0L) * this.get(0L) + this.get(1L) * this.get(1L) + this.get(2L) * this.get(2L) + this.get(3L) * this.get(3L));
    }

    public String toString() {
        if (this.isNull()) {
            return super.toString();
        }
        if (this.capacity() == 0L) {
            return "(" + (float)this.get(0L) + ", " + (float)this.get(1L) + ", " + (float)this.get(2L) + ", " + (float)this.get(3L) + ")";
        }
        String s = "";
        long p = this.position();
        for (long i = 0L; i < this.capacity(); ++i) {
            this.position(i);
            s = s + (i == 0L ? "(" : " (") + (float)this.get(0L) + ", " + (float)this.get(1L) + ", " + (float)this.get(2L) + ", " + (float)this.get(3L) + ")";
        }
        this.position(p);
        return s;
    }

    static {
        Loader.load();
        ZERO = (Scalar)new Scalar(0.0, 0.0, 0.0, 0.0).retainReference();
        ONE = (Scalar)new Scalar(1.0, 1.0, 1.0, 1.0).retainReference();
        ONEHALF = (Scalar)new Scalar(0.5, 0.5, 0.5, 0.5).retainReference();
        ALPHA1 = (Scalar)new Scalar(0.0, 0.0, 0.0, 1.0).retainReference();
        ALPHA255 = (Scalar)new Scalar(0.0, 0.0, 0.0, 255.0).retainReference();
        WHITE = (Scalar)opencv_core.RGB(255.0, 255.0, 255.0).retainReference();
        GRAY = (Scalar)opencv_core.RGB(128.0, 128.0, 128.0).retainReference();
        BLACK = (Scalar)opencv_core.RGB(0.0, 0.0, 0.0).retainReference();
        RED = (Scalar)opencv_core.RGB(255.0, 0.0, 0.0).retainReference();
        GREEN = (Scalar)opencv_core.RGB(0.0, 255.0, 0.0).retainReference();
        BLUE = (Scalar)opencv_core.RGB(0.0, 0.0, 255.0).retainReference();
        CYAN = (Scalar)opencv_core.RGB(0.0, 255.0, 255.0).retainReference();
        MAGENTA = (Scalar)opencv_core.RGB(255.0, 0.0, 255.0).retainReference();
        YELLOW = (Scalar)opencv_core.RGB(255.0, 255.0, 0.0).retainReference();
    }
}

