/*
 * Decompiled with CFR 0.152.
 */
package qupath;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import qupath.QuPath;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreFactory;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.scripting.QPEx;
import qupath.lib.gui.scripting.languages.ScriptLanguageProvider;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerProvider;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.scripting.QP;
import qupath.lib.scripting.ScriptParameters;
import qupath.lib.scripting.languages.ExecutableLanguage;
import qupath.lib.scripting.languages.ScriptLanguage;

@CommandLine.Command(name="script", description={"Runs script for a given image or project.", "By default, this will not save changes to any data files."})
class ScriptCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ScriptCommand.class);
    private static final String DEFAULT_SCRIPT_EXTENSION = ".groovy";
    @CommandLine.Parameters(index="0", description={"Path to the script file (.groovy)."}, arity="0..1", paramLabel="script")
    private String scriptFile;
    @CommandLine.Option(names={"-c", "--cmd"}, description={"Groovy script passed as a string"}, paramLabel="command")
    private String scriptCommand;
    @CommandLine.Option(names={"-i", "--image"}, description={"Apply the script to the specified image.", "This should be the image name if a project is also specified, otherwise it should be the full image path."}, paramLabel="image")
    private String imagePath;
    @CommandLine.Option(names={"-p", "--project"}, description={"Path to a project file (.qpproj)."}, paramLabel="project")
    private String projectPath;
    @CommandLine.Option(names={"-s", "--save"}, description={"Request that data files are updated for each image in the project."}, paramLabel="save")
    private boolean save;
    @CommandLine.Option(names={"-a", "--args"}, description={"Arguments to pass to the script, stored in an 'args' array variable. Multiple args can be passed by using --args multiple times, or by using a \"[quoted,comma,separated,list]\"."}, paramLabel="arguments")
    private String[] args;
    @CommandLine.Option(names={"-e", "--server"}, description={"Arguments to pass when building an ImageSever (only relevant when using --image). For example, --server \"[--classname,BioFormatsServerBuilder,--series,2]\" may be used to read the image with Bio-Formats and extract the third series within the file."}, paramLabel="server-arguments")
    private String[] serverArgs;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit."})
    private boolean usageHelpRequested;

    ScriptCommand() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.projectPath != null && !this.projectPath.toLowerCase().endsWith(ProjectIO.getProjectExtension())) {
                throw new IOException("Project file must end with '.qpproj'");
            }
            if (this.scriptCommand == null) {
                if (this.scriptFile == null || this.scriptFile.equals("") || !this.scriptFile.endsWith(DEFAULT_SCRIPT_EXTENSION)) {
                    throw new IOException("File must be a valid script file (.groovy): " + this.scriptFile);
                }
            } else if (this.scriptFile != null) {
                throw new IllegalArgumentException("Either a script file or a script command may be provided, but not both!");
            }
            this.createTileCache();
            ImageServerProvider.setServiceLoader(ServiceLoader.load(ImageServerBuilder.class, QuPathGUI.getExtensionCatalogManager().getExtensionClassLoader()));
            Thread.currentThread().setContextClassLoader(QuPathGUI.getExtensionCatalogManager().getExtensionClassLoader());
            QP.getCoreClasses();
            if (this.projectPath != null && !this.projectPath.equals("")) {
                String path = QuPath.getEncodedPath(this.projectPath);
                Project project = ProjectIO.loadProject((File)new File(path), BufferedImage.class);
                List<ProjectImageEntry> imageList = project.getImageList();
                if (this.imagePath != null && !this.imagePath.equals("")) {
                    imageList = imageList.stream().filter(e -> this.imagePath.equals(e.getImageName())).toList();
                }
                int batchSize = imageList.size();
                for (int batchIndex = 0; batchIndex < batchSize; ++batchIndex) {
                    ProjectImageEntry entry = (ProjectImageEntry)imageList.get(batchIndex);
                    logger.info("Running script for {} ({}/{})", new Object[]{entry.getImageName(), batchIndex, batchSize});
                    ImageData imageData = entry.readImageData();
                    try {
                        Object result = this.runBatchScript((Project<BufferedImage>)project, (ImageData<BufferedImage>)imageData, batchIndex, batchSize, this.save);
                        if (result != null) {
                            logger.info("Script result: {}", result);
                        }
                        if (!this.save) continue;
                        entry.saveImageData(imageData);
                        continue;
                    }
                    catch (Exception e2) {
                        logger.error("Error running script for image: " + entry.getImageName(), (Throwable)e2);
                        if (this.imagePath == null || !this.imagePath.equals(entry.getImageName())) continue;
                        throw new RuntimeException(e2);
                    }
                    finally {
                        imageData.getServer().close();
                    }
                }
                if (this.save) {
                    project.syncChanges();
                }
            } else if (this.imagePath != null && !this.imagePath.equals("")) {
                String path = QuPath.getEncodedPath(this.imagePath);
                URI uri = GeneralTools.toURI((String)path);
                ImageServer server = ImageServers.buildServer((URI)uri, (String[])ScriptCommand.parseArgs(this.serverArgs));
                ImageData imageData = new ImageData(server);
                Object result = this.runSingleScript(null, (ImageData<BufferedImage>)imageData);
                if (result != null) {
                    logger.info("Script result: {}", result);
                }
                server.close();
            } else {
                Object result = this.runSingleScript(null, null);
                if (result != null) {
                    logger.info("Script result: {}", result);
                }
            }
        }
        catch (Exception e3) {
            logger.error(e3.getLocalizedMessage(), (Throwable)e3);
            throw new RuntimeException(e3);
        }
    }

    private static String[] parseArgs(String[] args) {
        String arg;
        if (args == null) {
            return new String[0];
        }
        if (args.length == 1 && (arg = args[0]).startsWith("[") && arg.endsWith("]")) {
            return arg.substring(1, arg.length() - 1).split(",");
        }
        return (String[])args.clone();
    }

    private void createTileCache() {
        double percentage;
        Runtime rt = Runtime.getRuntime();
        long maxAvailable = rt.maxMemory();
        if (maxAvailable == Long.MAX_VALUE) {
            logger.warn("No inherent maximum memory set - for caching purposes, will assume 64 GB");
            maxAvailable = 0x1000000000L;
        }
        if ((percentage = PathPrefs.tileCachePercentageProperty().get()) < 10.0) {
            logger.warn("At least 10% of available memory needs to be used for tile caching (you requested {}%)", (Object)percentage);
            percentage = 10.0;
        } else if (percentage > 90.0) {
            logger.warn("No more than 90% of available memory can be used for tile caching (you requested {}%)", (Object)percentage);
            percentage = 90.0;
        }
        long tileCacheSize = Math.round((double)maxAvailable * (percentage / 100.0));
        logger.info(String.format("Setting tile cache size to %.2f MB (%.1f%% max memory)", (double)tileCacheSize / 1048576.0, percentage));
        DefaultImageRegionStore imageRegionStore = ImageRegionStoreFactory.createImageRegionStore((long)tileCacheSize);
        ImageServerProvider.setCache((Map)imageRegionStore.getCache(), BufferedImage.class);
    }

    private Object runSingleScript(Project<BufferedImage> project, ImageData<BufferedImage> imageData) throws IOException, ScriptException {
        return this.runBatchScript(project, imageData, 0, 1, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object runBatchScript(Project<BufferedImage> project, ImageData<BufferedImage> imageData, int batchIndex, int batchSize, boolean batchSave) throws IOException, ScriptException {
        ScriptLanguage scriptLanguage;
        Object result = null;
        String script = this.scriptCommand;
        String ext = DEFAULT_SCRIPT_EXTENSION;
        if (this.scriptFile != null) {
            ext = GeneralTools.getExtension((String)this.scriptFile).orElse(DEFAULT_SCRIPT_EXTENSION);
        }
        if ((scriptLanguage = ScriptLanguageProvider.getLanguageFromExtension((String)ext)) == null || !(scriptLanguage instanceof ExecutableLanguage)) {
            throw new IllegalArgumentException("No runnable script language found for " + this.scriptFile);
        }
        ExecutableLanguage language = (ExecutableLanguage)scriptLanguage;
        File file = null;
        if (script == null) {
            String filePath = QuPath.getEncodedPath(this.scriptFile);
            file = new File(filePath);
            script = GeneralTools.readFileAsString((String)filePath);
        } else if (GeneralTools.isWindows() && !StandardCharsets.US_ASCII.newEncoder().canEncode(script)) {
            logger.warn("Non-ASCII characters detected in the specified script! If you experience encoding issues, try passing a script file instead.");
        }
        PrintWriter outWriter = new PrintWriter(System.out, true);
        PrintWriter errWriter = new PrintWriter(System.err, true);
        ScriptParameters params = ScriptParameters.builder().setArgs(ScriptCommand.parseArgs(this.args)).setProject(project).setImageData(imageData).setDefaultImports(QPEx.getCoreClasses()).setDefaultStaticImports(Collections.singletonList(QPEx.class)).setFile(file).setScript(script).setBatchSize(batchSize).setBatchIndex(batchIndex).setBatchSaveResult(batchSave).setWriter((Writer)outWriter).setErrorWriter((Writer)errWriter).build();
        try {
            result = language.execute(params);
        }
        finally {
            outWriter.flush();
            errWriter.flush();
        }
        return result;
    }
}

