/*
 * Decompiled with CFR 0.152.
 */
package qupath;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.AutoComplete;
import picocli.CommandLine;
import qupath.ScriptCommand;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.Version;
import qupath.lib.gui.BuildInfo;
import qupath.lib.gui.QuPathApp;
import qupath.lib.gui.extensions.Subcommand;
import qupath.lib.gui.logging.LogManager;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tma.QuPathTMAViewer;
import qupath.lib.projects.ProjectIO;
import qupath.lib.roi.GeometryTools;

@CommandLine.Command(name="QuPath", subcommands={CommandLine.HelpCommand.class, ScriptCommand.class, AutoComplete.GenerateCompletion.class}, footer={"", "Copyright(c) The Queen's University Belfast (2014-2016)", "Copyright(c) QuPath developers (2017-2025)", "Copyright(c) The University of Edinburgh (2018-2025)"}, mixinStandardHelpOptions=true, versionProvider=VersionProvider.class)
public class QuPath {
    private static final Logger logger = LoggerFactory.getLogger(QuPath.class);
    @CommandLine.Parameters(arity="0..1", description={"Path to image or project to open"}, hidden=true)
    private String path;
    @CommandLine.Option(names={"-r", "--reset"}, description={"Reset all QuPath preferences."})
    private boolean reset;
    @CommandLine.Option(names={"-q", "--quiet"}, description={"Launch QuPath quietly, without setup dialogs, update checks or messages."})
    private boolean quiet;
    @CommandLine.Option(names={"-p", "--project"}, description={"Launch QuPath and open specified project."})
    private String project;
    @CommandLine.Option(names={"-i", "--image"}, description={"Launch QuPath and open the specified image.", "This should be the image name if a project is also specified, otherwise it should be the full image path."})
    private String image;
    @CommandLine.Option(names={"-t", "--tma"}, description={"Launch standalone viewer for TMA summary results."})
    private boolean tma;
    @CommandLine.Option(names={"-l", "--log"}, description={"Log level (default = INFO).", "Options: ${COMPLETION-CANDIDATES}"})
    private LogManager.LogLevel logLevel = LogManager.LogLevel.INFO;
    @CommandLine.Option(names={"-D"}, description={"Pass system properties to the QuPath launcher."})
    private Map<String, String> systemProperties;

    public static void main(String[] args) {
        CommandLine.ParseResult pr;
        QuPath.initializeProperties();
        QuPath qupath = new QuPath();
        CommandLine cmd = new CommandLine((Object)qupath);
        cmd.setCaseInsensitiveEnumValuesAllowed(true);
        cmd.setExpandAtFiles(false);
        ((CommandLine)cmd.getSubcommands().get("generate-completion")).getCommandSpec().usageMessage().hidden(true);
        for (Subcommand subcommand : ServiceLoader.load(Subcommand.class)) {
            cmd.addSubcommand((Object)subcommand);
        }
        cmd.setExitCodeExceptionMapper(t -> 1);
        try {
            pr = cmd.parseArgs(args);
        }
        catch (Exception e) {
            logger.error("An error has occurred, please type -h to display help message.\n{}", (Object)e.getLocalizedMessage());
            return;
        }
        if (qupath.systemProperties != null) {
            for (Map.Entry<String, String> entry : qupath.systemProperties.entrySet()) {
                logger.info("Setting system property {}={}", (Object)entry.getKey(), (Object)entry.getValue());
                System.setProperty(entry.getKey(), entry.getValue());
            }
        }
        if (cmd.isUsageHelpRequested()) {
            cmd.usage(System.out);
            return;
        }
        if (cmd.isVersionHelpRequested()) {
            cmd.printVersionHelp(System.out);
            return;
        }
        if (qupath.reset) {
            PathPrefs.resetPreferences();
        }
        if (qupath.logLevel != null) {
            LogManager.setRootLogLevel((LogManager.LogLevel)qupath.logLevel);
        }
        if (qupath.tma) {
            QuPathTMAViewer.launch(QuPathTMAViewer.class, (String[])new String[0]);
            return;
        }
        if (!pr.hasSubcommand()) {
            ArrayList<Object> CLIArgs = new ArrayList<Object>();
            if (qupath.path != null && !qupath.path.isBlank()) {
                CLIArgs.add(QuPath.getEncodedPath(qupath.path));
            }
            if (qupath.quiet) {
                CLIArgs.add("--quiet=true");
            }
            if (qupath.project != null && !qupath.project.isEmpty() && qupath.project.endsWith(ProjectIO.getProjectExtension())) {
                CLIArgs.add("--project=" + QuPath.getEncodedPath(qupath.project));
            }
            if (qupath.image != null && !qupath.image.isEmpty()) {
                CLIArgs.add("--image=" + QuPath.getEncodedPath(qupath.image));
            }
            QuPathApp.launch(QuPathApp.class, (String[])((String[])CLIArgs.toArray(String[]::new)));
        } else {
            int exitCode = cmd.execute(args);
            if (exitCode != 0) {
                logger.warn("Calling System.exit with exit code {}", (Object)exitCode);
            }
            System.exit(exitCode);
        }
    }

    private static void initializeSciJava() {
        try {
            Class<?> cls = Class.forName("org.scijava.Context");
            cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            logger.info("SciJava context initialized!");
        }
        catch (ClassNotFoundException e) {
            logger.debug("SciJava Context not found");
        }
        catch (Exception e) {
            logger.warn("Exception trying to create SciJava Context: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void initializeProperties() {
        QuPath.initializeDJL();
        QuPath.initializeJTS();
    }

    private static void initializeDJL() {
        if (System.getProperty("ai.djl.offline", null) == null) {
            System.setProperty("ai.djl.offline", "true");
        }
    }

    private static void initializeJTS() {
        GeometryTools.getDefaultFactory();
    }

    static String getEncodedPath(String path) {
        String pathUTF8;
        if (path == null || !GeneralTools.isWindows() || StandardCharsets.US_ASCII.newEncoder().canEncode(path)) {
            return path;
        }
        if (!new File(path).exists() && new File(pathUTF8 = new String(path.getBytes(), StandardCharsets.UTF_8)).exists()) {
            logger.warn("Updated path encoding to UTF-8: {}", (Object)pathUTF8);
            return pathUTF8;
        }
        return path;
    }

    static {
        QuPath.initializeSciJava();
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        public String[] getVersion() throws Exception {
            Version version = BuildInfo.getInstance().getVersion();
            String buildString = BuildInfo.getInstance().getBuildString();
            ArrayList<Object> strings = new ArrayList<Object>();
            if (version != null && version != Version.UNKNOWN) {
                Object temp = version.toString();
                if (!((String)temp).startsWith("v")) {
                    temp = "v" + (String)temp;
                }
                strings.add("QuPath " + (String)temp);
            }
            if (buildString != null) {
                strings.add(buildString);
            }
            if (strings.isEmpty()) {
                return new String[]{"Unknown QuPath version!"};
            }
            strings.add("");
            return (String[])strings.toArray(String[]::new);
        }
    }
}

