/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.sizes;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.Model;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.sizes.DataDependentSize;
import qupath.bioimageio.spec.tensor.sizes.FixedSize;
import qupath.bioimageio.spec.tensor.sizes.ParameterizedSize;
import qupath.bioimageio.spec.tensor.sizes.ReferencedSize;

public interface Size {
    public static final int NO_SIZE = -1;

    public int size();

    public int getTargetSize(int var1);

    public int getStep();

    public int getMin();

    public void validate(List<? extends BaseTensor> var1);

    public static Size deserializeSize(JsonDeserializationContext context, JsonElement jsonElement, JsonElement scale) {
        Logger logger = LoggerFactory.getLogger(Size.class);
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return null;
        }
        if (jsonElement.isJsonPrimitive()) {
            return new FixedSize(jsonElement.getAsInt());
        }
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (obj.has("min") && obj.has("step")) {
                return (Size)context.deserialize((JsonElement)obj, ParameterizedSize.class);
            }
            if (obj.has("axis_id") && obj.has("tensor_id")) {
                return new ReferencedSize(obj.get("axis_id").getAsString(), obj.get("tensor_id").getAsString(), scale != null ? scale.getAsDouble() : 1.0, Model.deserializeField(context, obj, "offset", Integer.class, 1));
            }
            return new DataDependentSize(Model.deserializeField(context, obj, "min", Integer.class, 1), Model.deserializeField(context, obj, "max", Integer.class, 1));
        }
        logger.error("Unknown JSON element {}", (Object)jsonElement);
        throw new JsonParseException("No idea what type of size this is, sorry!");
    }
}

