/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.sizes;

import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.List;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.axes.ScaledAxis;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class ReferencedSize
implements Size {
    private volatile String thisID;
    private final String axisId;
    private final String tensorId;
    private final int offset;
    private final double scale;
    private volatile ScaledAxis referenceAxis;

    ReferencedSize(String axisId, String tensorId) {
        this(axisId, tensorId, 1.0, 0);
    }

    ReferencedSize(String axisId, String tensorId, double scale, int offset) {
        this.axisId = axisId;
        this.tensorId = tensorId;
        this.scale = scale;
        this.offset = offset;
    }

    @Override
    public int size() {
        return (int)((double)this.referenceAxis.getSize().size() * this.referenceAxis.getScale() / this.scale + (double)this.offset);
    }

    @Override
    public int getTargetSize(int target) {
        return this.size();
    }

    @Override
    public int getStep() {
        return -1;
    }

    @Override
    public int getMin() {
        return this.size();
    }

    @Override
    public void validate(List<? extends BaseTensor> tensors) {
        BaseTensor tensor = tensors.stream().filter(t -> t.getId().equals(this.tensorId)).findFirst().orElse(null);
        if (tensor == null) {
            throw new JsonParseException("Cannot find reference tensor " + this.tensorId);
        }
        ScaledAxis axis = Arrays.stream(tensor.getAxes()).filter(ax -> ax.getID().equalsIgnoreCase(this.axisId)).findFirst().orElse(null);
        if (axis == null) {
            throw new JsonParseException("Cannot find reference axis " + this.axisId);
        }
        this.referenceAxis = axis;
    }
}

