/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.sizes;

import java.util.List;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class ParameterizedSize
implements Size {
    private final int min;
    private final int step;

    ParameterizedSize(int min, int step) {
        this.min = min;
        this.step = step;
    }

    @Override
    public int size() {
        return this.getTargetSize(1);
    }

    @Override
    public int getTargetSize(int target) {
        if (target < 0 || this.step <= 0) {
            return this.min;
        }
        return this.min + (int)Math.round((double)(target - this.min) / (double)this.step) * this.step;
    }

    @Override
    public int getStep() {
        return this.step;
    }

    @Override
    public int getMin() {
        return this.min;
    }

    @Override
    public void validate(List<? extends BaseTensor> tensors) {
        assert (this.min >= 0);
        assert (this.step >= 0);
    }
}

