/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.axes;

import java.util.List;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.axes.AxisBase;
import qupath.bioimageio.spec.tensor.axes.AxisType;
import qupath.bioimageio.spec.tensor.axes.ScaledAxis;
import qupath.bioimageio.spec.tensor.axes.WithHalo;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class TimeAxes {

    public static enum TimeUnit {
        ATTOSECOND("attosecond"),
        CENTISECOND("centisecond"),
        DAY("day"),
        DECISECOND("decisecond"),
        EXASECOND("exasecond"),
        FEMTOSECOND("femtosecond"),
        GIGASECOND("gigasecond"),
        HECTOSECOND("hectosecond"),
        HOUR("hour"),
        KILOSECOND("kilosecond"),
        MEGASECOND("megasecond"),
        MICROSECOND("microsecond"),
        MILLISECOND("millisecond"),
        MINUTE("minute"),
        NANOSECOND("nanosecond"),
        PETASECOND("petasecond"),
        PICOSECOND("picosecond"),
        SECOND("second"),
        TERASECOND("terasecond"),
        YOCTOSECOND("yoctosecond"),
        YOTTASECOND("yottasecond"),
        ZEPTOSECOND("zeptosecond"),
        ZETTASECOND("zettasecond"),
        NO_UNIT("");

        private final String unit;

        private TimeUnit(String unit) {
            this.unit = unit;
        }

        public static TimeUnit getUnit(String unit) {
            for (TimeUnit tu : TimeUnit.values()) {
                if (!tu.unit.equalsIgnoreCase(unit)) continue;
                return tu;
            }
            return NO_UNIT;
        }
    }

    static class TimeAxisWithHalo
    extends TimeAxis
    implements WithHalo {
        private final int halo;

        TimeAxisWithHalo(String id, String description, TimeUnit unit, double scale, Size size, int halo) {
            super(id, description, unit, scale, size);
            this.halo = halo;
        }

        @Override
        public int getHalo() {
            return this.halo;
        }
    }

    static class TimeAxis
    extends TimeAxisBase {
        private final Size size;

        TimeAxis(String id, String description, TimeUnit unit, double scale, Size size) {
            super(id, description, unit, scale);
            this.size = size;
        }

        @Override
        public Size getSize() {
            return this.size;
        }

        @Override
        public void validate(List<? extends BaseTensor> tensors) {
            this.getSize().validate(tensors);
        }
    }

    static abstract class TimeAxisBase
    extends AxisBase
    implements ScaledAxis {
        private final String type = "time";
        private final TimeUnit unit;
        private final double scale;

        TimeAxisBase(String id, String description, TimeUnit unit, double scale) {
            super(id, description);
            this.unit = unit;
            this.scale = scale;
        }

        @Override
        public AxisType getType() {
            return AxisType.T;
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        public TimeUnit getUnit() {
            return this.unit;
        }
    }
}

