/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.axes;

import java.util.List;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.axes.AxisBase;
import qupath.bioimageio.spec.tensor.axes.AxisType;
import qupath.bioimageio.spec.tensor.axes.ScaledAxis;
import qupath.bioimageio.spec.tensor.axes.WithHalo;
import qupath.bioimageio.spec.tensor.sizes.ReferencedSize;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class SpaceAxes {

    static class SpaceAxisWithHalo
    extends SpaceAxis
    implements WithHalo {
        private ReferencedSize size;
        private final int halo;

        SpaceAxisWithHalo(String id, String description, String unit, double scale, Size size, int halo) {
            super(id, description, unit, scale, size);
            this.halo = halo;
        }

        @Override
        public int getHalo() {
            return this.halo;
        }
    }

    static class SpaceAxis
    extends SpaceAxisBase {
        private final Size size;
        private final boolean concatenable = false;

        SpaceAxis(String id, String description, String unit, double scale, Size size) {
            super(id, description, unit.isEmpty() ? "NO_UNIT" : unit, scale);
            this.size = size;
        }

        @Override
        public Size getSize() {
            return this.size;
        }

        @Override
        public void validate(List<? extends BaseTensor> tensors) {
            this.getSize().validate(tensors);
        }
    }

    static abstract class SpaceAxisBase
    extends AxisBase
    implements ScaledAxis {
        private final SpaceUnit unit;
        private final double scale;

        SpaceAxisBase(String id, String description, String unit, double scale) {
            this(id, description, SpaceUnit.getUnit(unit), scale);
        }

        SpaceAxisBase(String id, String description, SpaceUnit unit, double scale) {
            super(id, description);
            this.unit = unit;
            this.scale = scale;
        }

        @Override
        public AxisType getType() {
            return AxisType.valueOf(this.getID().toUpperCase());
        }

        @Override
        public double getScale() {
            return this.scale;
        }

        public SpaceUnit getUnit() {
            return this.unit;
        }
    }

    public static enum SpaceUnit {
        ATTOMETER("attometer"),
        ANGSTROM("angstrom"),
        CENTIMETER("centimeter"),
        DECIMETER("decimeter"),
        EXAMETER("exameter"),
        FEMTOMETER("femtometer"),
        FOOT("foot"),
        GIGAMETER("gigameter"),
        HECTOMETER("hectometer"),
        INCH("inch"),
        KILOMETER("kilometer"),
        MEGAMETER("megameter"),
        METER("meter"),
        MICROMETER("micrometer"),
        MILE("mile"),
        MILLIMETER("millimeter"),
        NANOMETER("nanometer"),
        PARSEC("parsec"),
        PETAMETER("petameter"),
        PICOMETER("picometer"),
        TERAMETER("terameter"),
        YARD("yard"),
        YOCTOMETER("yoctometer"),
        YOTTAMETER("yottameter"),
        ZEPTOMETER("zeptometer"),
        ZETTAMETER("zettameter"),
        NO_UNIT("");

        private final String unit;

        private SpaceUnit(String unit) {
            this.unit = unit;
        }

        public static SpaceUnit getUnit(String unit) {
            for (SpaceUnit su : SpaceUnit.values()) {
                if (!su.unit.equalsIgnoreCase(unit)) continue;
                return su;
            }
            return NO_UNIT;
        }
    }
}

