/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor.axes;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.Model;
import qupath.bioimageio.spec.tensor.axes.Axis;
import qupath.bioimageio.spec.tensor.axes.BatchAxis;
import qupath.bioimageio.spec.tensor.axes.ChannelAxis;
import qupath.bioimageio.spec.tensor.axes.CharAxis;
import qupath.bioimageio.spec.tensor.axes.IndexAxes;
import qupath.bioimageio.spec.tensor.axes.SpaceAxes;
import qupath.bioimageio.spec.tensor.axes.TimeAxes;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class Axes {
    public static String getAxesString(Axis[] axes) {
        return Arrays.stream(axes).map(a -> a.getType().toString()).collect(Collectors.joining());
    }

    public static Map<Class<?>, JsonDeserializer<?>> getDeserializers() {
        HashMap map = new HashMap();
        map.put(Axis[].class, new AxesDeserializer());
        return map;
    }

    static class AxesDeserializer
    implements JsonDeserializer<Axis[]> {
        private static final Logger logger = LoggerFactory.getLogger(AxesDeserializer.class);

        AxesDeserializer() {
        }

        public Axis[] deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                String s = jsonElement.getAsString();
                Axis[] axes = new Axis[s.length()];
                for (int i = 0; i < axes.length; ++i) {
                    axes[i] = new CharAxis(s.charAt(i));
                }
                return axes;
            }
            if (jsonElement.isJsonArray()) {
                JsonArray arr = jsonElement.getAsJsonArray();
                Axis[] axes = new Axis[arr.size()];
                for (int i = 0; i < axes.length; ++i) {
                    JsonElement curr = arr.get(i);
                    if (curr.isJsonPrimitive()) {
                        axes[i] = new CharAxis(curr.getAsString().charAt(0));
                        continue;
                    }
                    JsonObject oj = curr.getAsJsonObject();
                    String id = Model.deserializeField(context, oj, "id", String.class, "");
                    String desc = Model.deserializeField(context, oj, "description", String.class, "");
                    Size size = Size.deserializeSize(context, oj.get("size"), oj.get("scale"));
                    axes[i] = switch (oj.get("type").getAsString()) {
                        case "time" -> new TimeAxes.TimeAxis(id, desc, TimeAxes.TimeUnit.getUnit(oj.get("unit").getAsString()), oj.get("scale").getAsDouble(), size);
                        case "channel" -> {
                            JsonArray namesJSON = oj.get("channel_names").getAsJsonArray();
                            LinkedList<String> names = new LinkedList<String>();
                            for (JsonElement n : namesJSON) {
                                names.add(n.getAsString());
                            }
                            yield new ChannelAxis(id, desc, names);
                        }
                        case "index" -> new IndexAxes.IndexAxis(id, desc, size);
                        case "space" -> new SpaceAxes.SpaceAxis(id, desc, Model.deserializeField(context, oj, "unit", String.class, ""), Model.deserializeField(context, oj, "scale", Double.class, 1.0), size);
                        case "batch" -> new BatchAxis(id, desc, Model.deserializeField(context, oj, "size", Integer.class, 1));
                        default -> {
                            logger.error("Unknown object {}", (Object)oj);
                            yield null;
                        }
                    };
                }
                return axes;
            }
            logger.error("Unknown JSON element {}", (Object)jsonElement);
            return null;
        }
    }
}

