/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.tensor.Processing;
import qupath.bioimageio.spec.tensor.Shape;
import qupath.bioimageio.spec.tensor.TensorDataDescription;
import qupath.bioimageio.spec.tensor.axes.Axes;

public class Tensors {
    public static Map<Class<?>, JsonDeserializer<?>> getDeserializers() {
        HashMap map = new HashMap();
        map.put(Shape.class, new Shape.Deserializer());
        map.putAll(Axes.getDeserializers());
        map.putAll(Processing.getDeserializers());
        map.put(TensorDataDescription.class, new TensorDataDescriptionDeserializer());
        return map;
    }

    static class TensorDataDescriptionDeserializer
    implements JsonDeserializer<TensorDataDescription> {
        TensorDataDescriptionDeserializer() {
        }

        public TensorDataDescription deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) throws JsonParseException {
            Logger logger = LoggerFactory.getLogger(TensorDataDescription.class);
            if (jsonElement.isJsonNull()) {
                return null;
            }
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject.get("values") != null) {
                    JsonArray vals = jsonObject.get("values").getAsJsonArray();
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (JsonElement val : vals) {
                        if (!(val instanceof JsonPrimitive)) continue;
                        JsonPrimitive prim = val.getAsJsonPrimitive();
                        if (prim.isNumber()) {
                            values.add(prim.getAsNumber());
                        }
                        if (prim.isBoolean()) {
                            values.add(prim.getAsBoolean());
                        }
                        if (!prim.isString()) continue;
                        values.add(prim.getAsString());
                    }
                    return new NominalOrOrdinalDataDescription(NominalOrOrdinalDType.valueOf(jsonObject.get("type").getAsString().toUpperCase()), values);
                }
                JsonElement t = jsonObject.get("type");
                JsonElement r = jsonObject.get("range");
                List range = r == null ? List.of(Optional.empty(), Optional.empty()) : r.getAsJsonArray().asList().stream().map(je -> {
                    Optional o = je.isJsonNull() ? Optional.empty() : Optional.of(Float.valueOf(je.getAsFloat()));
                    return o;
                }).collect(Collectors.toList());
                JsonElement unit = jsonObject.get("unit");
                JsonElement scale = jsonObject.get("scale");
                JsonElement offset = jsonObject.get("offset");
                return new IntervalOrRatioDataDescription(IntervalOrRatioDType.valueOf((t != null ? t.getAsString() : "float32").toUpperCase()), range, unit != null ? unit.getAsString() : "abitrary unit", scale != null ? scale.getAsFloat() : 1.0f, offset != null ? offset.getAsFloat() : 1.0f);
            }
            logger.warn("Unknown data description! Returning null");
            return null;
        }
    }

    public static enum NominalOrOrdinalDType {
        FLOAT32,
        FLOAT64,
        UINT8,
        INT8,
        UINT16,
        INT16,
        UINT32,
        INT32,
        UINT64,
        INT64,
        BOOL;

    }

    public static enum IntervalOrRatioDType {
        FLOAT32,
        FLOAT64,
        UINT8,
        INT8,
        UINT16,
        INT16,
        UINT32,
        INT32,
        UINT64,
        INT64;

    }

    public static class IntervalOrRatioDataDescription
    implements TensorDataDescription {
        private final IntervalOrRatioDType type;
        private final List<Optional<Float>> range;
        private final String unit;
        private final float scale;
        private final float offset;

        IntervalOrRatioDataDescription(IntervalOrRatioDType type, List<Optional<Float>> range, String unit, float scale, float offset) {
            this.type = type;
            this.range = range;
            this.unit = unit;
            this.scale = scale;
            this.offset = offset;
        }

        IntervalOrRatioDataDescription(IntervalOrRatioDType type, List<Optional<Float>> range, String unit, float scale) {
            this(type, range, unit, scale, 0.0f);
        }

        IntervalOrRatioDataDescription(IntervalOrRatioDType type, List<Optional<Float>> range, String unit) {
            this(type, range, unit, 1.0f, 0.0f);
        }

        IntervalOrRatioDataDescription(IntervalOrRatioDType type, List<Optional<Float>> range) {
            this(type, range, "aritrary unit", 1.0f, 0.0f);
        }

        IntervalOrRatioDataDescription(IntervalOrRatioDType type) {
            this(type, List.of(Optional.empty(), Optional.empty()), "aritrary unit", 1.0f, 0.0f);
        }

        public IntervalOrRatioDType getType() {
            return this.type;
        }

        public List<Optional<Float>> getRange() {
            return this.range;
        }

        public String getUnit() {
            return this.unit;
        }

        public float getScale() {
            return this.scale;
        }

        public float getOffset() {
            return this.offset;
        }
    }

    public static class NominalOrOrdinalDataDescription
    implements TensorDataDescription {
        private final NominalOrOrdinalDType type;
        private final List<?> values;

        public List<?> getValues() {
            return this.values;
        }

        public NominalOrOrdinalDType getType() {
            return this.type;
        }

        NominalOrOrdinalDataDescription(NominalOrOrdinalDType type, List<?> values) {
            this.type = type;
            this.values = values;
        }
    }
}

