/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import qupath.bioimageio.spec.tensor.BaseTensor;
import qupath.bioimageio.spec.tensor.sizes.Size;

public class Shape {
    protected int[] shape;

    public static int[] createShapeArray(String axes, Map<Character, Integer> target, int defaultLength) {
        int[] array = new int[axes.length()];
        int i = 0;
        for (char c : axes.toLowerCase().toCharArray()) {
            array[i] = target.getOrDefault(Character.valueOf(c), defaultLength);
            ++i;
        }
        return array;
    }

    public int[] getShape() {
        return this.shape == null ? new int[]{} : (int[])this.shape.clone();
    }

    public int[] getShapeMin() {
        return this.getShape();
    }

    public int[] getTargetShape(int ... target) {
        return this.getShape();
    }

    public int getLength() {
        return this.shape == null ? 0 : this.shape.length;
    }

    public int[] getShapeStep() {
        return this.shape == null ? new int[]{} : new int[this.shape.length];
    }

    public double[] getScale() {
        if (this.shape == null) {
            return new double[0];
        }
        double[] scale = new double[this.shape.length];
        Arrays.fill(scale, 1.0);
        return scale;
    }

    public double[] getOffset() {
        return this.shape == null ? new double[]{} : new double[this.shape.length];
    }

    public String toString() {
        if (this.shape == null) {
            return "Shape (unknown)";
        }
        return "Shape (" + Arrays.toString(this.shape) + ")";
    }

    void validate(List<? extends BaseTensor> tensors) {
    }

    static class Deserializer
    implements JsonDeserializer<Shape> {
        Deserializer() {
        }

        public Shape deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonArray()) {
                Shape shape = new Shape();
                shape.shape = (int[])context.deserialize(json, int[].class);
                return shape;
            }
            JsonObject obj = json.getAsJsonObject();
            if (obj.has("min") && obj.has("step")) {
                return (Shape)context.deserialize((JsonElement)obj, ParameterizedInputShape.class);
            }
            if (obj.has("offset") && obj.has("scale")) {
                return (Shape)context.deserialize((JsonElement)obj, ImplicitOutputShape.class);
            }
            throw new JsonParseException("Can't deserialize unknown shape: " + String.valueOf(json));
        }
    }

    public static class SizesShape
    extends Shape {
        private final List<Size> sizes;

        SizesShape(List<Size> sizes) {
            this.sizes = sizes;
            this.shape = this.sizes.stream().mapToInt(Size::size).toArray();
        }

        @Override
        public int[] getShape() {
            return this.sizes.stream().mapToInt(Size::size).toArray();
        }

        @Override
        public int[] getTargetShape(int[] target) {
            assert (target.length == this.sizes.size());
            return IntStream.range(0, target.length).map(i -> this.sizes.get(i).getTargetSize(target[i])).toArray();
        }

        @Override
        public int[] getShapeMin() {
            return this.sizes.stream().mapToInt(s -> s == null ? 0 : s.getMin()).toArray();
        }

        @Override
        public int[] getShapeStep() {
            return this.sizes.stream().mapToInt(Size::getStep).toArray();
        }
    }

    public static class ImplicitOutputShape
    extends Shape {
        private String referenceTensor;
        private double[] offset;
        private double[] scale;

        public String getReferenceTensor() {
            return this.referenceTensor;
        }

        @Override
        public double[] getScale() {
            if (this.scale == null) {
                return super.getScale();
            }
            return (double[])this.scale.clone();
        }

        @Override
        public double[] getOffset() {
            if (this.offset == null) {
                return super.getOffset();
            }
            return (double[])this.offset.clone();
        }

        @Override
        public int[] getTargetShape(int ... target) {
            if (this.offset == null || this.offset.length == 0 || this.scale == null || this.scale.length == 0) {
                return super.getTargetShape(target);
            }
            int n = target.length;
            int[] output = new int[n];
            for (int i = 0; i < n; ++i) {
                output[i] = (int)Math.round((double)target[i] * this.scale[i] + this.offset[i] * 2.0);
            }
            return output;
        }

        @Override
        public String toString() {
            if (this.shape != null) {
                return "Output Shape (" + Arrays.toString(this.shape) + ")";
            }
            if (this.scale != null) {
                if (this.offset != null) {
                    return "Output Shape (scale=" + Arrays.toString(this.scale) + ", offset=" + Arrays.toString(this.offset) + ")";
                }
                return "Output Shape (scale=" + Arrays.toString(this.scale) + ")";
            }
            return "Output shape (unknown)";
        }
    }

    public static class ParameterizedInputShape
    extends Shape {
        private int[] min;
        private int[] step;

        @Override
        public int[] getShapeMin() {
            return this.min == null ? super.getShapeMin() : (int[])this.min.clone();
        }

        @Override
        public int[] getShapeStep() {
            return this.min == null ? super.getShapeStep() : (int[])this.step.clone();
        }

        @Override
        public int[] getTargetShape(int ... target) {
            if (this.min == null || this.min.length == 0) {
                return super.getTargetShape(target);
            }
            if (this.min.length != target.length) {
                throw new IllegalArgumentException("Target shape does not match! Should be length " + this.min.length + " but found length " + target.length);
            }
            int n = target.length;
            int[] output = new int[n];
            for (int i = 0; i < n; ++i) {
                output[i] = target[i] < 0 || this.step == null || this.step[i] <= 0 ? this.min[i] : this.min[i] + (int)Math.round((double)(target[i] - this.min[i]) / (double)this.step[i]) * this.step[i];
            }
            return output;
        }

        @Override
        public String toString() {
            if (this.shape != null) {
                return "Input Shape (" + Arrays.toString(this.shape) + ")";
            }
            if (this.min != null) {
                if (this.step != null) {
                    return "Input Shape (min=" + Arrays.toString(this.min) + ", step=" + Arrays.toString(this.step) + ")";
                }
                return "Input Shape (min=" + Arrays.toString(this.min) + ")";
            }
            return "Input shape (unknown)";
        }
    }
}

