/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.Model;
import qupath.bioimageio.spec.tensor.axes.Axis;

public class Processing {
    private final String name;
    private Map<String, Object> kwargs;

    Processing(String name) {
        this.name = name;
    }

    public static Map<Class<?>, JsonDeserializer<?>> getDeserializers() {
        HashMap map = new HashMap();
        map.put(Processing.class, new ProcessingDeserializer());
        map.put(ProcessingMode.class, new ProcessingModeDeserializer());
        return map;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, ?> getKwargs() {
        return this.kwargs == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.kwargs);
    }

    static class ProcessingDeserializer
    implements JsonDeserializer<Processing> {
        ProcessingDeserializer() {
        }

        public Processing deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject obj = json.getAsJsonObject();
            String name = obj.has("name") ? obj.get("name").getAsString() : obj.get("id").getAsString();
            JsonObject kwargs = Model.deserializeField(context, obj, "kwargs", JsonObject.class, null);
            return switch (name) {
                case "binarize" -> {
                    Binarize binarize = new Binarize();
                    binarize.threshold = (Double)Model.deserializeField(context, kwargs, "threshold", Double.class, true);
                    yield binarize;
                }
                case "clip" -> {
                    Clip clip = new Clip();
                    clip.min = Model.deserializeField(context, kwargs, "min", Double.class, Double.NEGATIVE_INFINITY);
                    clip.max = Model.deserializeField(context, kwargs, "max", Double.class, Double.POSITIVE_INFINITY);
                    yield clip;
                }
                case "scale_linear" -> {
                    ScaleLinear scaleLinear = new ScaleLinear();
                    scaleLinear.axes = (Axis[])Model.deserializeField(context, kwargs, "axes", Axis[].class, false);
                    scaleLinear.gain = (double[])Model.deserializeField(context, kwargs, "gain", double[].class, false);
                    scaleLinear.offset = (double[])Model.deserializeField(context, kwargs, "offset", double[].class, false);
                    yield scaleLinear;
                }
                case "scale_mean_variance" -> {
                    ScaleMeanVariance scaleMeanVariance = new ScaleMeanVariance();
                    scaleMeanVariance.mode = (ProcessingMode)Model.deserializeField(context, kwargs, "mode", ProcessingMode.class, false);
                    scaleMeanVariance.axes = (Axis[])Model.deserializeField(context, kwargs, "axes", Axis[].class, false);
                    scaleMeanVariance.eps = Model.deserializeField(context, kwargs, "eps", Double.class, 1.0E-6);
                    scaleMeanVariance.referenceTensor = Model.deserializeField(context, kwargs, "reference_tensor", String.class, null);
                    yield scaleMeanVariance;
                }
                case "scale_range" -> {
                    ScaleRange scaleRange = new ScaleRange();
                    scaleRange.mode = (ProcessingMode)Model.deserializeField(context, kwargs, "mode", ProcessingMode.class, false);
                    scaleRange.axes = (Axis[])Model.deserializeField(context, kwargs, "axes", Axis[].class, false);
                    scaleRange.eps = Model.deserializeField(context, kwargs, "eps", Double.class, 1.0E-6);
                    scaleRange.referenceTensor = Model.deserializeField(context, obj, "reference_tensor", String.class, null);
                    scaleRange.maxPercentile = Model.deserializeField(context, kwargs, "max_percentile", Double.class, 0.0);
                    scaleRange.minPercentile = Model.deserializeField(context, kwargs, "min_percentile", Double.class, 100.0);
                    yield scaleRange;
                }
                case "sigmoid" -> new Sigmoid();
                case "zero_mean_unit_variance" -> {
                    ZeroMeanUnitVariance zeroMeanUnitVariance = new ZeroMeanUnitVariance();
                    zeroMeanUnitVariance.mode = (ProcessingMode)Model.deserializeField(context, kwargs, "mode", ProcessingMode.class, false);
                    zeroMeanUnitVariance.axes = (Axis[])Model.deserializeField(context, kwargs, "axes", Axis[].class, false);
                    zeroMeanUnitVariance.eps = Model.deserializeField(context, kwargs, "eps", Double.class, 1.0E-6);
                    zeroMeanUnitVariance.mean = (double[])Model.deserializeField(context, kwargs, "mean", double[].class, false);
                    zeroMeanUnitVariance.std = (double[])Model.deserializeField(context, kwargs, "std", double[].class, false);
                    yield zeroMeanUnitVariance;
                }
                default -> {
                    Processing processing = new Processing(name);
                    processing.kwargs = kwargs == null ? Collections.emptyMap() : (Map)context.deserialize((JsonElement)kwargs, Map.class);
                    yield processing;
                }
            };
        }
    }

    public static enum ProcessingMode {
        FIXED,
        PER_DATASET,
        PER_SAMPLE;

    }

    static class ProcessingModeDeserializer
    implements JsonDeserializer<ProcessingMode> {
        private static final Logger logger = LoggerFactory.getLogger(Processing.class);

        ProcessingModeDeserializer() {
        }

        public ProcessingMode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            String s = json.getAsString();
            for (ProcessingMode mode : ProcessingMode.values()) {
                if (!s.equals(mode.name())) continue;
                return mode;
            }
            for (ProcessingMode mode : ProcessingMode.values()) {
                if (!s.equalsIgnoreCase(mode.name())) continue;
                return mode;
            }
            logger.warn("Unknown processing mode: {}", (Object)s);
            return null;
        }
    }

    public static class ZeroMeanUnitVariance
    extends ProcessingWithMode {
        double[] mean;
        double[] std;

        ZeroMeanUnitVariance() {
            super("zero_mean_unit_variance");
        }

        public double[] getMean() {
            return this.mean == null ? null : (double[])this.mean.clone();
        }

        public double[] getStd() {
            return this.std == null ? null : (double[])this.std.clone();
        }
    }

    public static class ScaleRange
    extends ProcessingWithMode {
        String referenceTensor;
        double minPercentile = 0.0;
        double maxPercentile = 100.0;

        ScaleRange() {
            super("scale_range");
        }

        public double getMinPercentile() {
            return this.minPercentile;
        }

        public double getMaxPercentile() {
            return this.maxPercentile;
        }

        public String getReferenceTensor() {
            return this.referenceTensor;
        }
    }

    public static class ScaleMeanVariance
    extends ProcessingWithMode {
        String referenceTensor;

        ScaleMeanVariance() {
            super("scale_mean_variance");
        }

        public String getReferenceTensor() {
            return this.referenceTensor;
        }
    }

    protected static abstract class ProcessingWithMode
    extends Processing {
        ProcessingMode mode = ProcessingMode.PER_SAMPLE;
        Axis[] axes;
        double eps = 1.0E-6;

        ProcessingWithMode(String name) {
            super(name);
        }

        public double getEps() {
            return this.eps;
        }

        public ProcessingMode getMode() {
            return this.mode;
        }

        public Axis[] getAxes() {
            return (Axis[])this.axes.clone();
        }
    }

    public static class Sigmoid
    extends Processing {
        Sigmoid() {
            super("sigmoid");
        }
    }

    public static class ScaleLinear
    extends Processing {
        double[] gain;
        double[] offset;
        Axis[] axes;

        ScaleLinear() {
            super("scale_linear");
        }

        public double[] getGain() {
            return this.gain == null ? null : (double[])this.gain.clone();
        }

        public double[] getOffset() {
            return this.offset == null ? null : (double[])this.offset.clone();
        }

        public Axis[] getAxes() {
            return this.axes == null ? null : (Axis[])this.axes.clone();
        }
    }

    public static class Clip
    extends Processing {
        double min;
        double max;

        Clip() {
            super("clip");
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }
    }

    public static class Binarize
    extends Processing {
        double threshold = Double.NaN;

        Binarize() {
            super("binarize");
        }

        public double getThreshold() {
            return this.threshold;
        }
    }
}

