/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec.tensor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import qupath.bioimageio.spec.FileDescription;
import qupath.bioimageio.spec.tensor.Shape;
import qupath.bioimageio.spec.tensor.TensorDataDescription;
import qupath.bioimageio.spec.tensor.axes.Axis;

public abstract class BaseTensor {
    protected Axis[] axes;
    private String dataType;
    private FileDescription testTensor;
    private FileDescription sampleTensor;
    private String name;
    private String id;
    private Shape shape;
    private TensorDataDescription data;
    private double[] dataRange;

    public Axis[] getAxes() {
        return (Axis[])this.axes.clone();
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getName() {
        return this.name != null ? this.name : this.id;
    }

    public String getId() {
        return this.id;
    }

    public Shape getShape() {
        return this.shape != null ? this.shape : new Shape.SizesShape(Arrays.stream(this.axes).map(Axis::getSize).collect(Collectors.toList()));
    }

    public double[] getDataRange() {
        return this.dataRange == null ? null : (double[])this.dataRange.clone();
    }

    public void validate(List<? extends BaseTensor> otherTensors) {
        if (this.shape != null) {
            this.shape.validate(otherTensors);
        }
        for (Axis axis : this.getAxes()) {
            axis.validate(otherTensors);
        }
    }

    public Optional<FileDescription> getTestTensor() {
        return Optional.ofNullable(this.testTensor);
    }

    public Optional<FileDescription> getSampleTensor() {
        return Optional.ofNullable(this.sampleTensor);
    }

    public TensorDataDescription getDataDescription() {
        return this.data;
    }
}

