/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.Author;
import qupath.bioimageio.spec.Model;

public class Weights {

    static class WeightsMapDeserializer
    implements JsonDeserializer<WeightsMap> {
        private static final Logger logger = LoggerFactory.getLogger(Weights.class);

        WeightsMapDeserializer() {
        }

        public WeightsMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            WeightsMap weights = new WeightsMap();
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                LinkedHashMap<WeightsEntry, ModelWeights> map = new LinkedHashMap<WeightsEntry, ModelWeights>();
                for (String key : json.getAsJsonObject().keySet()) {
                    WeightsEntry we = WeightsEntry.fromKey(key);
                    if (we == null) {
                        logger.warn("Unsupported weights: {}", (Object)key);
                        continue;
                    }
                    map.put(we, (ModelWeights)context.deserialize(obj.get(key), ModelWeights.class));
                }
                weights.map = Collections.unmodifiableMap(map);
            }
            return weights;
        }
    }

    static class WeightsEntryDeserializer
    implements JsonDeserializer<WeightsEntry> {
        WeightsEntryDeserializer() {
        }

        public WeightsEntry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return WeightsEntry.fromKey(json.toString());
        }
    }

    public static class WeightsMap {
        private Map<WeightsEntry, ModelWeights> map;

        public Map<String, ModelWeights> withStringKeys() {
            return this.map == null ? Collections.emptyMap() : this.map.entrySet().stream().collect(Collectors.toMap(e -> ((WeightsEntry)((Object)((Object)e.getKey()))).toString(), e -> (ModelWeights)e.getValue()));
        }

        Map<WeightsEntry, ModelWeights> getMap() {
            return this.map;
        }
    }

    public static enum WeightsEntry {
        KERAS_HDF5("keras_hdf5"),
        PYTORCH_STATE_DICT("pytorch_state_dict"),
        TENSORFLOW_JS("tensorflow_js"),
        TENSORFLOW_SAVED_MODEL_BUNDLE("tensorflow_saved_model_bundle"),
        ONNX("onnx"),
        TORCHSCRIPT("torchscript", Set.of("pytorch_script"));

        private final String key;
        private final Set<String> alternatives;

        private WeightsEntry(String key) {
            this(key, Collections.emptySet());
        }

        private WeightsEntry(String key, Set<String> alternatives) {
            this.key = key;
            this.alternatives = Collections.unmodifiableSet(alternatives);
        }

        public String toString() {
            return this.key;
        }

        static WeightsEntry fromKey(String name) {
            for (WeightsEntry v : WeightsEntry.values()) {
                if (!v.key.equals(name) && !v.alternatives.contains(name)) continue;
                return v;
            }
            return null;
        }
    }

    public static class ModelWeights {
        private String source;
        private Map<String, ?> attachments;
        private List<Author> authors;
        private String parent;
        private String sha256;

        public String getSource() {
            return this.source;
        }

        public Map<String, ?> getAttachments() {
            return this.attachments == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attachments);
        }

        public String getParent() {
            return this.parent;
        }

        public String getSha256() {
            return this.sha256;
        }

        public List<Author> getAuthors() {
            return Model.toUnmodifiableList(this.authors);
        }

        public String toString() {
            return "Weights: " + this.source;
        }
    }
}

