/*
 * Decompiled with CFR 0.152.
 */
package qupath.bioimageio.spec;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.module.ModuleDescriptor;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.bioimageio.spec.Author;
import qupath.bioimageio.spec.Badge;
import qupath.bioimageio.spec.CiteEntry;
import qupath.bioimageio.spec.Dataset;
import qupath.bioimageio.spec.Model;

public class Resource {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    private String formatVersion;
    private List<Author> authors;
    private String description;
    private String documentation;
    private String name;
    private List<String> tags;
    private Dataset trainingData;
    private String version;
    private Map<String, ?> attachments;
    private List<Badge> badges;
    private List<CiteEntry> cite;
    private List<String> covers;
    private String downloadURL;
    private String gitRepo;
    private String icon;
    private String id;
    private String license;
    private List<String> links;
    private List<Author> maintainers;
    private String source;
    private String rdfSource;

    public String getVersion() {
        return this.version;
    }

    public List<Badge> getBadges() {
        return Model.toUnmodifiableList(this.badges);
    }

    public List<CiteEntry> getCite() {
        return Model.toUnmodifiableList(this.cite);
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getGitRepo() {
        return this.gitRepo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public String getLicense() {
        return this.license;
    }

    public String getSource() {
        return this.source;
    }

    public String getID() {
        return this.id;
    }

    public List<Author> getAuthors() {
        return Model.toUnmodifiableList(this.authors);
    }

    public List<Author> getMaintainers() {
        return Model.toUnmodifiableList(this.maintainers);
    }

    public List<String> getLinks() {
        return Model.toUnmodifiableList(this.links);
    }

    public List<String> getTags() {
        return Model.toUnmodifiableList(this.tags);
    }

    public List<String> getCovers() {
        return Model.toUnmodifiableList(this.covers);
    }

    public Map<String, ?> getAttachments() {
        return this.attachments == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.attachments);
    }

    boolean isFormatNewerThan(ModuleDescriptor.Version version) {
        return ModuleDescriptor.Version.parse(this.getFormatVersion()).compareTo(version) > 0;
    }

    public boolean isFormatNewerThan(String version) {
        return this.isFormatNewerThan(ModuleDescriptor.Version.parse(version));
    }

    static void deserializeResourceFields(Resource resource, JsonObject obj, JsonDeserializationContext context, boolean doStrict) {
        resource.formatVersion = (String)Model.deserializeField(context, obj, "format_version", String.class, doStrict);
        resource.authors = (List)Model.deserializeField(context, obj, "authors", Model.parameterizedListType(Author.class), doStrict);
        resource.description = (String)Model.deserializeField(context, obj, "description", String.class, doStrict);
        resource.documentation = (String)Model.deserializeField(context, obj, "documentation", String.class, doStrict);
        resource.license = (String)Model.deserializeField(context, obj, "license", String.class, doStrict);
        resource.name = (String)Model.deserializeField(context, obj, "name", String.class, doStrict);
        if (obj.has("attachments")) {
            if (obj.get("attachments").isJsonObject()) {
                resource.attachments = Model.deserializeField(context, obj, "attachments", Map.class, Collections.emptyMap());
            } else {
                logger.warn("Can't parse attachments (not a dict)");
            }
        }
        resource.badges = Model.deserializeField(context, obj, "badges", Model.parameterizedListType(Badge.class), Collections.emptyList());
        resource.cite = Model.deserializeField(context, obj, "cite", Model.parameterizedListType(CiteEntry.class), Collections.emptyList());
        resource.covers = Model.deserializeField(context, obj, "covers", Model.parameterizedListType(String.class), Collections.emptyList());
        resource.downloadURL = Model.deserializeField(context, obj, "download_url", String.class, null);
        resource.gitRepo = Model.deserializeField(context, obj, "git_repo", String.class, null);
        resource.icon = Model.deserializeField(context, obj, "icon", String.class, null);
        resource.id = Model.deserializeField(context, obj, "id", String.class, null);
        resource.links = Model.deserializeField(context, obj, "links", Model.parameterizedListType(String.class), Collections.emptyList());
        resource.maintainers = Model.deserializeField(context, obj, "maintainers", Model.parameterizedListType(Author.class), Collections.emptyList());
        resource.rdfSource = Model.deserializeField(context, obj, "rdf_source", String.class, null);
        resource.tags = Model.deserializeField(context, obj, "tags", Model.parameterizedListType(String.class), Collections.emptyList());
        resource.trainingData = Model.deserializeField(context, obj, "training_data", Dataset.class, null);
        resource.version = Model.deserializeField(context, obj, "version", String.class, null);
    }

    static class Deserializer
    implements JsonDeserializer<Resource> {
        Deserializer() {
        }

        public Resource deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            if (json.isJsonNull()) {
                return null;
            }
            JsonObject obj = json.getAsJsonObject();
            Resource resource = new Resource();
            Resource.deserializeResourceFields(resource, obj, context, true);
            return resource;
        }
    }
}

