/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.menu;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;
import jfxtras.scene.layout.CircularPane;

public class CornerMenu {
    private Pane pane = null;
    private final SimpleObjectProperty<Location> locationObjectProperty = new SimpleObjectProperty((Object)this, "location", (Object)Location.TOP_LEFT);
    private final ObservableList<MenuItem> items = FXCollections.observableArrayList();
    private final SimpleBooleanProperty autoShowAndHideObjectProperty = new SimpleBooleanProperty((Object)this, "autoShowAndHide", true);
    private ReadOnlyBooleanWrapper shown = new ReadOnlyBooleanWrapper((Object)this, "shown");
    private final ObjectProperty<Duration> animationDurationObjectProperty = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)500.0));
    private final ObjectProperty<CircularPane.AnimationInterpolation> animationInterpolationObjectProperty = new SimpleObjectProperty((Object)this, "animationInterpolation", CircularPane::animateFromTheOrigin);
    private final CircularPane circularPane = new CircularPane();
    private final AtomicLong menuNodeIdAtomicLong = new AtomicLong();

    public CornerMenu(Location location, Pane pane, boolean shown) {
        this.locationObjectProperty.set((Object)location);
        this.construct(pane, shown);
    }

    private void construct(Pane pane, boolean shown) {
        this.pane = pane;
        this.getItems().addListener(change -> {
            while (change.next()) {
                for (MenuItem lMenuItem : change.getRemoved()) {
                    for (Node lNode : new ArrayList(this.circularPane.getChildren())) {
                        if (!(lNode instanceof CornerMenuNode)) continue;
                        CornerMenuNode lCornerMenuNode = (CornerMenuNode)lNode;
                        if (lCornerMenuNode.menuItem != lMenuItem) continue;
                        this.circularPane.remove((Node)lCornerMenuNode);
                    }
                }
                for (MenuItem lMenuItem : change.getAddedSubList()) {
                    this.circularPane.add((Node)new CornerMenuNode(lMenuItem));
                }
            }
            this.circularPane.resize(this.circularPane.prefWidth(-1.0), this.circularPane.prefHeight(-1.0));
        });
        pane.addEventHandler(MouseEvent.MOUSE_MOVED, mouseEvent -> {
            if (this.isAutoShowAndHide().booleanValue()) {
                this.autoShowOrHide((MouseEvent)mouseEvent);
            }
        });
        this.setupCircularPane();
        pane.getChildren().add((Object)this.circularPane);
        this.circularPane.setManaged(false);
        this.circularPane.setVisible(shown);
        this.setShown(shown);
    }

    public ReadOnlyObjectProperty<Location> locationProperty() {
        return new ReadOnlyObjectWrapper((Object)this, "location").getReadOnlyProperty();
    }

    public Location getLocation() {
        return (Location)((Object)this.locationObjectProperty.getValue());
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public BooleanProperty autoShowAndHideProperty() {
        return this.autoShowAndHideObjectProperty;
    }

    public Boolean isAutoShowAndHide() {
        return this.autoShowAndHideObjectProperty.getValue();
    }

    public void setAutoShowAndHide(Boolean value) {
        this.autoShowAndHideObjectProperty.setValue(value);
    }

    public CornerMenu withAutoShowAndHide(Boolean value) {
        this.setAutoShowAndHide(value);
        return this;
    }

    public final ReadOnlyBooleanProperty shownProperty() {
        return this.shown.getReadOnlyProperty();
    }

    private void setShown(boolean value) {
        this.shown.set(value);
    }

    public final boolean isShown() {
        return this.shownProperty().get();
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDurationObjectProperty;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDurationObjectProperty.getValue();
    }

    public void setAnimationDuration(Duration value) {
        this.animationDurationObjectProperty.setValue((Object)value);
    }

    public CornerMenu withAnimationDuration(Duration value) {
        this.setAnimationDuration(value);
        return this;
    }

    public ObjectProperty<CircularPane.AnimationInterpolation> animationInterpolationProperty() {
        return this.animationInterpolationObjectProperty;
    }

    public CircularPane.AnimationInterpolation getAnimationInterpolation() {
        return (CircularPane.AnimationInterpolation)this.animationInterpolationObjectProperty.getValue();
    }

    public void setAnimationInterpolation(CircularPane.AnimationInterpolation value) {
        this.animationInterpolationObjectProperty.setValue((Object)value);
    }

    public CornerMenu withAnimationInterpolation(CircularPane.AnimationInterpolation value) {
        this.setAnimationInterpolation(value);
        return this;
    }

    public void show() {
        this.setShown(true);
        this.circularPane.setVisible(true);
        this.circularPane.animateIn();
    }

    public void hide() {
        this.setShown(false);
        this.circularPane.animateOut();
        if (this.circularPane.getAnimationInterpolation() == null) {
            this.circularPane.getOnAnimateOutFinished().handle(null);
        }
    }

    public void removeFromPane() {
        this.pane.getChildren().remove((Object)this.circularPane);
    }

    private void setupCircularPane() {
        this.circularPane.animationDurationProperty().bind(this.animationDurationObjectProperty);
        this.circularPane.animationInterpolationProperty().bind(this.animationInterpolationObjectProperty);
        if (Location.TOP_LEFT.equals((Object)this.getLocation())) {
            this.circularPane.setStartAngle(Double.valueOf(90.0));
        } else if (Location.TOP_RIGHT.equals((Object)this.getLocation())) {
            this.circularPane.setStartAngle(Double.valueOf(180.0));
        } else if (Location.BOTTOM_RIGHT.equals((Object)this.getLocation())) {
            this.circularPane.setStartAngle(Double.valueOf(270.0));
        } else if (Location.BOTTOM_LEFT.equals((Object)this.getLocation())) {
            this.circularPane.setStartAngle(Double.valueOf(0.0));
        }
        this.circularPane.setArc(Double.valueOf(90.0));
        if (Location.TOP_LEFT.equals((Object)this.getLocation())) {
            this.circularPane.setLayoutX(0.0);
            this.circularPane.setLayoutY(0.0);
        } else if (Location.TOP_RIGHT.equals((Object)this.getLocation())) {
            this.circularPane.layoutXProperty().bind((ObservableValue)this.pane.widthProperty().subtract((ObservableNumberValue)this.circularPane.widthProperty()));
            this.circularPane.setLayoutY(0.0);
        } else if (Location.BOTTOM_RIGHT.equals((Object)this.getLocation())) {
            this.circularPane.layoutXProperty().bind((ObservableValue)this.pane.widthProperty().subtract((ObservableNumberValue)this.circularPane.widthProperty()));
            this.circularPane.layoutYProperty().bind((ObservableValue)this.pane.heightProperty().subtract((ObservableNumberValue)this.circularPane.heightProperty()));
        } else if (Location.BOTTOM_LEFT.equals((Object)this.getLocation())) {
            this.circularPane.setLayoutX(0.0);
            this.circularPane.layoutYProperty().bind((ObservableValue)this.pane.heightProperty().subtract((ObservableNumberValue)this.circularPane.heightProperty()));
        }
        this.circularPane.setOnAnimateOutFinished(actionEvent -> this.circularPane.setVisible(false));
    }

    private void autoShowOrHide(MouseEvent mouseEvent) {
        double lX = 0.0;
        double lY = 0.0;
        if (Location.TOP_LEFT.equals((Object)this.getLocation())) {
            lX = mouseEvent.getX();
            lY = mouseEvent.getY();
        } else if (Location.TOP_RIGHT.equals((Object)this.getLocation())) {
            lX = this.pane.getWidth() - mouseEvent.getX();
            lY = mouseEvent.getY();
        } else if (Location.BOTTOM_RIGHT.equals((Object)this.getLocation())) {
            lX = this.pane.getWidth() - mouseEvent.getX();
            lY = this.pane.getHeight() - mouseEvent.getY();
        } else if (Location.BOTTOM_LEFT.equals((Object)this.getLocation())) {
            lX = mouseEvent.getX();
            lY = this.pane.getHeight() - mouseEvent.getY();
        }
        lX = lX < 0.0 ? 0.0 : lX;
        lY = lY < 0.0 ? 0.0 : lY;
        double lDistanceFromOrigin = Math.sqrt(lX * lX + lY * lY);
        if (lDistanceFromOrigin < 10.0 && !this.circularPane.isVisible() && !this.circularPane.isAnimatingIn()) {
            this.show();
        }
        if (lDistanceFromOrigin > this.circularPane.getWidth() && this.circularPane.isVisible() && !this.circularPane.isAnimatingOut()) {
            this.hide();
        }
    }

    public static enum Location {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_RIGHT,
        BOTTOM_LEFT;

    }

    private class CornerMenuNode
    extends Pane {
        private final MenuItem menuItem;

        CornerMenuNode(MenuItem menuItem) {
            this.menuItem = menuItem;
            this.setId(((Object)((Object)this)).getClass().getSimpleName() + "#" + CornerMenu.this.menuNodeIdAtomicLong.incrementAndGet());
            if (menuItem.getGraphic() == null) {
                throw new NullPointerException("MenuItems in CornerMenu require a graphical part, text is optional");
            }
            this.getChildren().add((Object)menuItem.getGraphic());
            if (menuItem.getText() != null && menuItem.getText().length() > 0) {
                Tooltip t = new Tooltip(menuItem.getText());
                Tooltip.install((Node)this, (Tooltip)t);
            }
            this.setOnMouseClicked(eventHandler -> {
                if (CornerMenu.this.isAutoShowAndHide().booleanValue()) {
                    CornerMenu.this.hide();
                }
                if (menuItem.getOnAction() != null) {
                    menuItem.getOnAction().handle(null);
                }
            });
        }
    }
}

