/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.menu;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Popup;
import javafx.util.Duration;
import jfxtras.scene.layout.CircularPane;

public class CirclePopupMenu {
    private Node node = null;
    private Popup popup = new Popup();
    private CircularPane circularPane = new CircularPane();
    private final ObservableList<MenuItem> items = FXCollections.observableArrayList();
    private ReadOnlyBooleanWrapper shown = new ReadOnlyBooleanWrapper((Object)this, "shown");
    private final ObjectProperty<Duration> animationDurationObjectProperty = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)500.0));
    private final ObjectProperty<CircularPane.AnimationInterpolation> animationInterpolationObjectProperty = new SimpleObjectProperty((Object)this, "animationInterpolation", CircularPane::animateFromTheOrigin);
    private final AtomicLong menuNodeIdAtomicLong = new AtomicLong();

    public CirclePopupMenu(Node node, MouseButton mouseButton) {
        this.construct(node, mouseButton);
    }

    private void construct(Node node, MouseButton mouseButton) {
        this.node = node;
        this.popup.setHideOnEscape(true);
        this.popup.setOnHiding(windowEvent -> this.hide());
        this.popup.getContent().add((Object)this.circularPane);
        this.circularPane.animationDurationProperty().bind(this.animationDurationObjectProperty);
        this.circularPane.animationInterpolationProperty().bind(this.animationInterpolationObjectProperty);
        this.circularPane.setPickOnBounds(false);
        EventHandler mouseMovedOutsideCircularPaneEventHandler = mouseEvent -> {
            Bounds screenBounds;
            if (this.isShown() && !(screenBounds = this.circularPane.localToScreen(this.circularPane.getBoundsInLocal())).contains(mouseEvent.getScreenX(), mouseEvent.getScreenY())) {
                this.hide();
            }
        };
        node.sceneProperty().addListener((observable, oldScene, newScene) -> {
            if (oldScene != null) {
                oldScene.getRoot().removeEventHandler(MouseEvent.MOUSE_MOVED, mouseMovedOutsideCircularPaneEventHandler);
            }
            if (newScene != null) {
                newScene.getRoot().addEventHandler(MouseEvent.MOUSE_MOVED, mouseMovedOutsideCircularPaneEventHandler);
            }
        });
        this.circularPane.setOnAnimateOutFinished(actionEvent -> this.popup.hide());
        node.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            if (mouseButton != null && mouseButton.equals((Object)mouseEvent.getButton())) {
                if (this.isShown()) {
                    this.hide();
                } else {
                    this.show((MouseEvent)mouseEvent);
                }
            }
        });
        this.getItems().addListener(change -> {
            while (change.next()) {
                for (MenuItem lMenuItem : change.getRemoved()) {
                    for (Node lNode : new ArrayList(this.circularPane.getChildren())) {
                        if (!(lNode instanceof CirclePopupMenuNode)) continue;
                        CirclePopupMenuNode lCirclePopupMenuNode = (CirclePopupMenuNode)lNode;
                        if (lCirclePopupMenuNode.menuItem != lMenuItem) continue;
                        this.circularPane.remove((Node)lCirclePopupMenuNode);
                    }
                }
                for (MenuItem lMenuItem : change.getAddedSubList()) {
                    this.circularPane.add((Node)new CirclePopupMenuNode(lMenuItem));
                }
            }
        });
        this.setShown(false);
    }

    public final ObservableList<MenuItem> getItems() {
        return this.items;
    }

    public final ReadOnlyBooleanProperty shownProperty() {
        return this.shown.getReadOnlyProperty();
    }

    private void setShown(boolean value) {
        this.shown.set(value);
    }

    public final boolean isShown() {
        return this.shownProperty().get();
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDurationObjectProperty;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDurationObjectProperty.getValue();
    }

    public void setAnimationDuration(Duration value) {
        this.animationDurationObjectProperty.setValue((Object)value);
    }

    public CirclePopupMenu withAnimationDuration(Duration value) {
        this.setAnimationDuration(value);
        return this;
    }

    public ObjectProperty<CircularPane.AnimationInterpolation> animationInterpolationProperty() {
        return this.animationInterpolationObjectProperty;
    }

    public CircularPane.AnimationInterpolation getAnimationInterpolation() {
        return (CircularPane.AnimationInterpolation)this.animationInterpolationObjectProperty.getValue();
    }

    public void setAnimationInterpolation(CircularPane.AnimationInterpolation value) {
        this.animationInterpolationObjectProperty.setValue((Object)value);
    }

    public CirclePopupMenu withAnimationInterpolation(CircularPane.AnimationInterpolation value) {
        this.setAnimationInterpolation(value);
        return this;
    }

    public void show(MouseEvent mouseEvent) {
        this.show(mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    public void show(double x, double y) {
        this.popup.show(this.node, x - this.circularPane.prefWidth(-1.0) / 2.0, y - this.circularPane.prefHeight(-1.0) / 2.0);
        this.circularPane.animateIn();
        this.setShown(true);
    }

    public void hide() {
        this.setShown(false);
        this.circularPane.animateOut();
        if (this.circularPane.getAnimationInterpolation() == null) {
            this.circularPane.getOnAnimateOutFinished().handle(null);
        }
    }

    private class CirclePopupMenuNode
    extends Pane {
        private final MenuItem menuItem;

        CirclePopupMenuNode(MenuItem menuItem) {
            this.menuItem = menuItem;
            this.setId(((Object)((Object)this)).getClass().getSimpleName() + "#" + CirclePopupMenu.this.menuNodeIdAtomicLong.incrementAndGet());
            if (menuItem.getGraphic() == null) {
                throw new NullPointerException("MenuItems in CirclePopupMenu require a graphical part, text is optional");
            }
            this.getChildren().add((Object)menuItem.getGraphic());
            if (menuItem.getText() != null && menuItem.getText().length() > 0) {
                Tooltip t = new Tooltip(menuItem.getText());
                Tooltip.install((Node)this, (Tooltip)t);
            }
            this.setOnMouseClicked(eventHandler -> {
                CirclePopupMenu.this.hide();
                if (menuItem.getOnAction() != null) {
                    menuItem.getOnAction().handle(null);
                }
            });
        }
    }
}

