/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi.interfaces;

import java.awt.Shape;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import qupath.lib.geom.Point2;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;

public interface ROI {
    public String getRoiName();

    public int getC();

    public int getT();

    public int getZ();

    public ImagePlane getImagePlane();

    public double getCentroidX();

    public double getCentroidY();

    public double getBoundsX();

    public double getBoundsY();

    public double getBoundsWidth();

    public double getBoundsHeight();

    public List<Point2> getAllPoints();

    public int getNumPoints();

    public boolean isEmpty();

    @Deprecated
    public ROI duplicate();

    public Shape getShape();

    public Geometry getGeometry();

    public RoiType getRoiType();

    public boolean isLine();

    public boolean isArea();

    public boolean isPoint();

    public ROI translate(double var1, double var3);

    public ROI scale(double var1, double var3, double var5, double var7);

    default public ROI scale(double scaleX, double scaleY) {
        return this.scale(scaleX, scaleY, 0.0, 0.0);
    }

    public double getArea();

    public double getScaledArea(double var1, double var3);

    default public double getScaledArea(PixelCalibration cal) {
        return this.getScaledArea(cal.getPixelWidth().doubleValue(), cal.getPixelHeight().doubleValue());
    }

    public double getLength();

    public double getScaledLength(double var1, double var3);

    default public double getScaledLength(PixelCalibration cal) {
        return this.getScaledLength(cal.getPixelWidth().doubleValue(), cal.getPixelHeight().doubleValue());
    }

    public ROI getConvexHull();

    public double getSolidity();

    public boolean contains(double var1, double var3);

    default public boolean intersects(ImageRegion region) {
        return this.getZ() == region.getZ() && this.getT() == region.getT() && this.intersects(region.getX(), region.getY(), region.getWidth(), region.getHeight());
    }

    public boolean intersects(double var1, double var3, double var5, double var7);

    public ROI updatePlane(ImagePlane var1);

    public static enum RoiType {
        AREA,
        LINE,
        POINT;

    }
}

