/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.GeometryROI;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.LineROI;
import qupath.lib.roi.PointsROI;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.PolylineROI;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class ROIs {
    public static ROI createEmptyROI() {
        return ROIs.createEmptyROI(ImagePlane.getDefaultPlane());
    }

    static ROI createEmptyROI(ImagePlane plane) {
        return ROIs.createRectangleROI(0.0, 0.0, 0.0, 0.0, plane);
    }

    public static ROI createRectangleROI(double x, double y, double width, double height, ImagePlane plane) {
        return new RectangleROI(x, y, width, height, plane);
    }

    public static ROI createRectangleROI(double x, double y, double width, double height) {
        return ROIs.createRectangleROI(x, y, width, height, ImagePlane.getDefaultPlane());
    }

    public static ROI createRectangleROI(ImageRegion region) {
        return new RectangleROI(region.getX(), region.getY(), region.getWidth(), region.getHeight(), region.getImagePlane());
    }

    public static ROI createEllipseROI(double x, double y, double width, double height, ImagePlane plane) {
        return new EllipseROI(x, y, width, height, plane);
    }

    public static ROI createEllipseROI(double x, double y, double width, double height) {
        return ROIs.createEllipseROI(x, y, width, height, ImagePlane.getDefaultPlane());
    }

    public static ROI createEllipseROI(ImageRegion region) {
        return ROIs.createEllipseROI(region.getX(), region.getY(), region.getWidth(), region.getHeight(), region.getImagePlane());
    }

    public static ROI createLineROI(double x, double y, double x2, double y2, ImagePlane plane) {
        return new LineROI(x, y, x2, y2, plane);
    }

    public static ROI createLineROI(double x, double y, double x2, double y2) {
        return ROIs.createLineROI(x, y, x2, y2, ImagePlane.getDefaultPlane());
    }

    public static ROI createLineROI(double x, double y, ImagePlane plane) {
        return ROIs.createLineROI(x, y, x, y, plane);
    }

    public static ROI createPointsROI(ImagePlane plane) {
        return ROIs.createPointsROI(Double.NaN, Double.NaN, plane);
    }

    public static ROI createPointsROI() {
        return ROIs.createPointsROI(ImagePlane.getDefaultPlane());
    }

    public static ROI createPointsROI(double x, double y, ImagePlane plane) {
        return new PointsROI(x, y, plane);
    }

    public static ROI createPointsROI(double x, double y) {
        return ROIs.createPointsROI(x, y, ImagePlane.getDefaultPlane());
    }

    public static ROI createPointsROI(List<? extends Point2> points, ImagePlane plane) {
        return new PointsROI(points, plane);
    }

    public static ROI createPointsROI(List<? extends Point2> points) {
        return ROIs.createPointsROI(points, ImagePlane.getDefaultPlane());
    }

    public static ROI createPointsROI(double[] x, double[] y, ImagePlane plane) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Point arrays have different lengths!");
        }
        ArrayList<Point2> points = new ArrayList<Point2>();
        for (int i = 0; i < x.length; ++i) {
            points.add(new Point2(x[i], y[i]));
        }
        return new PointsROI(points, plane);
    }

    public static ROI createPointsROI(double[] x, double[] y) throws IllegalArgumentException {
        return ROIs.createPointsROI(x, y, ImagePlane.getDefaultPlane());
    }

    public static PolygonROI createPolygonROI(List<? extends Point2> points, ImagePlane plane) {
        return new PolygonROI(points, plane);
    }

    public static PolygonROI createPolygonROI(List<? extends Point2> points) {
        return ROIs.createPolygonROI(points, ImagePlane.getDefaultPlane());
    }

    public static ROI createPolygonROI(double[] x, double[] y, ImagePlane plane) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different lengths!");
        }
        ArrayList<Point2> points = new ArrayList<Point2>();
        for (int i = 0; i < x.length; ++i) {
            points.add(new Point2(x[i], y[i]));
        }
        return new PolygonROI(points, plane);
    }

    public static ROI createPolygonROI(double[] x, double[] y) throws IllegalArgumentException {
        return ROIs.createPolygonROI(x, y, ImagePlane.getDefaultPlane());
    }

    public static PolygonROI createPolygonROI(double x, double y, ImagePlane plane) {
        return new PolygonROI(Collections.singletonList(new Point2(x, y)), plane);
    }

    public static PolygonROI createPolygonROI(double x, double y) {
        return ROIs.createPolygonROI(x, y, ImagePlane.getDefaultPlane());
    }

    public static PolylineROI createPolylineROI(List<? extends Point2> points, ImagePlane plane) {
        return new PolylineROI(points, plane);
    }

    public static PolylineROI createPolylineROI(List<? extends Point2> points) {
        return ROIs.createPolylineROI(points, ImagePlane.getDefaultPlane());
    }

    public static PolylineROI createPolylineROI(double x, double y, ImagePlane plane) {
        return ROIs.createPolylineROI(Collections.singletonList(new Point2(x, y)), plane);
    }

    public static PolylineROI createPolylineROI(double x, double y) {
        return ROIs.createPolylineROI(x, y, ImagePlane.getDefaultPlane());
    }

    public static ROI createPolylineROI(double[] x, double[] y, ImagePlane plane) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("Arrays have different lengths!");
        }
        ArrayList<Point2> points = new ArrayList<Point2>();
        for (int i = 0; i < x.length; ++i) {
            points.add(new Point2(x[i], y[i]));
        }
        return new PolylineROI(points, plane);
    }

    public static ROI createPolylineROI(double[] x, double[] y) throws IllegalArgumentException {
        return ROIs.createPolylineROI(x, y, ImagePlane.getDefaultPlane());
    }

    @Deprecated
    public static ROI createAreaROI(Shape shape, ImagePlane plane) {
        return new GeometryROI(GeometryTools.shapeToGeometry(shape), plane);
    }
}

