/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.ConvexHull;
import qupath.lib.roi.PolygonROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class PointsROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Point2> points = new ArrayList<Point2>();
    private transient double xMin = Double.NaN;
    private transient double yMin = Double.NaN;
    private transient double xMax = Double.NaN;
    private transient double yMax = Double.NaN;
    private transient double xCentroid = Double.NaN;
    private transient double yCentroid = Double.NaN;
    private transient ROI convexHull = null;

    PointsROI() {
        this(Double.NaN, Double.NaN);
    }

    private PointsROI(double x, double y) {
        this(x, y, null);
    }

    PointsROI(double x, double y, ImagePlane plane) {
        super(plane);
        this.addPoint(x, y);
        this.recomputeBounds();
    }

    PointsROI(List<? extends Point2> points, ImagePlane plane) {
        super(plane);
        for (Point2 point2 : points) {
            this.addPoint(point2.getX(), point2.getY());
        }
        this.recomputeBounds();
    }

    private PointsROI(float[] x, float[] y, ImagePlane plane) {
        super(plane);
        if (x.length != y.length) {
            throw new IllegalArgumentException("Lengths of x and y arrays are not the same! " + x.length + " and " + y.length);
        }
        for (int i = 0; i < x.length; ++i) {
            this.addPoint(x[i], y[i]);
        }
        this.recomputeBounds();
    }

    @Override
    public double getCentroidX() {
        if (this.points.isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(this.xCentroid)) {
            this.computeCentroid();
        }
        return this.xCentroid;
    }

    @Override
    public double getCentroidY() {
        if (this.points.isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(this.yCentroid)) {
            this.computeCentroid();
        }
        return this.yCentroid;
    }

    private void computeCentroid() {
        double xSum = 0.0;
        double ySum = 0.0;
        int n = this.points.size();
        for (Point2 p : this.points) {
            xSum += p.getX() / (double)n;
            ySum += p.getY() / (double)n;
        }
        this.xCentroid = xSum;
        this.yCentroid = ySum;
    }

    public Point2 getNearest(double x, double y, double maxDist) {
        double maxDistSq = maxDist * maxDist;
        Point2 pClosest = null;
        double distClosestSq = Double.POSITIVE_INFINITY;
        for (Point2 p : this.points) {
            double distSq = p.distanceSq(x, y);
            if (!(distSq <= maxDistSq) || !(distSq < distClosestSq)) continue;
            pClosest = p;
            distClosestSq = distSq;
        }
        return pClosest;
    }

    protected void recomputeBounds() {
        if (this.points.isEmpty()) {
            this.resetBounds();
            return;
        }
        this.xMin = Double.POSITIVE_INFINITY;
        this.yMin = Double.POSITIVE_INFINITY;
        this.xMax = Double.NEGATIVE_INFINITY;
        this.yMax = Double.NEGATIVE_INFINITY;
        for (Point2 p : this.points) {
            this.updateBounds(p.getX(), p.getY());
        }
    }

    protected void updateBounds(double x, double y) {
        if (x < this.xMin) {
            this.xMin = x;
        }
        if (x > this.xMax) {
            this.xMax = x;
        }
        if (y < this.yMin) {
            this.yMin = y;
        }
        if (y > this.yMax) {
            this.yMax = y;
        }
    }

    private void addPoint(double x, double y) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            return;
        }
        this.points.add(new Point2(x, y));
    }

    @Override
    public boolean isEmpty() {
        return this.points.isEmpty();
    }

    @Override
    public String getRoiName() {
        return "Points";
    }

    @Override
    public String toString() {
        return String.format("%s (%d points)", this.getRoiName(), this.points.size());
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public List<Point2> getAllPoints() {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        return new PointsROI(this.getAllPoints().stream().map(p -> RoiTools.scalePoint(p, scaleX, scaleY, originX, originY)).toList(), this.getImagePlane());
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new PointsROI(this.points, this.getImagePlane());
    }

    @Override
    public ROI getConvexHull() {
        if (this.convexHull == null) {
            if (this.points.isEmpty()) {
                return null;
            }
            this.convexHull = new PolygonROI(ConvexHull.getConvexHull(this.points));
        }
        return this.convexHull;
    }

    private void resetBounds() {
        this.xMin = Double.NaN;
        this.yMin = Double.NaN;
        this.xMax = Double.NaN;
        this.yMax = Double.NaN;
    }

    @Override
    public double getBoundsX() {
        return this.xMin;
    }

    @Override
    public double getBoundsY() {
        return this.yMin;
    }

    @Override
    public double getBoundsWidth() {
        return this.xMax - this.xMin;
    }

    @Override
    public double getBoundsHeight() {
        return this.yMax - this.yMin;
    }

    @Override
    public Shape getShape() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("PointROI does not support getShape()!");
    }

    @Override
    protected Shape createShape() {
        throw new UnsupportedOperationException("PointROI does not support createShape()!");
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.POINT;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new PointsROI(this.points, plane);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointsROI pointsROI = (PointsROI)o;
        return Objects.equals(this.points, pointsROI.points) && Objects.equals(this.getImagePlane(), pointsROI.getImagePlane());
    }

    public int hashCode() {
        return Objects.hash(this.points, this.getImagePlane());
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    @Override
    public ROI translate(double dx, double dy) {
        return new PointsROI(this.points.stream().map(p -> new Point2(p.getX() + dx, p.getY() + dy)).toList(), this.getImagePlane());
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        return 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        for (Point2 p : this.points) {
            double px = p.getX();
            double py = p.getY();
            if (!(px > x) || !(py > y) || !(px < x + width) || !(py < y + height)) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getLength() {
        return 0.0;
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        return 0.0;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float[] x;
        private final float[] y;
        private final String name;
        private final int c;
        private final int z;
        private final int t;

        SerializationProxy(PointsROI roi) {
            int n = roi.getNumPoints();
            this.x = new float[n];
            this.y = new float[n];
            int ind = 0;
            for (Point2 p : roi.points) {
                this.x[ind] = (float)p.getX();
                this.y[ind] = (float)p.getY();
                ++ind;
            }
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
        }

        private Object readResolve() {
            PointsROI roi = new PointsROI(this.x, this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            return roi;
        }
    }
}

