/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class LineROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double x = Double.NaN;
    private double y = Double.NaN;
    private double x2 = Double.NaN;
    private double y2 = Double.NaN;

    LineROI() {
    }

    LineROI(double x, double y, double x2, double y2) {
        this(x, y, x2, y2, null);
    }

    LineROI(double x, double y, double x2, double y2, ImagePlane plane) {
        super(plane);
        this.x = x;
        this.y = y;
        this.x2 = x2;
        this.y2 = y2;
    }

    @Override
    public String getRoiName() {
        return "Line";
    }

    @Override
    public double getLength() {
        return this.getScaledLength(1.0, 1.0);
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        double dx = (this.x2 - this.x) * pixelWidth;
        double dy = (this.y2 - this.y) * pixelHeight;
        return Math.sqrt(dx * dx + dy * dy);
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new LineROI(this.x, this.y, this.x2, this.y2, this.getImagePlane());
    }

    @Override
    public int getNumPoints() {
        return 2;
    }

    public double getX1() {
        return this.x;
    }

    public double getY1() {
        return this.y;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    @Override
    public boolean isEmpty() {
        return this.x == this.x2 && this.y == this.y2;
    }

    @Override
    public double getCentroidX() {
        return 0.5 * (this.x + this.x2);
    }

    @Override
    public double getCentroidY() {
        return 0.5 * (this.y + this.y2);
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        return new LineROI(this.x + dx, this.y + dy, this.x2 + dx, this.y2 + dy, this.getImagePlane());
    }

    @Override
    public double getBoundsX() {
        return this.x < this.x2 ? this.x : this.x2;
    }

    @Override
    public double getBoundsY() {
        return this.y < this.y2 ? this.y : this.y2;
    }

    @Override
    public double getBoundsWidth() {
        return Math.abs(this.x - this.x2);
    }

    @Override
    public double getBoundsHeight() {
        return Math.abs(this.y - this.y2);
    }

    @Override
    public List<Point2> getAllPoints() {
        return Arrays.asList(new Point2(this.x, this.y), new Point2(this.x2, this.y2));
    }

    @Override
    public Shape getShape() {
        return this.createShape();
    }

    @Override
    protected Line2D createShape() {
        return new Line2D.Double(this.x, this.y, this.x2, this.y2);
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new LineROI(this.x, this.y, this.x2, this.y2, plane);
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.LINE;
    }

    @Override
    public ROI getConvexHull() {
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LineROI lineROI = (LineROI)o;
        return Double.compare(this.x, lineROI.x) == 0 && Double.compare(this.y, lineROI.y) == 0 && Double.compare(this.x2, lineROI.x2) == 0 && Double.compare(this.y2, lineROI.y2) == 0 && this.getImagePlane().equals(lineROI.getImagePlane());
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.x2, this.y2, this.getImagePlane());
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    @Override
    public double getArea() {
        return 0.0;
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        return 0.0;
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        if (!this.intersectsBounds(x, y, width, height)) {
            return false;
        }
        return new Rectangle2D.Double(x, y, width, height).intersectsLine(this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        return new LineROI(RoiTools.scaleOrdinate(this.x, scaleX, originX), RoiTools.scaleOrdinate(this.y, scaleY, originY), RoiTools.scaleOrdinate(this.x2, scaleX, originX), RoiTools.scaleOrdinate(this.y2, scaleY, originY), this.getImagePlane());
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final double x;
        private final double x2;
        private final double y;
        private final double y2;
        private final String name;
        private final int c;
        private final int z;
        private final int t;

        SerializationProxy(LineROI roi) {
            this.x = roi.x;
            this.x2 = roi.x2;
            this.y = roi.y;
            this.y2 = roi.y2;
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
        }

        private Object readResolve() {
            LineROI roi = new LineROI(this.x, this.y, this.x2, this.y2, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            return roi;
        }
    }
}

