/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Function;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.awt.GeometryCollectionShape;
import org.locationtech.jts.awt.PointTransformation;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.awt.ShapeWriter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.GeometryExtracter;
import org.locationtech.jts.geom.util.LineStringExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.quadtree.Quadtree;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.locationtech.jts.precision.GeometryPrecisionReducer;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;
import org.locationtech.jts.util.GeometricShapeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.EllipseROI;
import qupath.lib.roi.FastPolygonUnion;
import qupath.lib.roi.GeometryROI;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class GeometryTools {
    private static final Logger logger;
    private static final GeometryFactory DEFAULT_FACTORY;
    private static final PrecisionModel INTEGER_PRECISION_MODEL;
    private static final GeometryConverter DEFAULT_INSTANCE;

    public static GeometryFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    public static AffineTransformation parseTransformMatrix(String text) throws ParseException {
        Object delims = "\n\t ";
        if (text.contains(".")) {
            delims = (String)delims + ",";
            text = text.replace(System.lineSeparator(), ",");
        } else {
            text = text.replace(System.lineSeparator(), " ");
        }
        NumberFormat nf = NumberFormat.getInstance();
        StringTokenizer tokens = new StringTokenizer(text, (String)delims);
        if (tokens.countTokens() != 6) {
            throw new IllegalArgumentException("Affine transform should be tab-delimited and contain 6 numbers only");
        }
        double m00 = nf.parse(tokens.nextToken()).doubleValue();
        double m01 = nf.parse(tokens.nextToken()).doubleValue();
        double m02 = nf.parse(tokens.nextToken()).doubleValue();
        double m10 = nf.parse(tokens.nextToken()).doubleValue();
        double m11 = nf.parse(tokens.nextToken()).doubleValue();
        double m12 = nf.parse(tokens.nextToken()).doubleValue();
        return new AffineTransformation(m00, m01, m02, m10, m11, m12);
    }

    public static AffineTransform convertTransform(AffineTransformation transform) {
        double[] mat = transform.getMatrixEntries();
        return new AffineTransform(mat[0], mat[3], mat[1], mat[4], mat[2], mat[5]);
    }

    public static AffineTransformation convertTransform(AffineTransform transform) {
        double[] mat = new double[6];
        transform.getMatrix(mat);
        return new AffineTransformation(mat[0], mat[2], mat[4], mat[1], mat[3], mat[5]);
    }

    public static Geometry shapeToGeometry(Shape shape) {
        return DEFAULT_INSTANCE.shapeToGeometry(shape);
    }

    public static ImageRegion envelopToRegion(Envelope env, int z, int t) {
        int x = (int)Math.floor(env.getMinX());
        int y = (int)Math.floor(env.getMinY());
        int width = (int)Math.ceil(env.getMaxX()) - x;
        int height = (int)Math.ceil(env.getMaxY()) - y;
        return ImageRegion.createInstance(x, y, width, height, z, t);
    }

    public static Envelope regionToEnvelope(ImageRegion region) {
        return new Envelope((double)region.getMinX(), (double)region.getMaxX(), (double)region.getMinY(), (double)region.getMaxY());
    }

    public static Envelope roiToEnvelope(ROI roi) {
        return new Envelope(roi.getBoundsX(), roi.getBoundsX() + roi.getBoundsWidth(), roi.getBoundsY(), roi.getBoundsY() + roi.getBoundsHeight());
    }

    public static Geometry attemptOperation(Geometry input, Function<Geometry, Geometry> fun) {
        try {
            return fun.apply(input);
        }
        catch (Exception e) {
            logger.debug(e.getLocalizedMessage(), (Throwable)e);
            return input;
        }
    }

    public static Geometry roundCoordinates(Geometry geometry) {
        geometry = GeometryPrecisionReducer.reduce((Geometry)geometry, (PrecisionModel)INTEGER_PRECISION_MODEL);
        geometry = DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)0.0);
        return geometry;
    }

    public static Geometry ensurePrecision(Geometry geometry) {
        return GeometryTools.ensurePrecision(geometry, GeometryTools.getDefaultFactory().getPrecisionModel());
    }

    public static Geometry ensurePrecision(Geometry geometry, PrecisionModel precisionModel) {
        if (geometry.getFactory().getPrecisionModel() == precisionModel) {
            return geometry;
        }
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precisionModel);
        reducer.setChangePrecisionModel(true);
        return reducer.reduce(geometry);
    }

    public static Geometry constrainToBounds(Geometry geometry, double x, double y, double width, double height) {
        Envelope env = geometry.getEnvelopeInternal();
        if (env.getMinX() < x || env.getMinY() < y || env.getMaxX() >= x + width || env.getMaxY() >= y + height) {
            geometry = geometry.intersection((Geometry)GeometryTools.createRectangle(x, y, width, height));
        }
        return geometry;
    }

    public static double iou(Geometry a, Geometry b) {
        double areaA = a.getArea();
        double areaB = b.getArea();
        double intersection = GeometryTools.intersectionArea(a, b);
        return intersection / (areaA + areaB - intersection);
    }

    public static double intersectionArea(Geometry a, Geometry b) {
        double areaB;
        if (a.getDimension() < 2 || b.getDimension() < 2 || a.isEmpty() || b.isEmpty()) {
            return 0.0;
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return 0.0;
        }
        double areaA = a.getArea();
        if (areaA == (areaB = b.getArea()) && a.equalsExact(b)) {
            return areaA;
        }
        IntersectionMatrix relate = a.relate(b);
        if (relate.isCovers()) {
            return areaB;
        }
        if (relate.isCoveredBy()) {
            return areaA;
        }
        if (relate.isDisjoint() || relate.isTouches(a.getDimension(), b.getDimension())) {
            return 0.0;
        }
        return a.intersection(b).getArea();
    }

    public static Polygon createRectangle(double x, double y, double width, double height) {
        GeometricShapeFactory shapeFactory = new GeometricShapeFactory(DEFAULT_FACTORY);
        shapeFactory.setNumPoints(4);
        shapeFactory.setEnvelope(new Envelope(x, x + width, y, y + height));
        return shapeFactory.createRectangle();
    }

    public static Polygon createEllipse(double x, double y, double width, double height, int nPoints) {
        GeometricShapeFactory shapeFactory = new GeometricShapeFactory(DEFAULT_FACTORY);
        shapeFactory.setNumPoints(nPoints);
        shapeFactory.setEnvelope(new Envelope(x, x + width, y, y + height));
        return shapeFactory.createEllipse();
    }

    public static LineString createLineString(double x1, double y1, double x2, double y2) {
        return GeometryTools.createLineString(new Point2(x1, y1), new Point2(x2, y2));
    }

    public static LineString createLineString(Point2 ... points) {
        return GeometryTools.getDefaultFactory().createLineString((Coordinate[])Arrays.stream(points).map(p -> new Coordinate(p.getX(), p.getY())).toArray(Coordinate[]::new));
    }

    public static ROI geometryToROI(Geometry geometry, ImagePlane plane) {
        return DEFAULT_INSTANCE.geometryToROI(geometry, plane);
    }

    public static ROI geometryToROI(Geometry geometry) {
        return GeometryTools.geometryToROI(geometry, ImagePlane.getDefaultPlane());
    }

    public static Geometry roiToGeometry(ROI roi) {
        return DEFAULT_INSTANCE.roiToGeometry(roi);
    }

    public static Shape geometryToShape(Geometry geometry) {
        return DEFAULT_INSTANCE.geometryToShape(geometry);
    }

    public static Geometry regionToGeometry(ImageRegion region) {
        Coordinate[] coords;
        coords = new Coordinate[]{DEFAULT_INSTANCE.createCoordinate(region.getMinX(), region.getMinY(), region.getZ()), DEFAULT_INSTANCE.createCoordinate(region.getMaxX(), region.getMinY(), region.getZ()), DEFAULT_INSTANCE.createCoordinate(region.getMaxX(), region.getMaxY(), region.getZ()), DEFAULT_INSTANCE.createCoordinate(region.getMinX(), region.getMaxY(), region.getZ()), coords[0]};
        return GeometryTools.DEFAULT_INSTANCE.factory.createPolygon(coords);
    }

    public static Geometry union(Geometry ... geometries) {
        return GeometryTools.union(Arrays.asList(geometries));
    }

    public static Geometry union(Collection<? extends Geometry> geometries) {
        if (geometries.isEmpty()) {
            return GeometryTools.getDefaultFactory().createPolygon();
        }
        if (geometries.size() == 1) {
            return geometries.iterator().next();
        }
        try {
            if (geometries.size() > 2 || geometries.stream().allMatch(g -> g instanceof Polygonal)) {
                return FastPolygonUnion.union(geometries);
            }
            logger.trace("Calling UnaryUnionNG for {} geometries", (Object)geometries.size());
            return UnaryUnionNG.union(new ArrayList<Geometry>(geometries), (PrecisionModel)GeometryTools.getDefaultFactory().getPrecisionModel());
        }
        catch (Exception e) {
            logger.warn("Geometry union failed - attempting with buffer(0)", (Throwable)e);
            return GeometryTools.getDefaultFactory().buildGeometry(geometries).buffer(0.0);
        }
    }

    public static Geometry ensurePolygonal(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return geometry;
        }
        if (!(geometry instanceof GeometryCollection)) {
            return geometry.getFactory().createPolygon();
        }
        ArrayList<Geometry> keepGeometries = new ArrayList<Geometry>();
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            if (!(geometry.getGeometryN(i) instanceof Polygonal)) continue;
            keepGeometries.add(geometry.getGeometryN(i));
        }
        if (keepGeometries.isEmpty()) {
            return geometry.getFactory().createPolygon();
        }
        return geometry.getFactory().buildGeometry(keepGeometries);
    }

    public static Geometry homogenizeGeometryCollection(Geometry geometry) {
        if (geometry instanceof Polygonal || geometry instanceof Puntal || geometry instanceof Lineal) {
            return geometry;
        }
        boolean hasPolygons = false;
        boolean hasLines = false;
        ArrayList<Geometry> collection = new ArrayList<Geometry>();
        for (Geometry geom : GeometryTools.flatten(geometry, null)) {
            if ((geom = GeometryTools.homogenizeGeometryCollection(geom)) instanceof Polygonal) {
                if (!hasPolygons) {
                    collection.clear();
                }
                collection.add(geom);
                hasPolygons = true;
                continue;
            }
            if (geom instanceof Lineal) {
                if (hasPolygons) continue;
                if (!hasLines) {
                    collection.clear();
                }
                collection.add(geom);
                hasLines = true;
                continue;
            }
            if (!(geom instanceof Puntal) || hasPolygons || hasLines) continue;
            collection.add(geom);
        }
        return geometry.getFactory().buildGeometry(collection);
    }

    private static List<Geometry> flatten(Geometry geometry, List<Geometry> list) {
        if (list == null) {
            list = new ArrayList<Geometry>();
        }
        for (int i = 0; i < geometry.getNumGeometries(); ++i) {
            Geometry geom = geometry.getGeometryN(i);
            if (geom instanceof GeometryCollection) {
                GeometryTools.flatten(geom, list);
                continue;
            }
            list.add(geom);
        }
        return list;
    }

    public static Geometry removeInteriorRings(Geometry geometry, double minRingArea) {
        if (minRingArea <= 0.0) {
            return geometry;
        }
        if (geometry instanceof Polygon) {
            return GeometryTools.removeInteriorRings((Polygon)geometry, minRingArea, null);
        }
        List<Geometry> list = GeometryTools.flatten(geometry, null);
        HashSet<Object> smallGeometries = new HashSet<Object>();
        Quadtree tree = null;
        PreparedGeometryFactory preparedFactory = new PreparedGeometryFactory();
        ArrayList<LinearRing> removedRingList = new ArrayList<LinearRing>();
        for (int i = 0; i < list.size(); ++i) {
            Geometry temp = list.get(i);
            if (temp instanceof Polygon) {
                Polygon poly = GeometryTools.removeInteriorRings((Polygon)temp, minRingArea, removedRingList);
                if (poly != temp) {
                    if (tree == null) {
                        tree = new Quadtree();
                    }
                    for (LinearRing ring : removedRingList) {
                        PreparedGeometry hole = preparedFactory.create((Geometry)ring.getFactory().createPolygon(ring));
                        tree.insert(ring.getEnvelopeInternal(), (Object)hole);
                    }
                    list.set(i, (Geometry)poly);
                    removedRingList.clear();
                }
                if (!(Area.ofRing((CoordinateSequence)poly.getExteriorRing().getCoordinateSequence()) < minRingArea)) continue;
                smallGeometries.add(poly);
                continue;
            }
            if (!(temp.getArea() < minRingArea)) continue;
            smallGeometries.add(temp);
        }
        if (tree == null) {
            return geometry;
        }
        Iterator<Geometry> iter = list.iterator();
        block2: while (iter.hasNext()) {
            Geometry small = iter.next();
            if (!smallGeometries.contains(small)) continue;
            List query = tree.query(small.getEnvelopeInternal());
            for (PreparedPolygon hole : query) {
                if (!hole.covers(small)) continue;
                iter.remove();
                continue block2;
            }
        }
        return geometry.getFactory().buildGeometry(list);
    }

    private static Polygon removeAllInteriorRings(Polygon polygon) {
        if (polygon.getNumInteriorRing() == 0) {
            return polygon;
        }
        GeometryFactory factory = polygon.getFactory();
        return factory.createPolygon(polygon.getExteriorRing().getCoordinateSequence());
    }

    static double externalRingArea(Polygon polygon) {
        return Area.ofRing((Coordinate[])polygon.getExteriorRing().getCoordinates());
    }

    private static Polygon removeInteriorRings(Polygon polygon, double minArea, List<LinearRing> removedRings) {
        int nRings = polygon.getNumInteriorRing();
        if (nRings == 0) {
            return polygon;
        }
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (int i = 0; i < nRings; ++i) {
            LinearRing ring = polygon.getInteriorRingN(i);
            Coordinate[] coords = ring.getCoordinates();
            if (Area.ofRing((Coordinate[])coords) >= minArea) {
                holes.add(ring);
                continue;
            }
            if (removedRings == null) continue;
            removedRings.add(ring);
        }
        if (holes.size() == nRings) {
            return polygon;
        }
        GeometryFactory factory = polygon.getFactory();
        if (holes.isEmpty()) {
            return factory.createPolygon(polygon.getExteriorRing());
        }
        return factory.createPolygon(polygon.getExteriorRing(), (LinearRing[])holes.toArray(LinearRing[]::new));
    }

    public static Geometry fillHoles(Geometry geometry) {
        List<Geometry> filtered;
        if (geometry instanceof Polygon) {
            return GeometryTools.removeAllInteriorRings((Polygon)geometry);
        }
        List<Geometry> list = GeometryTools.flatten(geometry, null);
        if (list.equals(filtered = list.stream().map(g -> {
            if (g instanceof Polygon) {
                return GeometryTools.removeAllInteriorRings((Polygon)g);
            }
            return g;
        }).toList())) {
            return geometry;
        }
        return GeometryTools.union(filtered);
    }

    public static Polygon findLargestPolygon(Geometry geometry) {
        if (geometry instanceof Polygon) {
            return (Polygon)geometry;
        }
        List<Polygon> polygons = GeometryTools.flatten(geometry, null).stream().filter(g -> g instanceof Polygon).map(g -> (Polygon)g).toList();
        if (polygons.isEmpty()) {
            return null;
        }
        if (polygons.size() == 1) {
            return polygons.get(0);
        }
        double maxArea = polygons.get(0).getArea();
        int maxInd = 0;
        for (int i = 1; i < polygons.size(); ++i) {
            double area = polygons.get(i).getArea();
            if (!(area > maxArea)) continue;
            maxArea = area;
            maxInd = i;
        }
        return polygons.get(maxInd);
    }

    public static Geometry removeFragments(Geometry geometry, double minArea) {
        if (minArea <= 0.0) {
            return geometry;
        }
        if (geometry instanceof Polygon) {
            if (GeometryTools.externalRingArea((Polygon)geometry) >= minArea) {
                return geometry;
            }
            return geometry.getFactory().createPolygon();
        }
        List polygons = PolygonExtracter.getPolygons((Geometry)geometry);
        if (polygons.isEmpty()) {
            return geometry.getFactory().createPolygon();
        }
        List<Polygon> filtered = polygons.stream().filter(g -> GeometryTools.externalRingArea(g) >= minArea).toList();
        if (filtered.isEmpty()) {
            return geometry.getFactory().createPolygon();
        }
        return geometry.getFactory().buildGeometry(filtered);
    }

    public static Geometry tryToFixPolygon(Polygon polygon) {
        TopologyValidationError error = new IsValidOp((Geometry)polygon).getValidationError();
        if (error == null) {
            return polygon;
        }
        logger.debug("Invalid polygon detected! Attempting to correct {}", (Object)error);
        double areaBefore = polygon.getArea();
        double tol = 1.0E-4;
        Geometry geomBuffered = polygon.buffer(0.0);
        double areaBuffered = geomBuffered.getArea();
        if (geomBuffered.isValid() && GeneralTools.almostTheSame(areaBefore, areaBuffered, tol)) {
            return geomBuffered;
        }
        if (!geomBuffered.isEmpty() && areaBuffered < areaBefore * 0.001) {
            try {
                Geometry geomDifference = polygon.difference(geomBuffered);
                if (geomDifference.isValid()) {
                    return geomDifference;
                }
            }
            catch (Exception e) {
                logger.debug("Attempting to fix by difference failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        logger.debug("Unable to fix Geometry with buffer(0) - will try snapToSelf instead");
        double distance = GeometrySnapper.computeOverlaySnapTolerance((Geometry)polygon);
        Geometry geomSnapped = GeometrySnapper.snapToSelf((Geometry)polygon, (double)distance, (boolean)true);
        if (geomSnapped.isValid()) {
            return geomSnapped;
        }
        return polygon.getFactory().createPolygon();
    }

    public static Geometry refineAreas(Geometry geometry, double minSizePixels, double minHoleSizePixels) {
        if (minSizePixels <= 0.0 && minHoleSizePixels <= 0.0) {
            return geometry;
        }
        Geometry geom2 = geometry = GeometryTools.ensurePolygonal(geometry);
        geom2 = GeometryTools.removeFragments(geom2, minSizePixels);
        geom2 = GeometryTools.removeInteriorRings(geom2, minHoleSizePixels);
        return geom2;
    }

    static LinearRing toLinearRing(LineString lineString) {
        if (lineString instanceof LinearRing) {
            return (LinearRing)lineString;
        }
        return lineString.getFactory().createLinearRing(lineString.getCoordinateSequence());
    }

    public static List<Geometry> splitGeometryByLineStrings(Geometry polygon, Collection<? extends Geometry> splitLines) throws IllegalArgumentException {
        if (!(polygon instanceof Polygonal)) {
            throw new IllegalArgumentException("Geometry must be polygonal");
        }
        if (splitLines.isEmpty()) {
            if (polygon instanceof GeometryCollection) {
                return GeometryExtracter.extract((Geometry)polygon, (String)"Polygon");
            }
            return Collections.singletonList(polygon);
        }
        Geometry splitGeometry = GeometryTools.union(splitLines);
        Geometry boundary = polygon.getBoundary().union(splitGeometry);
        List lines = LineStringExtracter.getLines((Geometry)boundary);
        Polygonizer polygonizer = new Polygonizer();
        polygonizer.add((Collection)lines);
        Collection polygons = polygonizer.getPolygons();
        return polygons.stream().filter(g -> polygon.contains((Geometry)g.getInteriorPoint())).toList();
    }

    static {
        String propRelate;
        logger = LoggerFactory.getLogger(GeometryTools.class);
        String propOverlay = System.getProperty("jts.overlay");
        if (!"old".equalsIgnoreCase(propOverlay)) {
            logger.debug("Setting -Djts.overlay=ng");
            System.setProperty("jts.overlay", "ng");
        }
        if (!"old".equalsIgnoreCase(propRelate = System.getProperty("jts.relate"))) {
            logger.debug("Setting -Djts.relate=ng");
            System.setProperty("jts.relate", "ng");
        }
        DEFAULT_FACTORY = new GeometryFactory(new PrecisionModel(-0.01), 0, (CoordinateSequenceFactory)PackedCoordinateSequenceFactory.FLOAT_FACTORY);
        INTEGER_PRECISION_MODEL = new PrecisionModel(1.0);
        DEFAULT_INSTANCE = new GeometryConverter.Builder().build();
    }

    public static class GeometryConverter {
        private final GeometryFactory factory;
        private final double pixelHeight;
        private final double pixelWidth;
        private final double flatness;
        private AffineTransform transform = null;
        private Transformer transformer;
        private ShapeReader shapeReader;

        private GeometryConverter(GeometryFactory factory, double pixelWidth, double pixelHeight, double flatness) {
            this.factory = factory == null ? (pixelWidth == 1.0 && pixelHeight == 1.0 ? DEFAULT_FACTORY : new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING_SINGLE), 0, (CoordinateSequenceFactory)PackedCoordinateSequenceFactory.FLOAT_FACTORY)) : factory;
            this.flatness = flatness;
            this.pixelHeight = pixelHeight;
            this.pixelWidth = pixelWidth;
            if (pixelWidth != 1.0 && pixelHeight != 1.0) {
                this.transform = AffineTransform.getScaleInstance(pixelWidth, pixelHeight);
            }
            this.transformer = new Transformer();
        }

        public Geometry roiToGeometry(ROI roi) {
            Geometry geom = null;
            if (roi.isPoint()) {
                geom = this.pointsToGeometry(roi);
            }
            if (roi.isArea()) {
                geom = this.areaToGeometry(roi);
            }
            if (roi.isLine()) {
                geom = this.lineToGeometry(roi);
            }
            if (geom == null) {
                throw new UnsupportedOperationException("Unknown ROI " + String.valueOf(roi) + " - cannot convert to a Geometry!");
            }
            return geom.norm();
        }

        private Geometry lineToGeometry(ROI roi) {
            Coordinate[] coords = (Coordinate[])roi.getAllPoints().stream().map(p -> this.createCoordinate(p.getX() * this.pixelWidth, p.getY() * this.pixelHeight)).toArray(Coordinate[]::new);
            return this.factory.createLineString(coords);
        }

        private Coordinate createCoordinate(double x, double y) {
            PrecisionModel precisionModel = this.factory.getPrecisionModel();
            return new Coordinate(precisionModel.makePrecise(x), precisionModel.makePrecise(y));
        }

        private Coordinate createCoordinate(double x, double y, double z) {
            PrecisionModel precisionModel = this.factory.getPrecisionModel();
            return new Coordinate(precisionModel.makePrecise(x), precisionModel.makePrecise(y), precisionModel.makePrecise(z));
        }

        private Geometry areaToGeometry(ROI roi) {
            if (roi instanceof EllipseROI || roi instanceof RectangleROI) {
                GeometricShapeFactory shapeFactory = new GeometricShapeFactory(this.factory);
                shapeFactory.setEnvelope(new Envelope(roi.getBoundsX() * this.pixelWidth, (roi.getBoundsX() + roi.getBoundsWidth()) * this.pixelWidth, roi.getBoundsY() * this.pixelHeight, (roi.getBoundsY() + roi.getBoundsHeight()) * this.pixelHeight));
                if (roi instanceof EllipseROI) {
                    return shapeFactory.createEllipse();
                }
                shapeFactory.setNumPoints(4);
                return shapeFactory.createRectangle();
            }
            if (roi.isEmpty()) {
                Shape shape = RoiTools.getShape(roi);
                PathIterator iterator = shape.getPathIterator(this.transform, this.flatness);
                return this.getShapeReader().read(iterator);
            }
            java.awt.geom.Area area = RoiTools.getArea(roi);
            return this.areaToGeometry(area);
        }

        private Geometry shapeToGeometry(Shape shape) {
            if (shape instanceof java.awt.geom.Area) {
                return this.areaToGeometry((java.awt.geom.Area)shape);
            }
            PathIterator iterator = shape.getPathIterator(this.transform, this.flatness);
            if ((shape instanceof Path2D || shape instanceof GeneralPath) && GeometryConverter.containsClosedSegments(iterator)) {
                return this.shapeToGeometry(new java.awt.geom.Area(shape));
            }
            iterator = shape.getPathIterator(this.transform, this.flatness);
            return this.getShapeReader().read(iterator);
        }

        private static boolean containsClosedSegments(PathIterator iterator) {
            double[] coords = new double[6];
            while (!iterator.isDone()) {
                iterator.next();
                if (iterator.currentSegment(coords) != 4) continue;
                return true;
            }
            return false;
        }

        private Geometry areaToGeometry(java.awt.geom.Area shape) {
            return GeometryConverter.convertAreaToGeometry(shape, this.transform, this.flatness, this.factory);
        }

        private static Geometry convertAreaToGeometry(java.awt.geom.Area area, AffineTransform transform, double flatness, GeometryFactory factory) {
            PathIterator iter = area.getPathIterator(transform, flatness);
            PrecisionModel precisionModel = factory.getPrecisionModel();
            Polygonizer polygonizer = new Polygonizer(true);
            List coords = ShapeReader.toCoordinates((PathIterator)iter);
            ArrayList<LineString> geometries = new ArrayList<LineString>();
            Iterator iterator = coords.iterator();
            while (iterator.hasNext()) {
                Coordinate[] array;
                for (Coordinate c : array = (Coordinate[])iterator.next()) {
                    precisionModel.makePrecise(c);
                }
                LineString lineString = factory.createLineString(array);
                geometries.add(lineString);
            }
            Geometry geom = factory.buildGeometry(geometries).union();
            polygonizer.add(geom);
            return polygonizer.getGeometry();
        }

        @Deprecated
        private static Geometry convertAreaToGeometryLegacy(java.awt.geom.Area area, AffineTransform transform, double flatness, GeometryFactory factory) {
            Geometry geometry;
            ArrayList<Polygon> holes;
            ArrayList<Polygon> outer;
            ArrayList<Polygon> positive = new ArrayList<Polygon>();
            ArrayList<Polygon> negative = new ArrayList<Polygon>();
            PathIterator iter = area.getPathIterator(transform, flatness);
            CoordinateList points = new CoordinateList();
            PrecisionModel precisionModel = factory.getPrecisionModel();
            double areaTempSigned = 0.0;
            double areaCached = 0.0;
            double areaPositive = 0.0;
            double areaNegative = 0.0;
            double precision = 1.0E-4 * flatness;
            int totalCount = 0;
            int errorCount = 0;
            double[] seg = new double[6];
            double startX = Double.NaN;
            double startY = Double.NaN;
            double x0 = 0.0;
            double y0 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            boolean closed = false;
            block5: while (!iter.isDone()) {
                switch (iter.currentSegment(seg)) {
                    case 0: {
                        startX = precisionModel.makePrecise(seg[0]);
                        startY = precisionModel.makePrecise(seg[1]);
                        x0 = startX;
                        y0 = startY;
                        iter.next();
                        areaCached += areaTempSigned;
                        areaTempSigned = 0.0;
                        points.clear();
                        points.add((Object)new Coordinate(startX, startY));
                        closed = false;
                        continue block5;
                    }
                    case 4: {
                        x1 = startX;
                        y1 = startY;
                        closed = true;
                        break;
                    }
                    case 1: {
                        x1 = precisionModel.makePrecise(seg[0]);
                        y1 = precisionModel.makePrecise(seg[1]);
                        Coordinate next = new Coordinate(x1, y1);
                        if (points.isEmpty() || ((Coordinate)points.get(points.size() - 1)).distance(next) > precision) {
                            points.add(next, false);
                        } else {
                            logger.trace("Skipping nearby points");
                        }
                        closed = false;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid area computation!");
                    }
                }
                areaTempSigned += 0.5 * (x0 * y1 - x1 * y0);
                if (closed && points.size() == 1) {
                    logger.debug("Error when converting area to Geometry: cannot create polygon from coordinate array of length 1!");
                } else if (closed) {
                    Geometry geomValid;
                    points.closeRing();
                    if (points.size() <= 3) {
                        logger.debug("Discarding small 'ring' segment during area conversion (only 3 coordinates)");
                        x0 = x1;
                        y0 = y1;
                        iter.next();
                        continue;
                    }
                    Coordinate[] coords = points.toCoordinateArray();
                    Polygon polygon = factory.createPolygon(coords);
                    if (polygon != (geomValid = GeometryTools.tryToFixPolygon(polygon))) {
                        double areaAfter;
                        double areaBefore = polygon.getArea();
                        if (GeneralTools.almostTheSame(areaBefore, areaAfter = geomValid.getArea(), 1.0E-4)) {
                            logger.debug("Invalid polygon detected and fixed! Original area: {}, Area after fix: {}", (Object)areaBefore, (Object)areaAfter);
                        } else {
                            logger.warn("Invalid polygon detected! Beware of changes. Original area: {}, Area after attempted fix: {}", (Object)areaBefore, (Object)areaAfter);
                        }
                        polygon = geomValid;
                        ++errorCount;
                    }
                    if (!polygon.isEmpty()) {
                        ++totalCount;
                        if (areaTempSigned < 0.0) {
                            areaNegative += areaTempSigned;
                            for (int i = 0; i < polygon.getNumGeometries(); ++i) {
                                p = (Polygon)polygon.getGeometryN(i);
                                if (p.isEmpty()) continue;
                                negative.add(p);
                            }
                        } else if (areaTempSigned > 0.0) {
                            areaPositive += areaTempSigned;
                            for (int i = 0; i < polygon.getNumGeometries(); ++i) {
                                p = (Polygon)polygon.getGeometryN(i);
                                if (p.isEmpty()) continue;
                                positive.add(p);
                            }
                        }
                    }
                }
                x0 = x1;
                y0 = y1;
                iter.next();
            }
            if ((areaCached += areaTempSigned) < 0.0) {
                areaOuter = -areaNegative;
                areaHoles = areaPositive;
                outer = negative;
                holes = positive;
            } else if (areaCached > 0.0) {
                areaOuter = areaPositive;
                areaHoles = -areaNegative;
                outer = positive;
                holes = negative;
            } else {
                return factory.createPolygon();
            }
            if (holes.isEmpty()) {
                Geometry geometryOuter;
                geometry = geometryOuter = GeometryTools.union(outer);
            } else if (outer.size() == 1) {
                Geometry geometryOuter = GeometryTools.union(outer);
                geometry = geometryOuter.difference(GeometryTools.union(holes));
            } else {
                Comparator<GeometryWithArea> ascendingArea = Comparator.comparingDouble(g -> g.area);
                List<GeometryWithArea> outerWithArea = outer.stream().map(GeometryWithArea::new).sorted(ascendingArea).toList();
                List<GeometryWithArea> holesWithArea = holes.stream().map(GeometryWithArea::new).sorted(ascendingArea).toList();
                HashMap<Geometry, ArrayList<Geometry>> matches = new HashMap<Geometry, ArrayList<Geometry>>();
                block8: for (GeometryWithArea tempHole : holesWithArea) {
                    double holeArea = tempHole.area;
                    Coordinate point = tempHole.geom.getCoordinate();
                    Iterator<GeometryWithArea> iterOuter = outerWithArea.iterator();
                    boolean count = false;
                    while (point != null && iterOuter.hasNext()) {
                        GeometryWithArea tempOuter = iterOuter.next();
                        if (holeArea > tempOuter.area || !SimplePointInAreaLocator.isContained((Coordinate)point, (Geometry)tempOuter.geom)) continue;
                        ArrayList<Geometry> list = (ArrayList<Geometry>)matches.get(tempOuter.geom);
                        if (list == null) {
                            list = new ArrayList<Geometry>();
                            matches.put(tempOuter.geom, list);
                        }
                        list.add(tempHole.geom);
                        continue block8;
                    }
                }
                ArrayList<Geometry> fixedGeometries = new ArrayList<Geometry>();
                for (GeometryWithArea tempOuter : outerWithArea) {
                    List list = matches.getOrDefault(tempOuter.geom, null);
                    if (list == null || list.isEmpty()) {
                        fixedGeometries.add(tempOuter.geom);
                        continue;
                    }
                    Geometry mergedHoles = GeometryTools.union(list);
                    fixedGeometries.add(tempOuter.geom.difference(mergedHoles));
                }
                Geometry geometryOuter = geometry = GeometryTools.union(fixedGeometries);
            }
            double computedArea = Math.abs(areaCached);
            double geometryArea = geometry.getArea();
            if (!GeneralTools.almostTheSame(computedArea, geometryArea, 0.01)) {
                logger.debug("{}/{} geometries had topology validation errors", (Object)errorCount, (Object)totalCount);
                double percent = Math.abs(computedArea - geometryArea) / (computedArea / 2.0 + geometryArea / 2.0) * 100.0;
                logger.warn("Difference in area after JTS conversion! Computed area: {}, Geometry area: {} ({} %%)", new Object[]{Math.abs(areaCached), geometry.getArea(), GeneralTools.formatNumber(percent, 3)});
            }
            return geometry;
        }

        private Geometry pointsToGeometry(ROI points) {
            Coordinate[] coords = (Coordinate[])points.getAllPoints().stream().map(p -> this.createCoordinate(p.getX() * this.pixelWidth, p.getY() * this.pixelHeight)).toArray(Coordinate[]::new);
            if (coords.length == 1) {
                return this.factory.createPoint(coords[0]);
            }
            return this.factory.createMultiPointFromCoords(coords);
        }

        private ShapeReader getShapeReader() {
            if (this.shapeReader == null) {
                this.shapeReader = new ShapeReader(this.factory);
            }
            return this.shapeReader;
        }

        private ShapeWriter getShapeWriter() {
            ShapeWriter writer = new ShapeWriter((PointTransformation)this.transformer);
            writer.setRemoveDuplicatePoints(true);
            return writer;
        }

        private Shape geometryToShape(Geometry geometry) {
            Shape shape = this.getShapeWriter().toShape(geometry);
            if (geometry instanceof Polygonal && shape instanceof GeometryCollectionShape) {
                return new GeometryShapeWrapper(geometry, shape);
            }
            return shape;
        }

        private ROI geometryToROI(Geometry geometry, ImagePlane plane) {
            if (geometry.isEmpty()) {
                return ROIs.createEmptyROI(plane);
            }
            Geometry geometry2 = GeometryTools.homogenizeGeometryCollection(geometry);
            if (geometry2 != geometry) {
                logger.warn("Geometries must all be of the same type when converting to a ROI! Converted {} to {}.", (Object)geometry.getGeometryType(), (Object)geometry2.getGeometryType());
                geometry = geometry2;
            }
            if (geometry instanceof Point) {
                Coordinate coord2 = geometry.getCoordinate();
                return ROIs.createPointsROI(coord2.x, coord2.y, plane);
            }
            if (geometry instanceof MultiPoint) {
                Coordinate[] coords = geometry.getCoordinates();
                List<Point2> points = Arrays.stream(coords).map(c -> new Point2(c.x, c.y)).toList();
                return ROIs.createPointsROI(points, plane);
            }
            if (geometry.getNumGeometries() > 1) {
                return new GeometryROI(geometry, plane);
            }
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                if (polygon.getNumInteriorRing() > 0) {
                    return new GeometryROI((Geometry)polygon, plane);
                }
                if (!polygon.isRectangle()) {
                    List<Point2> points = Arrays.stream(polygon.getCoordinates()).map(coord -> new Point2(coord.x, coord.y)).toList();
                    return ROIs.createPolygonROI(points, plane);
                }
            }
            return RoiTools.getShapeROI(this.geometryToShape(geometry), plane, this.flatness);
        }

        private class Transformer
        implements PointTransformation {
            private Transformer() {
            }

            public void transform(Coordinate src, Point2D dest) {
                dest.setLocation(src.x / GeometryConverter.this.pixelWidth, src.y / GeometryConverter.this.pixelHeight);
            }
        }

        private static class GeometryWithArea {
            private final Geometry geom;
            private final double area;

            private GeometryWithArea(Geometry geom) {
                this.geom = geom;
                this.area = geom.getArea();
            }
        }

        public static class Builder {
            private GeometryFactory factory;
            private double pixelHeight = 1.0;
            private double pixelWidth = 1.0;
            private double flatness = 0.5;

            public Builder pixelSize(double pixelWidth, double pixelHeight) {
                this.pixelWidth = pixelWidth;
                this.pixelHeight = pixelHeight;
                return this;
            }

            public Builder flatness(double flatness) {
                this.flatness = flatness;
                return this;
            }

            public Builder factory(GeometryFactory factory) {
                this.factory = factory;
                return this;
            }

            public GeometryConverter build() {
                return new GeometryConverter(this.factory, this.pixelWidth, this.pixelHeight, this.flatness);
            }
        }
    }

    private static class GeometryShapeWrapper
    implements Shape {
        private final Shape shape;
        private final Geometry geometry;

        private GeometryShapeWrapper(Geometry geom, Shape shape) {
            this.geometry = geom.copy();
            this.shape = shape;
        }

        @Override
        public Rectangle getBounds() {
            return this.shape.getBounds();
        }

        @Override
        public Rectangle2D getBounds2D() {
            return this.shape.getBounds2D();
        }

        @Override
        public boolean contains(double x, double y) {
            return SimplePointInAreaLocator.isContained((Coordinate)new Coordinate(x, y), (Geometry)this.geometry);
        }

        @Override
        public boolean contains(Point2D p) {
            return this.contains(p.getX(), p.getY());
        }

        @Override
        public boolean intersects(double x, double y, double w, double h) {
            return this.geometry.intersects((Geometry)GeometryTools.createRectangle(x, y, w, h));
        }

        @Override
        public boolean intersects(Rectangle2D r) {
            return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        }

        @Override
        public boolean contains(double x, double y, double w, double h) {
            return false;
        }

        @Override
        public boolean contains(Rectangle2D r) {
            return false;
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at) {
            return this.shape.getPathIterator(at);
        }

        @Override
        public PathIterator getPathIterator(AffineTransform at, double flatness) {
            return this.shape.getPathIterator(at, flatness);
        }
    }
}

