/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.Puntal;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.operation.predicate.RectangleIntersects;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.interfaces.ROI;

public class GeometryROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(GeometryROI.class);
    private final Geometry geometry;
    private boolean checkValid = false;
    private transient GeometryStats stats = null;
    private transient int hashCode;
    private transient PointOnGeometryLocator cachedLocator;

    GeometryROI(Geometry geometry, ImagePlane plane) {
        this(geometry, plane, false);
    }

    GeometryROI(Geometry geometry, ImagePlane plane, boolean checkValid) {
        super(plane);
        this.checkValid = checkValid;
        this.geometry = geometry.copy();
        if (geometry instanceof Polygonal && geometry.getNumPoints() > 1000) {
            logger.trace("Creating IndexedPointInAreaLocator for large geometry");
            this.cachedLocator = new IndexedPointInAreaLocator(geometry);
        }
        if (!Objects.equals(geometry.getPrecisionModel(), GeometryTools.getDefaultFactory().getPrecisionModel())) {
            logger.warn("Geometry precision model for ROI {} does not match default precision model {}", (Object)geometry.getPrecisionModel(), (Object)GeometryTools.getDefaultFactory().getPrecisionModel());
        }
    }

    @Override
    public String getRoiName() {
        return "Geometry";
    }

    @Override
    public double getCentroidX() {
        return this.getGeometryStats().getCentroidX();
    }

    @Override
    public double getCentroidY() {
        return this.getGeometryStats().getCentroidY();
    }

    @Override
    public double getBoundsX() {
        return this.getGeometryStats().getBoundsX();
    }

    @Override
    public double getBoundsY() {
        return this.getGeometryStats().getBoundsY();
    }

    @Override
    public double getBoundsWidth() {
        return this.getGeometryStats().getBoundsWidth();
    }

    @Override
    public double getBoundsHeight() {
        return this.getGeometryStats().getBoundsHeight();
    }

    @Override
    public List<Point2> getAllPoints() {
        return Arrays.stream(this.geometry.getCoordinates()).map(c -> new Point2(c.x, c.y)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GeometryStats getGeometryStats() {
        if (this.stats == null) {
            GeometryROI geometryROI = this;
            synchronized (geometryROI) {
                if (this.stats == null) {
                    this.stats = GeometryROI.computeGeometryStats(this.geometry, 1.0, 1.0, this.checkValid);
                }
                if (this.checkValid && this.stats.isValid()) {
                    this.checkValid = false;
                }
            }
        }
        return this.stats;
    }

    @Override
    public ROI duplicate() {
        return new GeometryROI(this.geometry, this.getImagePlane());
    }

    @Override
    public Geometry getGeometry() {
        return this.geometry.copy();
    }

    @Override
    public Shape getShape() {
        Shape shape = this.getShapeInternal();
        if (shape instanceof Area) {
            return new Area(shape);
        }
        return new Path2D.Float(shape);
    }

    @Override
    public Shape createShape() {
        return GeometryTools.geometryToShape(this.geometry);
    }

    @Override
    public ROI.RoiType getRoiType() {
        if (this.geometry instanceof Puntal) {
            return ROI.RoiType.POINT;
        }
        if (this.geometry instanceof Lineal) {
            return ROI.RoiType.LINE;
        }
        return ROI.RoiType.AREA;
    }

    @Override
    public double getArea() {
        return this.getGeometryStats().getArea();
    }

    @Override
    public double getLength() {
        return this.getGeometryStats().getLength();
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getArea() * pixelWidth * pixelHeight;
        }
        return GeometryROI.computeGeometryStats(this.geometry, pixelWidth, pixelHeight, this.checkValid).getArea();
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getLength() / 2.0 * (pixelWidth + pixelHeight);
        }
        return GeometryROI.computeGeometryStats(this.geometry, pixelWidth, pixelHeight, this.checkValid).getLength();
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.isArea()) {
            Coordinate coord = new Coordinate(x, y);
            if (this.cachedLocator != null) {
                return this.cachedLocator.locate(coord) != 2;
            }
            return SimplePointInAreaLocator.locate((Coordinate)coord, (Geometry)this.geometry) != 2;
        }
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        if (!this.intersectsBounds(x, y, width, height)) {
            return false;
        }
        return RectangleIntersects.intersects((Polygon)GeometryTools.createRectangle(x, y, width, height), (Geometry)this.geometry);
    }

    @Override
    public ROI translate(double dx, double dy) {
        return new GeometryROI(AffineTransformation.translationInstance((double)dx, (double)dy).transform(this.geometry), this.getImagePlane());
    }

    private Object writeReplace() {
        return new WKBSerializationProxy(this);
    }

    static GeometryStats computeGeometryStats(Geometry geometry, double pixelWidth, double pixelHeight, boolean checkValid) {
        if (pixelWidth == 1.0 && pixelHeight == 1.0) {
            return new GeometryStats(geometry, checkValid);
        }
        AffineTransformation transform = AffineTransformation.scaleInstance((double)pixelWidth, (double)pixelHeight);
        return new GeometryStats(transform.transform(geometry), checkValid);
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        AffineTransformation transform = AffineTransformation.scaleInstance((double)scaleX, (double)scaleY, (double)originX, (double)originY);
        return new GeometryROI(transform.transform(this.geometry), this.getImagePlane());
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        return new GeometryROI(this.geometry, plane);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeometryROI that = (GeometryROI)o;
        return Objects.equals(this.getImagePlane(), that.getImagePlane()) && Objects.equals(this.geometry, that.geometry);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.geometry, this.getImagePlane());
        }
        return this.hashCode;
    }

    static class GeometryStats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static String UNKNOWN = "Unknown";
        private double boundsMinX = Double.NaN;
        private double boundsMinY = Double.NaN;
        private double boundsMaxX = Double.NaN;
        private double boundsMaxY = Double.NaN;
        private double centroidX = Double.NaN;
        private double centroidY = Double.NaN;
        private double area = Double.NaN;
        private double length = Double.NaN;
        private String error = UNKNOWN;

        GeometryStats(Geometry geometry, boolean checkValid) {
            Envelope envelope;
            if (checkValid) {
                TopologyValidationError validationError = new IsValidOp(geometry).getValidationError();
                String string = this.error = validationError == null ? null : validationError.getMessage();
            }
            if (checkValid && this.error != null) {
                logger.warn("Stats requested for invalid geometry: " + this.error);
            } else {
                this.area = geometry.getArea();
                this.length = geometry.getLength();
            }
            Point centroid = geometry.getCentroid();
            if (!centroid.isEmpty()) {
                this.centroidX = centroid.getX();
                this.centroidY = centroid.getY();
            }
            if ((envelope = geometry.getEnvelopeInternal()) != null) {
                this.boundsMinX = envelope.getMinX();
                this.boundsMinY = envelope.getMinY();
                this.boundsMaxX = envelope.getMaxX();
                this.boundsMaxY = envelope.getMaxY();
            }
        }

        public double getCentroidX() {
            return this.centroidX;
        }

        public double getCentroidY() {
            return this.centroidY;
        }

        public double getBoundsX() {
            return this.boundsMinX;
        }

        public double getBoundsY() {
            return this.boundsMinY;
        }

        public double getBoundsWidth() {
            return this.boundsMaxX - this.boundsMinX;
        }

        public double getBoundsHeight() {
            return this.boundsMaxY - this.boundsMinY;
        }

        public double getArea() {
            return this.area;
        }

        public double getLength() {
            return this.length;
        }

        public boolean isValid() {
            return this.error == null;
        }

        public String getError() {
            return this.error;
        }
    }

    private static class WKBSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final byte[] wkb;
        private final int c;
        private final int z;
        private final int t;
        private final GeometryStats stats;

        WKBSerializationProxy(GeometryROI roi) {
            this.wkb = new WKBWriter(2).write(roi.geometry);
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
            this.stats = roi.stats;
        }

        private Object readResolve() throws ParseException {
            Geometry geometry = new WKBReader(GeometryTools.getDefaultFactory()).read(this.wkb);
            GeometryROI roi = new GeometryROI(geometry, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            roi.stats = this.stats;
            return roi;
        }
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Geometry geometry;
        private final int c;
        private final int z;
        private final int t;
        private GeometryStats stats;

        SerializationProxy(GeometryROI roi) {
            this.geometry = roi.geometry;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
            this.stats = roi.stats;
        }

        private Object readResolve() {
            GeometryROI roi = new GeometryROI(this.geometry, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            roi.stats = this.stats;
            return roi;
        }
    }
}

