/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.IntStream;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.hprtree.HPRtree;
import org.locationtech.jts.operation.overlayng.UnaryUnionNG;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.roi.GeometryTools;

public class FastPolygonUnion {
    private static final Logger logger = LoggerFactory.getLogger(FastPolygonUnion.class);

    public static Geometry union(Geometry ... geoms) {
        return FastPolygonUnion.union(Arrays.asList(geoms));
    }

    public static Geometry union(Collection<? extends Geometry> geoms) {
        logger.trace("Calling union for {} geometries", (Object)geoms.size());
        List<Polygon> allPolygons = FastPolygonUnion.extractAllPolygons(geoms);
        HPRtree tree = new HPRtree();
        int n = allPolygons.size();
        for (int i2 = 0; i2 < n; ++i2) {
            tree.insert(allPolygons.get(i2).getEnvelopeInternal(), (Object)i2);
        }
        AdjacencyMatrix matrix = new AdjacencyMatrix(n);
        IntStream.range(0, n).parallel().forEach(i -> FastPolygonUnion.populateAdjacencyMatrix(allPolygons, matrix, (SpatialIndex)tree, i));
        ArrayList groupsToMerge = new ArrayList();
        ArrayList<Geometry> toKeep = new ArrayList<Geometry>();
        HashSet<Integer> visited = new HashSet<Integer>();
        for (int i3 = 0; i3 < n; ++i3) {
            if (matrix.getAdjacentCount(i3) == 0) {
                toKeep.add((Geometry)allPolygons.get(i3));
                visited.add(i3);
                continue;
            }
            if (visited.contains(i3)) continue;
            ArrayList<Geometry> temp = new ArrayList<Geometry>();
            for (Integer ind : matrix.getAdjacencyGroup(i3)) {
                temp.add((Geometry)allPolygons.get(ind));
                if (visited.add(ind)) continue;
                logger.warn("Polygon added more than once!");
            }
            groupsToMerge.add(temp);
        }
        logger.debug("Number of polygon collections to merge: {}", (Object)groupsToMerge.size());
        toKeep.addAll(groupsToMerge.parallelStream().map(list -> FastPolygonUnion.unionOpNg(list)).toList());
        return FastPolygonUnion.createPolygonalGeometry(toKeep);
    }

    private static List<Polygon> extractAllPolygons(Collection<? extends Geometry> geoms) {
        ArrayList allPolygons = new ArrayList();
        for (Geometry geometry : geoms) {
            if (geometry == null) continue;
            PolygonExtracter.getPolygons((Geometry)geometry, allPolygons);
        }
        return allPolygons.stream().filter(p -> p != null && !p.isEmpty()).toList();
    }

    private static Geometry unionOpNg(Collection<Geometry> geoms) {
        GeometryFactory factory = GeometryTools.getDefaultFactory();
        if (geoms.isEmpty()) {
            return factory.createPolygon();
        }
        if (geoms.size() == 1) {
            return geoms.iterator().next();
        }
        try {
            return UnaryUnionNG.union(geoms, (GeometryFactory)factory, (PrecisionModel)factory.getPrecisionModel());
        }
        catch (Exception e) {
            logger.error("Error during unary union operation for {} geometries, will attempt with buffer(0)", (Object)geoms.size(), (Object)e);
            return factory.createGeometryCollection((Geometry[])geoms.toArray(Geometry[]::new)).buffer(0.0);
        }
    }

    private static Geometry createPolygonalGeometry(Collection<? extends Geometry> geoms) {
        List<Polygon> list = FastPolygonUnion.extractAllPolygons(geoms);
        if (list.isEmpty()) {
            return GeometryTools.getDefaultFactory().createPolygon();
        }
        if (list.size() == 1) {
            return (Geometry)list.get(0);
        }
        return GeometryTools.getDefaultFactory().createMultiPolygon((Polygon[])list.toArray(Polygon[]::new));
    }

    private static void populateAdjacencyMatrix(List<Polygon> allPolygons, AdjacencyMatrix matrix, SpatialIndex tree, int ind) {
        Polygon poly = allPolygons.get(ind);
        Iterator iterator = tree.query(poly.getEnvelopeInternal()).iterator();
        while (iterator.hasNext()) {
            Polygon poly2;
            int ind2 = (Integer)iterator.next();
            if (ind2 <= ind || matrix.isAdjacent(ind, ind2) || !poly.intersects((Geometry)(poly2 = allPolygons.get(ind2)))) continue;
            matrix.setAdjacent(ind, ind2);
        }
    }

    private static class AdjacencyMatrix {
        private List<BitSet> bits = new ArrayList<BitSet>();

        private AdjacencyMatrix(int n) {
            for (int i = 0; i < n; ++i) {
                this.bits.add(new BitSet(n));
            }
        }

        public boolean setAdjacent(int i, int j) {
            if (this.bits.get(i).get(j)) {
                return false;
            }
            this.bits.get(i).set(j);
            this.bits.get(j).set(i);
            return true;
        }

        public Set<Integer> getAdjacencyGroup(int i) {
            HashSet<Integer> set = new HashSet<Integer>();
            this.accumulateAdjacencyGroup(i, set);
            return set;
        }

        private void accumulateAdjacencyGroup(int i, Set<Integer> group) {
            if (group.add(i)) {
                for (int j : this.bits.get(i).stream().toArray()) {
                    this.accumulateAdjacencyGroup(j, group);
                }
            }
        }

        public int getAdjacentCount(int i) {
            return this.bits.get(i).cardinality();
        }

        public boolean isAdjacent(int i, int j) {
            return this.bits.get(i).get(j);
        }
    }
}

