/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.Point2;
import qupath.lib.roi.Vertices;

class DefaultVertices
implements Vertices {
    private static final Logger logger = LoggerFactory.getLogger(DefaultVertices.class);
    static int DEFAULT_CAPACITY = 16;
    private int size = 0;
    private float[] x;
    private float[] y;

    DefaultVertices(float[] x, float[] y, boolean copyArrays) {
        if (x.length != y.length) {
            throw new RuntimeException("Array lengths " + x.length + " and " + y.length + " do not match!");
        }
        if (copyArrays) {
            this.x = Arrays.copyOf(x, x.length);
            this.y = Arrays.copyOf(y, y.length);
        } else {
            this.x = x;
            this.y = y;
        }
        this.size = this.x.length;
    }

    DefaultVertices() {
        this(DEFAULT_CAPACITY);
    }

    DefaultVertices(int capacity) {
        this.x = new float[capacity];
        this.y = new float[capacity];
        this.size = 0;
    }

    void clear() {
        this.size = 0;
    }

    void add(float x, float y) {
        if (this.size == this.x.length) {
            this.ensureCapacity(this.size + 16);
        }
        this.x[this.size] = x;
        this.y[this.size] = y;
        ++this.size;
    }

    void set(int idx, float x, float y) {
        this.x[idx] = x;
        this.y[idx] = y;
    }

    void close() {
        if (this.size > 1 && (this.x[0] != this.x[this.size - 1] || this.y[0] != this.y[this.size - 1])) {
            this.ensureCapacity(this.size + 1);
            this.x[this.size] = this.x[0];
            this.y[this.size] = this.y[0];
            ++this.size;
        }
        this.compact();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float[] getX(float[] xArray) {
        return this.getArray(this.x, xArray);
    }

    @Override
    public float[] getY(float[] yArray) {
        return this.getArray(this.y, yArray);
    }

    @Override
    public Point2 get(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException(idx + " is greater than size " + this.size);
        }
        return new Point2(this.x[idx], this.y[idx]);
    }

    @Override
    public float getX(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException(idx + " is greater than size " + this.size);
        }
        return this.x[idx];
    }

    @Override
    public float getY(int idx) {
        if (idx >= this.size) {
            throw new ArrayIndexOutOfBoundsException(idx + " is greater than size " + this.size);
        }
        return this.y[idx];
    }

    @Override
    public List<Point2> getPoints() {
        ArrayList<Point2> points = new ArrayList<Point2>(this.size);
        for (int i = 0; i < this.size; ++i) {
            points.add(new Point2(this.x[i], this.y[i]));
        }
        return points;
    }

    void ensureCapacity(int capacity) {
        if (capacity <= this.x.length) {
            return;
        }
        this.x = Arrays.copyOf(this.x, capacity);
        this.y = Arrays.copyOf(this.y, capacity);
    }

    @Override
    public void compact() {
        if (this.size == this.x.length) {
            return;
        }
        this.x = Arrays.copyOf(this.x, this.size);
        this.y = Arrays.copyOf(this.y, this.size);
    }

    float[] getArray(float[] src, float[] dst) {
        if (dst == null || dst.length < this.size()) {
            return Arrays.copyOf(src, this.size);
        }
        System.arraycopy(src, 0, dst, 0, this.size);
        return dst;
    }

    void translate(float dx, float dy) {
        int i = 0;
        while (i < this.size) {
            int n = i;
            this.x[n] = this.x[n] + dx;
            int n2 = i++;
            this.y[n2] = this.y[n2] + dy;
        }
    }

    @Override
    public Vertices duplicate() {
        DefaultVertices v = new DefaultVertices(this.x.length);
        v.x = Arrays.copyOf(this.x, this.x.length);
        v.y = Arrays.copyOf(this.y, this.y.length);
        v.size = this.size;
        return v;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVertices that = (DefaultVertices)o;
        return this.size == that.size && Objects.deepEquals(this.x, that.x) && Objects.deepEquals(this.y, that.y);
    }

    public int hashCode() {
        return Objects.hash(this.size, Arrays.hashCode(this.x), Arrays.hashCode(this.y));
    }
}

