/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.predicate.RectangleIntersects;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AWTAreaROI;
import qupath.lib.roi.AbstractPathROI;
import qupath.lib.roi.ClosedShapeStatistics;
import qupath.lib.roi.DefaultMutableVertices;
import qupath.lib.roi.DefaultVertices;
import qupath.lib.roi.GeometryTools;
import qupath.lib.roi.MutableVertices;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.Vertices;
import qupath.lib.roi.WindingTest;
import qupath.lib.roi.interfaces.ROI;

@Deprecated
public class AreaROI
extends AbstractPathROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient List<MutableVertices> vertices = new ArrayList<MutableVertices>();
    volatile transient Geometry geometry;
    private transient ClosedShapeStatistics stats = null;

    AreaROI(List<? extends Vertices> vertices, ImagePlane plane) {
        super(plane);
        for (Vertices vertices2 : vertices) {
            this.vertices.add(new DefaultMutableVertices(vertices2));
        }
    }

    private AreaROI(float[][] x, float[][] y, ImagePlane plane) {
        super(plane);
        if (x.length != y.length) {
            throw new IllegalArgumentException("Lengths of x and y are different!");
        }
        for (int i = 0; i < x.length; ++i) {
            float[] x2 = x[i];
            float[] y2 = y[i];
            if (x.length != y.length) {
                throw new IllegalArgumentException("Lengths of x and y are different!");
            }
            this.vertices.add(new DefaultMutableVertices(new DefaultVertices(x2, y2, false)));
        }
    }

    public int nVertices() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getNVertices();
    }

    @Override
    public double getArea() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getArea();
    }

    @Override
    public double getLength() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getPerimeter();
    }

    @Override
    public String getRoiName() {
        return "Area";
    }

    @Override
    public double getCentroidX() {
        double centroidX;
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        if (Double.isNaN(centroidX = this.stats.getCentroidX())) {
            return this.getBoundsX() + 0.5 * this.getBoundsWidth();
        }
        return centroidX;
    }

    @Override
    public double getCentroidY() {
        double centroidY;
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        if (Double.isNaN(centroidY = this.stats.getCentroidY())) {
            return this.getBoundsY() + 0.5 * this.getBoundsHeight();
        }
        return centroidY;
    }

    @Override
    public boolean contains(double x, double y) {
        int sum = 0;
        for (Vertices vertices : this.vertices) {
            sum += WindingTest.getWindingNumber(vertices, x, y);
        }
        return sum != 0;
    }

    @Override
    public boolean intersects(double x, double y, double width, double height) {
        if (!this.intersectsBounds(x, y, width, height)) {
            return false;
        }
        return RectangleIntersects.intersects((Polygon)GeometryTools.createRectangle(x, y, width, height), (Geometry)this.getGeometry());
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new AreaROI(this.vertices, this.getImagePlane());
    }

    void calculateShapeMeasurements() {
        this.stats = new ClosedShapeStatistics(this.vertices);
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        float[][] xx = new float[this.vertices.size()][];
        float[][] yy = new float[this.vertices.size()][];
        int idx = 0;
        for (MutableVertices v : this.vertices) {
            float[] x = v.getX(null);
            float[] y = v.getY(null);
            for (int i = 0; i < x.length; ++i) {
                x[i] = (float)((double)x[i] + dx);
                y[i] = (float)((double)y[i] + dy);
            }
            xx[idx] = x;
            yy[idx] = y;
            ++idx;
        }
        return new AreaROI(xx, yy, this.getImagePlane());
    }

    @Override
    public ROI scale(double scaleX, double scaleY, double originX, double originY) {
        float[][] xx = new float[this.vertices.size()][];
        float[][] yy = new float[this.vertices.size()][];
        int idx = 0;
        for (MutableVertices v : this.vertices) {
            float[] x = v.getX(null);
            float[] y = v.getY(null);
            for (int i = 0; i < x.length; ++i) {
                x[i] = (float)RoiTools.scaleOrdinate(x[i], scaleX, originX);
                y[i] = (float)RoiTools.scaleOrdinate(y[i], scaleY, originY);
            }
            xx[idx] = x;
            yy[idx] = y;
            ++idx;
        }
        return new AreaROI(xx, yy, this.getImagePlane());
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getArea() * pixelWidth * pixelHeight;
        }
        return new ClosedShapeStatistics(this.vertices, pixelWidth, pixelHeight).getArea();
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getLength() * (pixelWidth + pixelHeight) * 0.5;
        }
        return new ClosedShapeStatistics(this.vertices, pixelWidth, pixelHeight).getPerimeter();
    }

    @Override
    public double getBoundsX() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsX();
    }

    @Override
    public double getBoundsY() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsY();
    }

    @Override
    public double getBoundsWidth() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsWidth();
    }

    @Override
    public double getBoundsHeight() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsHeight();
    }

    @Override
    public List<Point2> getAllPoints() {
        if (this.vertices == null || this.vertices.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Point2> list = new ArrayList<Point2>();
        for (Vertices vertices : this.vertices) {
            list.addAll(vertices.getPoints());
        }
        return list;
    }

    @Override
    public ROI updatePlane(ImagePlane plane) {
        throw new UnsupportedOperationException("Updating the plane for an AreaROI is not supported!");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AreaROI that = (AreaROI)o;
        return Objects.equals(this.getImagePlane(), that.getImagePlane()) && Objects.equals(this.getGeometry(), that.getGeometry());
    }

    public int hashCode() {
        return Objects.hash(this.getGeometry(), this.getImagePlane());
    }

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required for reading");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Geometry getGeometry() {
        if (this.geometry == null) {
            AreaROI areaROI = this;
            synchronized (areaROI) {
                if (this.geometry == null) {
                    this.geometry = super.getGeometry();
                }
            }
        }
        return this.geometry;
    }

    @Override
    public Shape getShape() {
        Shape shape = this.getShapeInternal();
        if (shape instanceof Area) {
            return new Area(shape);
        }
        return new Path2D.Float(this.getShapeInternal());
    }

    @Override
    protected Shape createShape() {
        return new AWTAreaROI(this).getShape();
    }

    @Override
    public ROI.RoiType getRoiType() {
        return ROI.RoiType.AREA;
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float[][] x;
        private final float[][] y;
        private final String name;
        private final int c;
        private final int z;
        private final int t;
        private ClosedShapeStatistics stats;

        SerializationProxy(AreaROI roi) {
            int n = roi.vertices.size();
            this.x = new float[n][];
            this.y = new float[n][];
            for (int i = 0; i < n; ++i) {
                this.x[i] = roi.vertices.get(i).getX(null);
                this.y[i] = roi.vertices.get(i).getY(null);
            }
            this.name = null;
            this.c = roi.c;
            this.z = roi.z;
            this.t = roi.t;
            this.stats = roi.stats;
        }

        private Object readResolve() {
            AreaROI roi = new AreaROI(this.x, this.y, ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
            roi.stats = this.stats;
            return roi;
        }
    }
}

