/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.util.Objects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AbstractPathROI;

abstract class AbstractPathBoundedROI
extends AbstractPathROI {
    protected double x;
    protected double y;
    protected double x2;
    protected double y2;

    AbstractPathBoundedROI(double x, double y, ImagePlane plane) {
        this(x, y, 0.0, 0.0, plane);
    }

    AbstractPathBoundedROI(double x, double y) {
        this(x, y, 0.0, 0.0, null);
    }

    AbstractPathBoundedROI() {
    }

    AbstractPathBoundedROI(double x, double y, double width, double height, ImagePlane plane) {
        super(plane);
        this.x = x;
        this.y = y;
        this.x2 = x + width;
        this.y2 = y + height;
        this.ensureOrder();
    }

    void ensureOrder() {
        double temp;
        if (this.x2 < this.x) {
            temp = this.x;
            this.x = this.x2;
            this.x2 = temp;
        }
        if (this.y2 < this.y) {
            temp = this.y;
            this.y = this.y2;
            this.y2 = temp;
        }
    }

    @Override
    public double getCentroidX() {
        return (this.x + this.x2) * 0.5;
    }

    @Override
    public double getCentroidY() {
        return (this.y + this.y2) * 0.5;
    }

    @Override
    public abstract boolean contains(double var1, double var3);

    @Override
    public boolean isEmpty() {
        return this.x == this.x2 || this.y == this.y2;
    }

    @Override
    public double getBoundsX() {
        return Math.min(this.x, this.x2);
    }

    @Override
    public double getBoundsY() {
        return Math.min(this.y, this.y2);
    }

    @Override
    public double getBoundsWidth() {
        return Math.abs(this.x - this.x2);
    }

    @Override
    public double getBoundsHeight() {
        return Math.abs(this.y - this.y2);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPathBoundedROI that = (AbstractPathBoundedROI)o;
        return Double.compare(this.x, that.x) == 0 && Double.compare(this.y, that.y) == 0 && Double.compare(this.x2, that.x2) == 0 && Double.compare(this.y2, that.y2) == 0 && this.getImagePlane().equals(that.getImagePlane());
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.x2, this.y2, this.getImagePlane());
    }
}

