/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.roi;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import qupath.lib.common.GeneralTools;
import qupath.lib.geom.Point2;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.AreaROI;
import qupath.lib.roi.ClosedShapeStatistics;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.Vertices;
import qupath.lib.roi.interfaces.ROI;

@Deprecated
class AWTAreaROI
extends AreaROI
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Path2D shape;
    private transient ClosedShapeStatistics stats = null;

    AWTAreaROI(Shape shape, ImagePlane plane) {
        super(RoiTools.getVertices(shape), plane);
        this.shape = new Path2D.Float(shape);
    }

    AWTAreaROI(AreaROI roi) {
        super(roi.vertices, roi.getImagePlane());
        this.shape = new Path2D.Float();
        for (Vertices vertices : this.vertices) {
            if (vertices.isEmpty()) continue;
            this.shape.moveTo(vertices.getX(0), vertices.getY(0));
            for (int i = 1; i < vertices.size(); ++i) {
                this.shape.lineTo(vertices.getX(i), vertices.getY(i));
            }
            this.shape.closePath();
        }
    }

    @Override
    public int nVertices() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getNVertices();
    }

    @Override
    public double getArea() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getArea();
    }

    @Override
    public double getLength() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getPerimeter();
    }

    @Override
    public Shape getShape() {
        return this.createShape();
    }

    @Override
    protected Shape getShapeInternal() {
        return this.shape;
    }

    @Override
    protected Shape createShape() {
        return new Path2D.Float(this.shape);
    }

    @Override
    public String getRoiName() {
        return "Area (AWT)";
    }

    @Override
    public double getCentroidX() {
        double centroidX;
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        if (Double.isNaN(centroidX = this.stats.getCentroidX())) {
            return this.getBoundsX() + 0.5 * this.getBoundsWidth();
        }
        return centroidX;
    }

    @Override
    public double getCentroidY() {
        double centroidY;
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        if (Double.isNaN(centroidY = this.stats.getCentroidY())) {
            return this.getBoundsY() + 0.5 * this.getBoundsHeight();
        }
        return centroidY;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    @Deprecated
    public ROI duplicate() {
        return new AWTAreaROI(this.shape, this.getImagePlane());
    }

    @Override
    void calculateShapeMeasurements() {
        this.stats = new ClosedShapeStatistics(this.shape);
    }

    @Override
    public ROI translate(double dx, double dy) {
        if (dx == 0.0 && dy == 0.0) {
            return this;
        }
        AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
        return new AWTAreaROI(new Path2D.Float(this.shape, at), this.getImagePlane());
    }

    @Override
    public double getScaledArea(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getArea() * pixelWidth * pixelHeight;
        }
        return new ClosedShapeStatistics(this.shape, pixelWidth, pixelHeight).getArea();
    }

    @Override
    public double getScaledLength(double pixelWidth, double pixelHeight) {
        if (GeneralTools.almostTheSame(pixelWidth, pixelHeight, 1.0E-4)) {
            return this.getLength() * (pixelWidth + pixelHeight) * 0.5;
        }
        return new ClosedShapeStatistics(this.shape, pixelWidth, pixelHeight).getPerimeter();
    }

    @Override
    public double getBoundsX() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsX();
    }

    @Override
    public double getBoundsY() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsY();
    }

    @Override
    public double getBoundsWidth() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsWidth();
    }

    @Override
    public double getBoundsHeight() {
        if (this.stats == null) {
            this.calculateShapeMeasurements();
        }
        return this.stats.getBoundsHeight();
    }

    @Override
    public List<Point2> getAllPoints() {
        if (this.shape == null) {
            return Collections.emptyList();
        }
        return RoiTools.getLinearPathPoints(this.shape, this.shape.getPathIterator(null, 0.5));
    }

    private Object writeReplace() {
        AreaROI roi = new AreaROI(RoiTools.getVertices(this.shape), ImagePlane.getPlaneWithChannel(this.c, this.z, this.t));
        return roi;
    }
}

