/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.regions;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.interfaces.ROI;

public class ImageRegion {
    private static final Logger logger = LoggerFactory.getLogger(ImageRegion.class);
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int z;
    private final int t;

    public String toString() {
        return "Region: x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height + ", z=" + this.z + ", t=" + this.t;
    }

    ImageRegion(int x, int y, int width, int height, int z, int t) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.z = z;
        this.t = t;
    }

    public static ImageRegion createInstance(int x, int y, int width, int height, int z, int t) {
        if (width < 0) {
            throw new IllegalArgumentException("Width must be >= 0! Requested width = " + width);
        }
        if (height < 0) {
            throw new IllegalArgumentException("Height must be >= 0! Requested height = " + height);
        }
        return new ImageRegion(x, y, width, height, z, t);
    }

    public static ImageRegion createInstance(ROI pathROI) {
        int x1 = (int)pathROI.getBoundsX();
        int y1 = (int)pathROI.getBoundsY();
        int x2 = (int)Math.ceil(pathROI.getBoundsX() + pathROI.getBoundsWidth());
        int y2 = (int)Math.ceil(pathROI.getBoundsY() + pathROI.getBoundsHeight());
        return ImageRegion.createInstance(x1, y1, x2 - x1, y2 - y1, pathROI.getZ(), pathROI.getT());
    }

    public static ImageRegion createInstance(Collection<? extends ROI> rois) {
        if (rois.isEmpty()) {
            return new ImageRegion(0, 0, 0, 0, 0, 0);
        }
        if (rois.size() == 1) {
            return ImageRegion.createInstance(rois.iterator().next());
        }
        double xMin = Double.POSITIVE_INFINITY;
        double xMax = Double.NEGATIVE_INFINITY;
        double yMin = Double.POSITIVE_INFINITY;
        double yMax = Double.NEGATIVE_INFINITY;
        ImagePlane plane = null;
        for (ROI rOI : rois) {
            if (plane == null) {
                plane = rOI.getImagePlane();
            } else if (plane.getT() != rOI.getT() || plane.getZ() != rOI.getZ()) {
                throw new IllegalArgumentException("Failed to create ImageRegion for multiple ROIs, ImagePlanes do not match!");
            }
            xMin = Math.min(xMin, rOI.getBoundsX());
            yMin = Math.min(yMin, rOI.getBoundsY());
            xMax = Math.max(xMax, rOI.getBoundsX() + rOI.getBoundsWidth());
            yMax = Math.max(yMax, rOI.getBoundsY() + rOI.getBoundsHeight());
        }
        int x1 = (int)Math.floor(xMin);
        int n = (int)Math.floor(yMin);
        int x2 = (int)Math.ceil(xMax);
        int y2 = (int)Math.ceil(yMax);
        return ImageRegion.createInstance(x1, n, x2 - x1, y2 - n, plane.getZ(), plane.getT());
    }

    public boolean intersects(ImageRegion request) {
        return !(this.z >= 0 && this.z != request.z && request.z >= 0 || this.t >= 0 && this.t != request.t && request.t >= 0 || !this.intersects(request.x, request.y, request.width, request.height));
    }

    public boolean intersects(double x2, double y2, double w2, double h2) {
        if (w2 <= 0.0 || h2 <= 0.0) {
            return false;
        }
        return x2 + w2 > (double)this.x && y2 + h2 > (double)this.y && x2 < (double)(this.x + this.width) && y2 < (double)(this.y + this.height);
    }

    public boolean contains(int x, int y, int z, int t) {
        return this.getZ() == z && this.getT() == t && x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getY() && y < this.getY() + this.getHeight();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getZ() {
        return this.z;
    }

    public int getT() {
        return this.t;
    }

    public int getMinX() {
        return Math.min(this.getX(), this.getX() + this.getWidth());
    }

    public int getMaxX() {
        return Math.max(this.getX(), this.getX() + this.getWidth());
    }

    public int getMinY() {
        return Math.min(this.getY(), this.getY() + this.getHeight());
    }

    public int getMaxY() {
        return Math.max(this.getY(), this.getY() + this.getHeight());
    }

    public ImagePlane getImagePlane() {
        return ImagePlane.getPlane(this.getZ(), this.getT());
    }

    @Deprecated
    public ImagePlane getPlane() {
        LogTools.warnOnce(logger, this.getClass().getSimpleName() + ".getPlane() is deprecated in v0.4.0 - use getImagePlane() instead");
        return this.getImagePlane();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.height;
        result = 31 * result + this.t;
        result = 31 * result + this.width;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImageRegion other = (ImageRegion)obj;
        if (this.height != other.height) {
            return false;
        }
        if (this.t != other.t) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

