/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.regions;

import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

public class ImagePlane
implements Comparable<ImagePlane> {
    private final int c;
    private final int z;
    private final int t;
    private static ImagePlane DEFAULT_PLANE = new ImagePlane(-1, 0, 0);
    private static final int NUM_DEFAULTS = 10;
    private static final ImagePlane[][] DEFAULTS_WITHOUT_CHANNEL = new ImagePlane[10][10];
    private static final ImagePlane[][][] DEFAULTS_WITH_CHANNEL = new ImagePlane[10][10][10];

    private ImagePlane(int c, int z, int t) {
        this.c = c;
        this.z = z;
        this.t = t;
    }

    public int getC() {
        return this.c;
    }

    public int getZ() {
        return this.z;
    }

    public int getT() {
        return this.t;
    }

    @Override
    public int compareTo(ImagePlane o) {
        int tCompare = Integer.compare(this.t, o.t);
        if (tCompare != 0) {
            return tCompare;
        }
        int zCompare = Integer.compare(this.z, o.z);
        if (zCompare != 0) {
            return zCompare;
        }
        return Integer.compare(this.c, o.c);
    }

    int compareToWithoutChannel(ImagePlane o) {
        int tCompare = Integer.compare(this.t, o.t);
        if (tCompare != 0) {
            return tCompare;
        }
        return Integer.compare(this.z, o.z);
    }

    public String toString() {
        return "ImagePlane (z=" + this.z + ", t=" + this.t + ", c=" + this.c + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.c;
        result = 31 * result + this.t;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImagePlane other = (ImagePlane)obj;
        if (this.c != other.c) {
            return false;
        }
        if (this.t != other.t) {
            return false;
        }
        return this.z == other.z;
    }

    public static ImagePlane getPlane(int z, int t) {
        if (z == 0 && t == 0) {
            return DEFAULT_PLANE;
        }
        return ImagePlane.getPlaneWithChannel(-1, z, t);
    }

    public static ImagePlane getDefaultPlane() {
        return DEFAULT_PLANE;
    }

    public static ImagePlane getPlaneWithChannel(ROI roi) {
        return ImagePlane.getPlaneWithChannel(roi.getC(), roi.getZ(), roi.getT());
    }

    public static ImagePlane getPlane(ROI roi) {
        return ImagePlane.getPlane(roi.getZ(), roi.getT());
    }

    public static ImagePlane getPlane(ImageRegion region) {
        return ImagePlane.getPlane(region.getZ(), region.getT());
    }

    public static ImagePlane getPlaneWithChannel(int c, int z, int t) {
        if (c == -1 && z == 0 && t == 0) {
            return DEFAULT_PLANE;
        }
        if (z < 0 || t < 0) {
            throw new IllegalArgumentException("Both z and t need to be >= 0, values provided are " + z + ", " + t);
        }
        if (c < -1) {
            throw new IllegalArgumentException("Channel needs to be -1 (for no channel), or >= 0, value provided is " + c);
        }
        if (z < 10 && t < 10) {
            if (c == -1) {
                return DEFAULTS_WITHOUT_CHANNEL[t][z];
            }
            if (c < 10) {
                return DEFAULTS_WITH_CHANNEL[c][t][z];
            }
        }
        return new ImagePlane(c, z, t);
    }

    static {
        for (int t = 0; t < 10; ++t) {
            for (int z = 0; z < 10; ++z) {
                ImagePlane.DEFAULTS_WITHOUT_CHANNEL[t][z] = new ImagePlane(-1, z, t);
                for (int c = 0; c < 10; ++c) {
                    ImagePlane.DEFAULTS_WITH_CHANNEL[c][t][z] = new ImagePlane(c, z, t);
                }
            }
        }
    }
}

