/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.projects;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.io.GsonTools;

public class ResourceManager {
    private static Map<String, Path> getNameMap(Path path, String ext) throws IOException {
        if (path == null || !Files.isDirectory(path, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try (Stream<Path> stream = Files.list(path);){
            Map<String, Path> map = stream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(ext)).collect(Collectors.toMap(p -> ResourceManager.nameWithoutExtension(p, ext), p -> p));
            return map;
        }
    }

    private static Collection<String> listFilenames(Path path, String ext) throws IOException {
        return ResourceManager.getNameMap(path, ext).keySet();
    }

    private static String nameWithoutExtension(Path path, String ext) {
        String name = path.getFileName().toString();
        if (name.endsWith(ext)) {
            return name.substring(0, name.length() - ext.length());
        }
        return name;
    }

    private static Path ensureDirectoryExists(Path path) throws IOException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        return path;
    }

    static class JsonFileResourceManager<T>
    extends FileResourceManager<T> {
        private Charset charset = StandardCharsets.UTF_8;
        private Class<T> cls;

        JsonFileResourceManager(Path dir, Class<T> cls) {
            super(dir, ".json");
            this.cls = cls;
        }

        @Override
        protected T readFromFile(Path path) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(path, this.charset);){
                Object object = GsonTools.getInstance().fromJson((Reader)reader, this.cls);
                return (T)object;
            }
        }

        @Override
        protected void writeToFile(Path path, T resource) throws IOException {
            try (BufferedWriter writer = Files.newBufferedWriter(path, this.charset, new OpenOption[0]);){
                Gson gson = GsonTools.getInstance(true);
                gson.toJson(resource, this.cls, (Appendable)writer);
            }
        }
    }

    static class ImageResourceManager<T>
    extends FileResourceManager<ImageServer<T>> {
        private Class<T> cls;

        ImageResourceManager(Path dir, Class<T> cls) {
            super(dir, ".json");
            this.cls = cls;
        }

        @Override
        protected ImageServer<T> readFromFile(Path path) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                ImageServer imageServer = (ImageServer)GsonTools.getInstance().fromJson((Reader)reader, new TypeToken<ImageServer<T>>(this){}.getType());
                return imageServer;
            }
        }

        @Override
        protected void writeToFile(Path path, ImageServer<T> resource) throws IOException {
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                GsonTools.getInstance().toJson(resource, (Appendable)writer);
            }
        }
    }

    static class StringFileResourceManager
    extends FileResourceManager<String> {
        private Charset charset = StandardCharsets.UTF_8;

        StringFileResourceManager(Path dir) {
            super(dir, ".txt");
        }

        StringFileResourceManager(Path dir, String ext) {
            super(dir, ext);
        }

        @Override
        protected String readFromFile(Path path) throws IOException {
            return Files.readString(path, this.charset);
        }

        @Override
        protected void writeToFile(Path path, String resource) throws IOException {
            Files.writeString(path, (CharSequence)resource, this.charset, new OpenOption[0]);
        }
    }

    static abstract class FileResourceManager<T>
    implements Manager<T> {
        private static final Logger logger = LoggerFactory.getLogger(FileResourceManager.class);
        protected String ext;
        protected Path dir;

        FileResourceManager(Path dir, String ext) {
            this.dir = dir;
            this.ext = ext.startsWith(".") ? ext : "." + ext;
        }

        @Override
        public Collection<String> getNames() throws IOException {
            return ResourceManager.listFilenames(this.dir, this.ext);
        }

        @Override
        public boolean remove(String name) throws IOException {
            Path path = this.getPathForName(name, true);
            if (path != null && Files.exists(path, new LinkOption[0])) {
                logger.debug("Deleting resource '{}' from {}", (Object)name, (Object)path);
                GeneralTools.deleteFile(path.toFile(), true);
                return true;
            }
            return false;
        }

        protected abstract T readFromFile(Path var1) throws IOException;

        protected abstract void writeToFile(Path var1, T var2) throws IOException;

        @Override
        public T get(String name) throws IOException {
            Path path = this.getPathForName(name, true);
            if (path != null && Files.exists(path, new LinkOption[0])) {
                logger.debug("Reading resource '{}' from {}", (Object)name, (Object)path);
                return this.readFromFile(path);
            }
            throw new IOException("No resource found with name '" + name + "'");
        }

        @Override
        public void put(String name, T resource) throws IOException {
            Path path = this.getPathForName(name, false);
            logger.debug("Writing resource '{}' to {}", (Object)name, (Object)path);
            this.writeToFile(path, resource);
            Path pathRequested = Paths.get(this.dir.toString(), name + this.ext);
            if (!path.equals(pathRequested)) {
                logger.debug("Renaming {} to {}", (Object)path, (Object)pathRequested);
                Files.move(path, pathRequested, StandardCopyOption.ATOMIC_MOVE);
            }
        }

        protected Path getPathForName(String name, boolean nullIfMissing) throws IOException {
            Map<String, Path> map = ResourceManager.getNameMap(this.dir, this.ext);
            Path path = map.getOrDefault(name, null);
            if (path == null) {
                for (Map.Entry<String, Path> entry : map.entrySet()) {
                    if (!name.equalsIgnoreCase(entry.getKey())) continue;
                    return entry.getValue();
                }
            }
            if (path != null) {
                return path;
            }
            if (nullIfMissing) {
                return null;
            }
            ResourceManager.ensureDirectoryExists(this.dir);
            return Paths.get(this.dir.toString(), name + this.ext);
        }
    }

    public static interface Manager<T> {
        public Collection<String> getNames() throws IOException;

        public T get(String var1) throws IOException;

        public void put(String var1, T var2) throws IOException;

        public boolean remove(String var1) throws IOException;

        default public boolean contains(String name) throws IOException {
            Collection<String> names = this.getNames();
            for (String n : names) {
                if (!name.equalsIgnoreCase(n)) continue;
                return true;
            }
            return false;
        }
    }
}

