/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.projects;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import qupath.lib.projects.DefaultProject;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;

public class Projects {
    public static File getBaseDirectory(Project<?> project) {
        Path path;
        Path path2 = path = project == null ? null : project.getPath();
        if (path == null) {
            return null;
        }
        File file = path.toFile();
        if (file.isDirectory()) {
            return file;
        }
        return (file = file.getParentFile()).isDirectory() ? file : null;
    }

    public static <T> Project<T> createProject(File file, Class<T> cls) {
        if (file.isDirectory()) {
            file = new File(file, "project" + ProjectIO.getProjectExtension(true));
        }
        if (cls == BufferedImage.class) {
            return new DefaultProject(file);
        }
        throw new IllegalArgumentException("Cannot create project for " + String.valueOf(cls));
    }

    static class ImageEntryComparator
    implements Comparator<ProjectImageEntry<?>> {
        static ImageEntryComparator instance = new ImageEntryComparator();

        ImageEntryComparator() {
        }

        @Override
        public int compare(ProjectImageEntry<?> o1, ProjectImageEntry<?> o2) {
            String n1 = o1.getImageName();
            String n2 = o2.getImageName();
            if (n1 == null) {
                if (n2 == null) {
                    return 0;
                }
                return 1;
            }
            if (n2 == null) {
                return -1;
            }
            return n1.compareTo(n2);
        }
    }
}

