/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.projects;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.interfaces.MinimalMetadataStore;
import qupath.lib.io.UriResource;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.projects.ResourceManager;

public interface ProjectImageEntry<T>
extends UriResource,
MinimalMetadataStore {
    public String getID();

    public void setImageName(String var1);

    public String getImageName();

    public String getOriginalImageName();

    public Path getEntryPath();

    @Deprecated
    default public String removeMetadataValue(String key) {
        return this.getMetadata().remove(key);
    }

    @Deprecated
    default public String getMetadataValue(String key) {
        return this.getMetadata().get(key);
    }

    @Deprecated
    default public String putMetadataValue(String key, String value) {
        return this.getMetadata().put(key, value);
    }

    @Deprecated
    default public boolean containsMetadata(String key) {
        return this.getMetadata().containsKey(key);
    }

    public String getDescription();

    public void setDescription(String var1);

    @Deprecated
    default public void clearMetadata() {
        this.getMetadata().clear();
    }

    @Deprecated
    default public Map<String, String> getMetadataMap() {
        return Collections.unmodifiableMap(this.getMetadata());
    }

    @Deprecated
    default public Collection<String> getMetadataKeys() {
        return this.getMetadata().keySet();
    }

    public ImageServerBuilder.ServerBuilder<T> getServerBuilder();

    public ImageData<T> readImageData() throws IOException;

    public void saveImageData(ImageData<T> var1) throws IOException;

    public PathObjectHierarchy readHierarchy() throws IOException;

    public boolean hasImageData();

    public String getSummary();

    public T getThumbnail() throws IOException;

    public void setThumbnail(T var1) throws IOException;

    default public String getMetadataSummaryString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String> entry : this.getMetadata().entrySet()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public ResourceManager.Manager<ImageServer<T>> getImages();

    public Set<String> getTags();
}

