/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.projects;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.projects.DefaultProject;
import qupath.lib.projects.Project;

public class ProjectIO {
    private static final Logger logger = LoggerFactory.getLogger(ProjectIO.class);
    public static final String DEFAULT_PROJECT_NAME = "project";
    public static final String DEFAULT_PROJECT_EXTENSION = "qpproj";

    public static <T> Project<T> loadProject(URI uri, Class<T> cls) throws IOException {
        return ProjectIO.loadProject(Paths.get(uri).toFile(), cls);
    }

    public static <T> Project<T> loadProject(File fileProject, Class<T> cls) throws IOException {
        if (cls.equals(BufferedImage.class)) {
            logger.debug("Loading project from {}", (Object)fileProject);
            try (BufferedReader fileReader = new BufferedReader(new FileReader(fileProject));){
                DefaultProject defaultProject = DefaultProject.loadFromFile(fileProject);
                return defaultProject;
            }
        }
        throw new IllegalArgumentException("Cannot load project with generic class " + String.valueOf(cls));
    }

    public static String getProjectExtension(boolean includePeriod) {
        return includePeriod ? ".qpproj" : DEFAULT_PROJECT_EXTENSION;
    }

    public static String getProjectExtension() {
        return DEFAULT_PROJECT_EXTENSION;
    }
}

