/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.projects;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.interfaces.MinimalMetadataStore;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.ResourceManager;

public interface Project<T>
extends MinimalMetadataStore {
    public List<PathClass> getPathClasses();

    public boolean getMaskImageNames();

    public void setMaskImageNames(boolean var1);

    public boolean setPathClasses(Collection<? extends PathClass> var1);

    public URI getURI();

    public URI getPreviousURI();

    public static String getNameFromURI(URI uri) {
        if (uri == null) {
            return "No URI";
        }
        String[] path = uri.getPath().split("/");
        if (path.length == 0) {
            return "No name";
        }
        String name = path[path.length - 1];
        String ext = ProjectIO.getProjectExtension(true);
        if (name.endsWith(ext)) {
            name = name.substring(0, name.length() - ext.length());
        }
        if (path.length == 1) {
            return name;
        }
        return path[path.length - 2] + "-" + name;
    }

    public String getVersion();

    public Path getPath();

    public Project<T> createSubProject(String var1, Collection<ProjectImageEntry<T>> var2);

    public boolean isEmpty();

    public ProjectImageEntry<T> addImage(ImageServerBuilder.ServerBuilder<T> var1) throws IOException;

    public ProjectImageEntry<T> addDuplicate(ProjectImageEntry<T> var1, boolean var2) throws IOException;

    public ProjectImageEntry<T> getEntry(ImageData<T> var1);

    public void removeImage(ProjectImageEntry<?> var1, boolean var2);

    public void removeAllImages(Collection<ProjectImageEntry<T>> var1, boolean var2);

    public void syncChanges() throws IOException;

    public List<ProjectImageEntry<T>> getImageList();

    public String getName();

    public long getCreationTimestamp();

    public long getModificationTimestamp();

    default public ResourceManager.Manager<String> getScripts() {
        return this.getResources("scripts", String.class, "groovy");
    }

    default public ResourceManager.Manager<ObjectClassifier<T>> getObjectClassifiers() {
        return this.getResources("classifiers/object_classifiers", ObjectClassifier.class, "json");
    }

    default public ResourceManager.Manager<PixelClassifier> getPixelClassifiers() {
        return this.getResources("classifiers/pixel_classifiers", PixelClassifier.class, "json");
    }

    default public <S, R extends S> ResourceManager.Manager<R> getResources(String location, Class<S> cls, String ext) {
        return null;
    }
}

